/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.internal.ClientProviderFactory;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.scm.svn.client.ISvnClientLibrary;
import com.ibm.team.scm.svn.common.ISvnRepository;
import com.ibm.team.scm.svn.rcp.ui.internal.ActionDelegate;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.Utils;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.PromptForBugtraqPropertiesDialog;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.PromptForTeamRepositoryDialog;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractWorkItemAction
extends ActionDelegate {
    public static IWorkItemHandle[] openWorkItemPicker(Shell parent, IWorkbenchPage page, ITeamRepository repository) {
        WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(parent, repository, true);
        dialog.setTitle(SVNRCPMessages.AbstractWorkItemAction_0);
        if (dialog.open() == 0) {
            return (IWorkItemHandle[])dialog.getResult();
        }
        return new IWorkItemHandle[0];
    }

    @Override
    public boolean isEnabled() {
        IURIReference ref = this.getSelectedRevisionReference(this.getSelection());
        return ref != null;
    }

    public static ProviderFactory getProviderFactory(ITeamRepository repository) {
        return new ClientProviderFactory(repository);
    }

    protected ITeamRepository getTeamRepository(UIContext context, IStructuredSelection selection, IProgressMonitor monitor) throws TeamRepositoryException {
        if (selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            ITeamRepository teamRepository = this.getWorkItemAdapter().getTeamRepository(firstElement);
            if (teamRepository == null) {
                TeamRepositoryConnectionWrapper wrapper;
                String url = this.getWorkItemAdapter().getRepositoryUrl(firstElement);
                if (url != null) {
                    teamRepository = this.findConnectedTeamRepository(url, monitor);
                }
                if (teamRepository == null && (wrapper = this.promptForTeamRepository(context, firstElement)) != null && (teamRepository = wrapper.repository) != null && url != null && wrapper.createConnecton) {
                    this.createSvnComponent(teamRepository, url, monitor);
                }
                if (teamRepository != null) {
                    this.getWorkItemAdapter().linkProjectToRepository(firstElement, teamRepository);
                }
            }
            if (teamRepository != null && !teamRepository.loggedIn()) {
                teamRepository.login(monitor);
            }
            return teamRepository;
        }
        return null;
    }

    private ITeamRepository findConnectedTeamRepository(String url, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        TeamRepositoryException exception = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 100));
        int i = 0;
        while (i < repositories.length) {
            ITeamRepository teamRepository = repositories[i];
            if (teamRepository.loggedIn()) {
                ISvnClientLibrary clientLibrary = Utils.getClientLibrary(teamRepository);
                try {
                    ISvnRepository repo = clientLibrary.getRepository(url, true, (IProgressMonitor)progress.newChild(100));
                    if (repo != null) {
                        return teamRepository;
                    }
                }
                catch (TeamRepositoryException e) {
                    exception = e;
                }
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    private void createSvnComponent(ITeamRepository teamRepository, String url, IProgressMonitor monitor) throws TeamRepositoryException {
        ISvnClientLibrary clientLibrary = Utils.getClientLibrary(teamRepository);
        clientLibrary.createRepository(url, monitor);
    }

    private TeamRepositoryConnectionWrapper promptForTeamRepository(final UIContext context, final Object revision) {
        final TeamRepositoryConnectionWrapper[] repo = new TeamRepositoryConnectionWrapper[1];
        if (Display.getCurrent() == null) {
            context.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    repo[0] = AbstractWorkItemAction.this.internalPromptForRepository(context, revision);
                }
            });
        } else {
            repo[0] = this.internalPromptForRepository(context, revision);
        }
        return repo[0];
    }

    protected TeamRepositoryConnectionWrapper internalPromptForRepository(UIContext context, Object revision) {
        IProject project = this.getWorkItemAdapter().getProject(revision);
        if (project == null) {
            String url = this.getWorkItemAdapter().getRepositoryUrl(revision);
            PromptForTeamRepositoryDialog dialog = new PromptForTeamRepositoryDialog(context.getShell(), url);
            if (dialog.open() == 0) {
                TeamRepositoryConnectionWrapper wrapper = new TeamRepositoryConnectionWrapper();
                wrapper.repository = dialog.getTeamRepository();
                wrapper.createConnecton = true;
                return wrapper;
            }
        } else {
            PromptForBugtraqPropertiesDialog dialog = new PromptForBugtraqPropertiesDialog(context.getShell(), project, this.getWorkItemAdapter());
            if (dialog.open() == 0) {
                TeamRepositoryConnectionWrapper wrapper = new TeamRepositoryConnectionWrapper();
                wrapper.repository = dialog.getTeamRepository();
                wrapper.createConnecton = dialog.isCreateConnection();
                return wrapper;
            }
        }
        return null;
    }

    protected IURIReference getSelectedRevisionReference(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            return this.getWorkItemAdapter().getSelectedRevisionReference(firstElement);
        }
        return null;
    }

    protected abstract SVNWorkItemAdapter getWorkItemAdapter();

    private class TeamRepositoryConnectionWrapper {
        ITeamRepository repository;
        boolean createConnecton;

        private TeamRepositoryConnectionWrapper() {
        }
    }
}

