/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.view;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.svn.client.ISvnClientLibrary;
import com.ibm.team.scm.svn.common.ISvnRepository;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.view.SvnRepositoryWrapper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class SvnRepositoryQuery
extends RepositoryQuery<SvnRepositoryWrapper>
implements IListener {
    boolean cachePrimed = false;

    public SvnRepositoryQuery(ITeamRepository repository, IOperationRunner runner) {
        super(repository, runner);
    }

    protected void attachListeners() {
        this.getClientLibrary().addGenericListener((Object)"repositories", (IListener)this);
    }

    protected void detachListeners() {
        this.getClientLibrary().removeGenericListener((Object)"repositories", (IListener)this);
    }

    protected List<SvnRepositoryWrapper> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ISvnClientLibrary client = this.getClientLibrary();
        if (client == null) {
            throw new TeamRepositoryException(SVNRCPMessages.SvnRepositoryQuery_0);
        }
        ArrayList<SvnRepositoryWrapper> result = new ArrayList<SvnRepositoryWrapper>();
        ISvnRepository[] repos = client.getRepositories(needsRefresh || !this.cachePrimed, monitor);
        int i = 0;
        while (i < repos.length) {
            ISvnRepository svnRepository = repos[i];
            result.add(new SvnRepositoryWrapper(this.getRepository(), (IItem)svnRepository));
            ++i;
        }
        this.cachePrimed = true;
        return result;
    }

    public String getName() {
        return SVNRCPMessages.SvnRepositoryQuery_1;
    }

    private ISvnClientLibrary getClientLibrary() {
        return (ISvnClientLibrary)this.getRepository().getClientLibrary(ISvnClientLibrary.class);
    }

    public void handleEvents(List events) {
        this.update();
    }
}

