/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.importz.IImportData;
import com.ibm.team.scm.client.importz.IMigrationFactory;
import com.ibm.team.scm.client.importz.internal.ui.ImportConfiguration;
import com.ibm.team.scm.client.importz.internal.ui.ImportOperation;
import com.ibm.team.scm.client.importz.svn.internal.ISVN2ComponentPathMapping;
import com.ibm.team.scm.client.importz.svn.internal.SimpleSVN2ComponentPathMapping;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.Credentials;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.ImportFromSVNClientWizard;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.PasswordDialog;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNImportData;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNMigrationFactory;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNRepositoryInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class SVNImportOperation
extends ImportOperation {
    public static void importFromSVN(UIContext context, String repositoryUrl, String[] folderPaths) {
        ISVN2ComponentPathMapping mapping;
        SVNRepositoryInfo repository;
        try {
            SVNURL originalURL = SVNURL.parseURIDecoded((String)repositoryUrl);
            repository = SVNImportOperation.getRepositoryRoot(originalURL);
            String relativePath = repository.getRelativePath(originalURL);
            if (relativePath.length() > 0) {
                String[] newFolderPaths = new String[folderPaths.length];
                int i = 0;
                while (i < folderPaths.length) {
                    String path = folderPaths[i];
                    newFolderPaths[i] = PathUtils.appendPath((String)relativePath, (String)path);
                    ++i;
                }
                mapping = SimpleSVN2ComponentPathMapping.createForPaths((String[])newFolderPaths);
            } else {
                mapping = SimpleSVN2ComponentPathMapping.createForPaths((String[])folderPaths);
            }
        }
        catch (SVNException e) {
            IStatus status = StatusUtil.newStatus((Object)"com.ibm.team.scm.client.importz.svn", (Throwable)e);
            StatusUtil.log((IStatus)status);
            ErrorDialog.openError((Shell)context.getShell(), null, null, (IStatus)status);
            return;
        }
        catch (TeamRepositoryException e) {
            IStatus status = StatusUtil.newStatus((Object)"com.ibm.team.scm.client.importz.svn", (Throwable)e);
            StatusUtil.log((IStatus)status);
            ErrorDialog.openError((Shell)context.getShell(), null, null, (IStatus)status);
            return;
        }
        SVNImportData data = new SVNImportData(repository, mapping, null);
        ImportFromSVNClientWizard wizard = new ImportFromSVNClientWizard(context, data);
        WizardDialog dialog = new WizardDialog(context.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private static SVNRepositoryInfo getRepositoryRoot(final SVNURL originalURL) throws SVNException, TeamRepositoryException {
        final Credentials credentials = new Credentials();
        final boolean[] tryAgain = new boolean[]{true};
        while (tryAgain[0]) {
            try {
                SVNRepository repository = SVNRepositoryFactory.create((SVNURL)originalURL);
                credentials.updateAuthentication(repository);
                return new SVNRepositoryInfo(repository.getRepositoryRoot(true), credentials);
            }
            catch (SVNAuthenticationException e) {
                tryAgain[0] = false;
                final boolean[] canceled = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PasswordDialog dialog = new PasswordDialog(originalURL.toString(), credentials, e.getMessage());
                        tryAgain[0] = dialog.open() == 0;
                        canceled[0] = !tryAgain[0];
                    }
                });
                if (canceled[0]) {
                    throw new OperationCanceledException();
                }
                if (tryAgain[0]) continue;
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        throw new OperationCanceledException();
    }

    public SVNImportOperation(IImportData importData, ImportConfiguration configuration) {
        super("SVN", (IMigrationFactory)new SVNMigrationFactory(), importData, configuration);
    }
}

