/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.importz.IFileProperties;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.IImportData;
import com.ibm.team.scm.client.importz.IMigrationFactory;
import com.ibm.team.scm.client.importz.spi.ChangeSetArchiveCreator;
import com.ibm.team.scm.client.importz.spi.ImportChange;
import com.ibm.team.scm.client.importz.spi.ImportChangeSet;
import com.ibm.team.scm.client.importz.spi.ImportData;
import com.ibm.team.scm.client.importz.svn.internal.ISVN2ComponentPathMapping;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeFile;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeNode;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.ISVNRevisionTree;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.MoveDescription;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.PasswordDialog;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.ResponsiveLogFetcher;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNChange;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNImportData;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNRepositoryInfo;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SyncRoot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNChangeArchiveCreator
extends ChangeSetArchiveCreator {
    protected static final String ROOT_PATH = "";
    public static final long IMPORT_COMPLETE_HISTORY = -1L;
    private Map<String, SyncRoot> roots = new HashMap<String, SyncRoot>();
    private File archiveFile;
    private SVNRepositoryInfo repositoryInfo;
    private ISVN2ComponentPathMapping mapping;
    private ISVNRevisionTree tree = new SVNRevisionTree();
    private long earliestRevision;
    private long latestRevision;
    private String defaultUser;

    public SVNChangeArchiveCreator(IMigrationFactory migrationFactory) {
        super(migrationFactory);
    }

    public void createChangeSetArchive(IImportData importData, IProgressMonitor monitor) throws TeamRepositoryException {
        final SVNRepositoryInfo repository = this.initialize(importData);
        final boolean[] tryAgain = new boolean[]{true};
        while (tryAgain[0]) {
            try {
                this.createChangeSetArchive(monitor);
                return;
            }
            catch (SVNAuthenticationException e) {
                tryAgain[0] = false;
                final boolean[] canceled = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PasswordDialog dialog = new PasswordDialog(repository.getRepository().getLocation().toString(), repository.getCredentials(), e.getMessage());
                        tryAgain[0] = dialog.open() == 0;
                        canceled[0] = !tryAgain[0];
                    }
                });
                if (canceled[0]) {
                    throw new OperationCanceledException();
                }
                if (tryAgain[0]) continue;
                throw new TeamRepositoryException((Throwable)e);
            }
        }
    }

    private SVNRepositoryInfo initialize(IImportData importData) {
        SVNImportData sid = (SVNImportData)importData;
        File archiveFile = ((ImportData)importData).getArchiveFile();
        SVNRepositoryInfo repository = sid.getRepository();
        this.initialize(archiveFile, repository, sid.getMapping(), sid.getEarliestRevision(), sid.getLatestRevision(), sid.getDefaultUser());
        return repository;
    }

    private void initialize(File archiveFile, SVNRepositoryInfo repositoryInfo, ISVN2ComponentPathMapping mapping, long earliestRevision, long latestRevision, String defaultUser) {
        this.archiveFile = archiveFile;
        this.repositoryInfo = repositoryInfo;
        this.mapping = mapping;
        this.defaultUser = defaultUser;
        this.earliestRevision = earliestRevision <= 0L ? -1L : earliestRevision;
        this.latestRevision = latestRevision <= 0L ? -1L : (latestRevision < earliestRevision ? earliestRevision : latestRevision);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createChangeSetArchive(IProgressMonitor monitor) throws TeamRepositoryException, SVNAuthenticationException {
        try {
            try {
                this.openArchive(this.archiveFile);
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
                paths = this.mapping.getRepositoryPaths();
                this.initializeSyncRoots(paths);
                logs = this.fetchLogs(this.earliestRevision, this.latestRevision, paths, (IProgressMonitor)progress.newChild(100));
                if (this.earliestRevision > 0L) {
                    progress.setWorkRemaining(100 + 100 * logs.size());
                    if (logs.size() > 0 && logs.get(0).getRevision() == this.earliestRevision) {
                        initialEntry = logs.get(0);
                        date = initialEntry.getDate();
                    } else {
                        initialEntry = null;
                        date = logs.size() > 0 ? logs.get(0).getDate() : new Date();
                    }
                    this.fetchInitialState(paths, initialEntry, date, progress.newChild(100));
                }
                if (logs.size() > 0) {
                    progress.setWorkRemaining(100 * logs.size());
                    var6_7 = logs.iterator();
                    while (true) {
                        if (!var6_7.hasNext()) {
                        }
                        logEntry = var6_7.next();
                        if (logEntry.getRevision() == this.earliestRevision) continue;
                        this.processEntry(paths, logEntry, progress.newChild(100));
                    }
                }
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        finally {
            try {
                try {
                    this.closeArchive();
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
            finally {
                ** for (root : this.roots.values())
            }
        }
lbl-1000:
        // 1 sources

        {
            root.dispose();
            continue;
        }
lbl44:
        // 1 sources

        monitor.done();
    }

    private void initializeSyncRoots(Collection<String> paths) {
        for (String path : paths) {
            this.roots.put(path, new SyncRoot(this.mapping, path));
        }
    }

    private SyncRoot getSyncRoot(String path) {
        SyncRoot syncRoot = this.roots.get(path);
        if (syncRoot != null) {
            return syncRoot;
        }
        for (String rootPath : this.roots.keySet()) {
            if (!PathUtils.isParentFolder((String)rootPath, (String)path)) continue;
            return this.roots.get(rootPath);
        }
        return null;
    }

    private void fetchInitialState(Collection<String> paths, SVNLogEntry initialEntry, Date date, SubMonitor progress) throws TeamRepositoryException {
        Assert.isTrue((this.earliestRevision != -1L ? 1 : 0) != 0);
        if (SyncRoot.DEBUG) {
            System.out.println("Fetching state at revision " + this.earliestRevision);
        }
        progress.setWorkRemaining(paths.size() * 100);
        HashMap<String, List<SVNChange>> changes = new HashMap<String, List<SVNChange>>();
        for (String path : paths) {
            try {
                List<SVNChange> cl = this.update(path, this.earliestRevision, progress.newChild(100));
                changes.put(path, cl);
            }
            catch (TeamRepositoryException e) {
                if (this.isPathDoesNotExistError(e)) continue;
                throw e;
            }
        }
        try {
            IImportChangeSet changeSet = this.processChangesForInitialState(initialEntry, date, changes, progress.newChild(10));
            if (!changeSet.getChanges().isEmpty()) {
                this.writeChangeSet(changeSet);
            }
        }
        catch (IOException e) {
            throw new TeamRepositoryException(NLS.bind((String)SVNRCPMessages.SVNChangeArchiveCreator_7, (Object)this.earliestRevision), (Throwable)e);
        }
    }

    private boolean isPathDoesNotExistError(TeamRepositoryException e) {
        Throwable cause = e.getCause();
        if (cause instanceof SVNException) {
            return cause.getMessage().indexOf("Target path does not exist") != -1;
        }
        return false;
    }

    private IImportChangeSet processChangesForInitialState(SVNLogEntry logEntry, Date logEntryDate, Map<String, List<SVNChange>> changes, SubMonitor progress) throws TeamRepositoryException, IOException {
        ImportChangeSet set = new ImportChangeSet(Long.toString(this.earliestRevision), logEntryDate, NLS.bind((String)SVNRCPMessages.SVNChangeArchiveCreator_8, (Object)this.earliestRevision), logEntry == null ? this.defaultUser : logEntry.getAuthor());
        for (Map.Entry<String, List<SVNChange>> entry : changes.entrySet()) {
            this.processChangesForInitialState(set, this.getSyncRoot(entry.getKey()), entry.getValue());
        }
        this.updateTree(changes);
        return set;
    }

    private void processChangesForInitialState(ImportChangeSet set, SyncRoot root, List<SVNChange> changes) throws TeamRepositoryException, IOException {
        for (SVNChange change : changes) {
            ImportChange importChange = change.asImportChange(root.getRootPath(), this.tree, false);
            if (importChange == null) continue;
            this.addChangeToSet(set.getDate(), change, importChange, set);
        }
    }

    private void processEntry(Collection<String> paths, SVNLogEntry logEntry, SubMonitor progress) throws TeamRepositoryException {
        if (SyncRoot.DEBUG) {
            System.out.println(logEntry);
        }
        progress.setWorkRemaining(paths.size() * 100 + 10);
        HashMap<String, List<SVNChange>> changes = new HashMap<String, List<SVNChange>>();
        for (String path : paths) {
            if (!this.hasOverlap(path, logEntry)) continue;
            if (this.hasDeleteFor(path, logEntry)) {
                changes.put(path, Collections.singletonList(new SVNChange(1, ROOT_PATH, logEntry.getRevision())));
                continue;
            }
            List<SVNChange> cl = this.update(path, logEntry.getRevision(), progress.newChild(100));
            changes.put(path, cl);
        }
        try {
            IImportChangeSet changeSet = this.processChanges(logEntry, changes, progress.newChild(10));
            if (!changeSet.getChanges().isEmpty()) {
                this.writeChangeSet(changeSet);
            }
        }
        catch (IOException e) {
            throw new TeamRepositoryException(NLS.bind((String)SVNRCPMessages.SVNChangeArchiveCreator_1, (Object)logEntry.getRevision()), (Throwable)e);
        }
    }

    private IImportChangeSet processChanges(SVNLogEntry logEntry, Map<String, List<SVNChange>> changes, SubMonitor progress) throws IOException, TeamRepositoryException {
        Moves moves = this.findMoves(logEntry);
        ImportChangeSet set = new ImportChangeSet(Long.toString(logEntry.getRevision()), logEntry.getDate(), this.ensureNotNull(logEntry.getMessage()), logEntry.getAuthor());
        for (Map.Entry<String, List<SVNChange>> entry : changes.entrySet()) {
            this.processChanges(logEntry, set, this.getSyncRoot(entry.getKey()), entry.getValue(), moves);
        }
        this.processDeletes(logEntry, set, moves);
        this.updateTree(changes);
        return set;
    }

    private void processDeletes(SVNLogEntry logEntry, ImportChangeSet set, Moves moves) {
        List<SVNLogEntryPath> deletes = moves.getDeletes(logEntry);
        for (SVNLogEntryPath logEntryPath : deletes) {
            String beforePath = this.mapping.getComponentRelativePath(logEntryPath.getPath());
            ImportChange change = new ImportChange(32, Long.toString(logEntry.getRevision()), beforePath, null, null, null);
            set.add((IImportChange)change);
        }
    }

    private void updateTree(Map<String, List<SVNChange>> changes) {
        for (Map.Entry<String, List<SVNChange>> entry : changes.entrySet()) {
            SyncRoot root = this.getSyncRoot(entry.getKey());
            for (SVNChange change : entry.getValue()) {
                change.applyTo(root.getTree());
            }
        }
    }

    private void processChanges(SVNLogEntry logEntry, ImportChangeSet set, SyncRoot root, List<SVNChange> changes, Moves moves) throws TeamRepositoryException, IOException {
        HashMap<String, SVNChange> replaces = new HashMap<String, SVNChange>();
        for (SVNChange change : changes) {
            if (moves.isSourceOfMove(root, change)) continue;
            if (moves.isInvolvedInMove(root, change)) {
                MoveDescription move = moves.findMove(root, change);
                String path = PathUtils.appendPath((String)root.getRootPath(), (String)change.getPath());
                if (PathUtils.isPathsEquals((String)move.getTargetPath(), (String)path)) {
                    ImportChange importChange = change.asMove(root.getRootPath(), this.tree, move);
                    if (importChange == null) continue;
                    this.addChangeToSet(logEntry.getDate(), change, importChange, set);
                    continue;
                }
                boolean hasReportedModification = this.hasReportedModification(logEntry, PathUtils.appendPath((String)root.getRootPath(), (String)change.getPath()));
                ImportChange importChange = change.asModificationAfterMove(logEntry.getRevision(), root.getRootPath(), this.tree, move, hasReportedModification);
                if (importChange == null) continue;
                this.addChangeToSet(logEntry.getDate(), change, importChange, set);
                continue;
            }
            if (this.isDeletionForFileReplace(root, change, logEntry)) {
                replaces.put(change.getPath(), change);
                continue;
            }
            boolean replace = replaces.get(change.getPath()) != null;
            ImportChange importChange = change.asImportChange(root.getRootPath(), this.tree, replace);
            if (importChange == null) continue;
            this.addChangeToSet(logEntry.getDate(), change, importChange, set);
        }
    }

    private boolean isDeletionForFileReplace(SyncRoot root, SVNChange change, SVNLogEntry logEntry) {
        if (change.getType() == 1 && root.getTree().getNode(change.getPath()) instanceof SVNTreeFile) {
            String fullPath = root.getFullPath(change);
            for (Object object : logEntry.getChangedPaths().values()) {
                SVNLogEntryPath changedPath = (SVNLogEntryPath)object;
                if (changedPath.getType() != 'R' || !PathUtils.isPathsEquals((String)changedPath.getPath(), (String)fullPath)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasReportedModification(SVNLogEntry logEntry, String path) {
        Collection values = logEntry.getChangedPaths().values();
        for (Object o : values) {
            SVNLogEntryPath lep;
            if (!(o instanceof SVNLogEntryPath) || (lep = (SVNLogEntryPath)o).getType() != 'M' && lep.getType() != 'R' && lep.getType() != 'A' || !PathUtils.isPathsEquals((String)lep.getPath(), (String)path)) continue;
            return true;
        }
        return false;
    }

    private void addChangeToSet(Date date, SVNChange change, ImportChange importChange, ImportChangeSet set) throws IOException {
        set.add((IImportChange)importChange);
        File file = change.getContents();
        if (file != null) {
            this.archiveContents(importChange.getArchivePath(), file, date);
        }
    }

    private String ensureNotNull(String message) {
        if (message == null) {
            return ROOT_PATH;
        }
        return message;
    }

    private Moves findMoves(SVNLogEntry logEntry) {
        Map<String, SVNLogEntryPath> deletes = this.findDeletes(logEntry);
        List<MoveDescription> moves = this.findMoves(logEntry, deletes);
        return new Moves(moves);
    }

    private List<MoveDescription> findMoves(SVNLogEntry logEntry, Map<String, SVNLogEntryPath> deletes) {
        ArrayList<MoveDescription> result = new ArrayList<MoveDescription>();
        for (Object object : logEntry.getChangedPaths().values()) {
            SVNLogEntryPath delete;
            SVNLogEntryPath changedPath = (SVNLogEntryPath)object;
            if (changedPath.getType() != 'A' || changedPath.getCopyPath() == null || !this.isInScope(changedPath.getCopyPath()) || !this.isInScope(changedPath.getPath()) || !this.isCurrentRevision(changedPath.getCopyPath(), changedPath.getCopyRevision())) continue;
            MoveDescription parentMove = this.findParentMove(result, changedPath.getCopyPath());
            String afterMovePath = changedPath.getCopyPath();
            if (parentMove != null) {
                afterMovePath = parentMove.getAfterMovePath(afterMovePath);
            }
            if ((delete = deletes.get(afterMovePath)) == null) continue;
            deletes.remove(changedPath.getCopyPath());
            MoveDescription move = new MoveDescription(delete, changedPath, parentMove);
            result.add(move);
            if (!SyncRoot.DEBUG) continue;
            System.out.println("Move detected: " + move.toString());
        }
        return result;
    }

    private MoveDescription findParentMove(List<MoveDescription> result, String copyFromPath) {
        MoveDescription parentMove = null;
        for (MoveDescription possibleParent : result) {
            if (!PathUtils.isParentFolder((String)possibleParent.getSourcePath(), (String)copyFromPath) || PathUtils.isPathsEquals((String)possibleParent.getSourcePath(), (String)copyFromPath) || parentMove != null && !PathUtils.isParentFolder((String)parentMove.getSourcePath(), (String)possibleParent.getSourcePath())) continue;
            parentMove = possibleParent;
        }
        return parentMove;
    }

    private Map<String, SVNLogEntryPath> findDeletes(SVNLogEntry logEntry) {
        HashMap<String, SVNLogEntryPath> result = new HashMap<String, SVNLogEntryPath>();
        for (Object object : logEntry.getChangedPaths().values()) {
            SVNLogEntryPath changedPath = (SVNLogEntryPath)object;
            if (changedPath.getType() != 'D' || !this.isInScope(changedPath.getPath())) continue;
            result.put(changedPath.getPath(), changedPath);
        }
        return result;
    }

    private boolean isInScope(String path) {
        return this.mapping.getComponentRelativePath(path) != null;
    }

    private boolean isCurrentRevision(String copyPath, long copyRevision) {
        for (String path : this.roots.keySet()) {
            if (!PathUtils.isParentFolder((String)path, (String)copyPath)) continue;
            String relativePath = PathUtils.getRelativePath((String)path, (String)copyPath);
            SyncRoot root = this.roots.get(path);
            SVNTreeNode node = root.getTree().getNode(relativePath);
            if (node == null) continue;
            return node.getRevision() <= copyRevision;
        }
        return false;
    }

    private List<SVNChange> update(String path, long revision, SubMonitor progress) throws TeamRepositoryException {
        try {
            progress.setWorkRemaining(100);
            SVNRepository repository = this.repositoryInfo.getRepository(path);
            SyncRoot root = this.getSyncRoot(path);
            ISVNEditor editor = root.createEditor(progress.newChild(90));
            repository.update(revision, null, true, root.createReporter(revision, progress.newChild(10)), editor);
            return root.getChanges(editor);
        }
        catch (SVNException e) {
            SVNChangeArchiveCreator.handleWrappedRuntimeException(e);
            throw new TeamRepositoryException(NLS.bind((String)SVNRCPMessages.SVNChangeArchiveCreator_2, (Object[])new Object[]{this.repositoryInfo.getLocation().toString(), path, revision}), (Throwable)e);
        }
    }

    protected static void handleWrappedRuntimeException(SVNException e) {
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
    }

    private boolean hasOverlap(String path, SVNLogEntry logEntry) {
        Collection changedPaths = logEntry.getChangedPaths().values();
        for (SVNLogEntryPath changedPath : changedPaths) {
            if (PathUtils.isParentFolder((String)path, (String)changedPath.getPath())) {
                return true;
            }
            if (!PathUtils.isParentFolder((String)changedPath.getPath(), (String)path) || changedPath.getCopyPath() == null && changedPath.getType() != 'D') continue;
            return true;
        }
        return false;
    }

    private boolean hasDeleteFor(String path, SVNLogEntry logEntry) {
        Collection changedPaths = logEntry.getChangedPaths().values();
        for (SVNLogEntryPath changedPath : changedPaths) {
            SyncRoot root;
            if (changedPath.getType() != 'D') continue;
            if (PathUtils.isPathsEquals((String)changedPath.getPath(), (String)path)) {
                return true;
            }
            if (!PathUtils.isParentFolder((String)changedPath.getPath(), (String)path) || (root = this.getSyncRoot(path)).getTree().getNode(ROOT_PATH) == null) continue;
            return true;
        }
        return false;
    }

    private List<SVNLogEntry> fetchLogs(long startRevision, long endRevision, Collection<String> paths, IProgressMonitor monitor) throws TeamRepositoryException, SVNAuthenticationException {
        try {
            SVNRepository repository = this.repositoryInfo.getRepository();
            long currentRepoRevision = repository.getLatestRevision();
            long firstRevision = startRevision == -1L ? 0L : Math.min(startRevision, currentRepoRevision);
            if (currentRepoRevision > startRevision) {
                long lastRevision = endRevision == -1L ? currentRepoRevision : Math.min(currentRepoRevision, endRevision);
                ResponsiveLogFetcher fetcher = new ResponsiveLogFetcher(repository, paths.toArray(new String[paths.size()]), firstRevision, lastRevision);
                return fetcher.fetchLogs(monitor);
            }
            return Collections.emptyList();
        }
        catch (SVNAuthenticationException e) {
            throw e;
        }
        catch (SVNException e) {
            SVNChangeArchiveCreator.handleWrappedRuntimeException(e);
            throw new TeamRepositoryException(NLS.bind((String)SVNRCPMessages.SVNChangeArchiveCreator_5, (Object)this.repositoryInfo.getLocation().toString()), (Throwable)e);
        }
    }

    private class Moves {
        private final List<MoveDescription> moves;

        public Moves(List<MoveDescription> moves) {
            this.moves = moves;
        }

        public boolean isSourceOfMove(SyncRoot root, SVNChange change) {
            String path;
            return change.getType() == 1 && this.isSourceOfMove(path = PathUtils.appendPath((String)root.getRootPath(), (String)change.getPath()));
        }

        private boolean isSourceOfMove(String path) {
            for (MoveDescription move : this.moves) {
                if (!move.isDeletePath(path)) continue;
                return true;
            }
            return false;
        }

        public boolean isTargetOfMove(SyncRoot root, SVNChange change) {
            String path = PathUtils.appendPath((String)root.getRootPath(), (String)change.getPath());
            for (MoveDescription move : this.moves) {
                if (!PathUtils.isPathsEquals((String)path, (String)move.getTargetPath())) continue;
                return true;
            }
            return false;
        }

        public boolean isInvolvedInMove(SyncRoot root, SVNChange change) {
            if (change.getType() == 3 || change.getType() == 2 || change.getType() == 5) {
                String path = PathUtils.appendPath((String)root.getRootPath(), (String)change.getPath());
                for (MoveDescription move : this.moves) {
                    if (!move.isWithinTargetSubtree(path)) continue;
                    return true;
                }
            }
            return false;
        }

        public MoveDescription findMove(SyncRoot root, SVNChange change) {
            MoveDescription found = null;
            if (change.getType() == 3 || change.getType() == 2 || change.getType() == 5) {
                String path = PathUtils.appendPath((String)root.getRootPath(), (String)change.getPath());
                for (MoveDescription move : this.moves) {
                    if (!move.isWithinTargetSubtree(path) || found != null && !found.isAncestorOf(move)) continue;
                    found = move;
                }
            }
            return found;
        }

        public List<SVNLogEntryPath> getDeletes(SVNLogEntry logEntry) {
            ArrayList<SVNLogEntryPath> result = new ArrayList<SVNLogEntryPath>();
            Map changedPaths = logEntry.getChangedPaths();
            for (SVNLogEntryPath logEntryPath : changedPaths.values()) {
                if (logEntryPath.getType() != 'D' || !this.isChildOfMove(logEntryPath)) continue;
                result.add(logEntryPath);
            }
            return result;
        }

        private boolean isChildOfMove(SVNLogEntryPath logEntryPath) {
            String path = logEntryPath.getPath();
            for (MoveDescription move : this.moves) {
                if (!move.isWithinTargetSubtree(path) || this.isSourceOfMove(path)) continue;
                return true;
            }
            return false;
        }
    }

    private class SVNRevisionTree
    implements ISVNRevisionTree {
        private SVNRevisionTree() {
        }

        @Override
        public IFileProperties getFileProperties(String path) {
            SVNTreeNode node = this.getNode(path);
            if (node instanceof SVNTreeFile) {
                SVNTreeFile file = (SVNTreeFile)node;
                return file.getFileProperties();
            }
            return null;
        }

        @Override
        public SVNTreeNode getNode(String path) {
            SyncRoot syncRoot = SVNChangeArchiveCreator.this.getSyncRoot(path);
            String relativePath = PathUtils.getRelativePath((String)syncRoot.getRootPath(), (String)path);
            return syncRoot.getTree().getNode(relativePath);
        }

        @Override
        public String getWorkspacePath(String path) {
            return SVNChangeArchiveCreator.this.mapping.getComponentRelativePath(path);
        }

        @Override
        public boolean isContentChange(String path, File contents) throws TeamRepositoryException {
            SyncRoot syncRoot = SVNChangeArchiveCreator.this.getSyncRoot(path);
            String relativePath = PathUtils.getRelativePath((String)syncRoot.getRootPath(), (String)path);
            return syncRoot.isContentChange(relativePath, contents);
        }
    }
}

