/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.importz.IFileProperties;
import com.ibm.team.scm.client.importz.spi.IgnoreFileChange;
import com.ibm.team.scm.client.importz.spi.ImportChange;
import com.ibm.team.scm.client.importz.spi.LogCache;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeFile;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeFolder;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeNode;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.ISVNRevisionTree;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.MoveDescription;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.RevisionTree;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNFilePropertiesDelta;
import java.io.File;
import org.eclipse.osgi.util.NLS;

public class SVNChange {
    public static final int DELETE = 1;
    public static final int ADD_FOLDER = 2;
    public static final int ADD_FILE = 3;
    public static final int CHANGE = 4;
    public static final int CHANGE_IGNORE = 5;
    private final int type;
    private final String path;
    private long revision;
    private File file;
    private String ignorePatterns;
    private SVNFilePropertiesDelta propertiesDelta;

    public SVNChange(int type, String path, long revision) {
        this.type = type;
        this.path = path;
        this.revision = revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public int getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public long getRevision() {
        return this.revision;
    }

    public void setContents(File file) {
        this.file = file;
    }

    public File getContents() {
        return this.file;
    }

    public void applyTo(RevisionTree tree) {
        switch (this.type) {
            case 4: {
                SVNTreeNode node;
                tree.updateRevision(this.path, this.revision);
                if (this.file != null) {
                    tree.setCurrentFileFor(this.path, this.file);
                }
                if (this.propertiesDelta == null || !((node = tree.getNode(this.path)) instanceof SVNTreeFile)) break;
                SVNTreeFile treeFile = (SVNTreeFile)node;
                treeFile.setProperties(this.propertiesDelta.applyTo(treeFile.getFileProperties()));
                break;
            }
            case 2: {
                tree.addFolder(this.path, this.revision);
                break;
            }
            case 3: {
                tree.addFile(this.path, this.revision);
                if (this.file == null) break;
                tree.setCurrentFileFor(this.path, this.file);
                SVNTreeNode node = tree.getNode(this.path);
                if (!(node instanceof SVNTreeFile)) break;
                SVNTreeFile treeFile = (SVNTreeFile)node;
                treeFile.setProperties((IFileProperties)(this.propertiesDelta == null ? SVNTreeFile.getDefaultFileProperties() : this.propertiesDelta.toIFileProperties()));
                break;
            }
            case 1: {
                tree.remove(this.path, this.revision);
                break;
            }
            case 5: {
                SVNTreeNode node = tree.getNode(PathUtils.getParentFolderPath((String)this.path));
                if (!(node instanceof SVNTreeFolder)) break;
                SVNTreeFolder folder = (SVNTreeFolder)node;
                folder.setIgnorePatterns(this.ignorePatterns);
            }
        }
    }

    public ImportChange asImportChange(String pathPrefix, ISVNRevisionTree tree, boolean replace) {
        String treePath = PathUtils.appendPath((String)pathPrefix, (String)this.path);
        String workspacePath = tree.getWorkspacePath(treePath);
        if (workspacePath == null) {
            return null;
        }
        switch (this.type) {
            case 2: {
                return new ImportChange(18, Long.toString(this.revision), null, workspacePath, null, null);
            }
            case 1: {
                return new ImportChange(32, Long.toString(this.revision), workspacePath, null, null, null);
            }
            case 3: {
                if (!replace) {
                    String archivePath = LogCache.getCachedFileName((String)workspacePath, (String)Long.toString(this.revision));
                    return new ImportChange(17, Long.toString(this.revision), null, workspacePath, archivePath, (IFileProperties)(this.propertiesDelta == null ? SVNTreeFile.getDefaultFileProperties() : this.propertiesDelta.toIFileProperties()));
                }
            }
            case 4: {
                String archivePath;
                SVNTreeNode node = tree.getNode(treePath);
                if (!node.isFile()) break;
                int flags = 65;
                if (this.file != null) {
                    flags |= 0x100;
                    archivePath = LogCache.getCachedFileName((String)workspacePath, (String)Long.toString(this.revision));
                } else {
                    archivePath = null;
                }
                IFileProperties properties = ((SVNTreeFile)node).getFileProperties();
                if (this.propertiesDelta != null) {
                    properties = this.propertiesDelta.applyTo(properties);
                }
                return new ImportChange(flags, Long.toString(this.revision), null, workspacePath, archivePath, properties);
            }
            case 5: {
                return this.createIgnoreFileChange(workspacePath, tree, treePath);
            }
        }
        return null;
    }

    public ImportChange asMove(String pathPrefix, ISVNRevisionTree tree, MoveDescription move) throws TeamRepositoryException {
        String treePath = PathUtils.appendPath((String)pathPrefix, (String)this.path);
        String workspacePath = tree.getWorkspacePath(treePath);
        String beforePath = tree.getWorkspacePath(move.getPostParentMoveSourcePath());
        int flags = 576;
        switch (this.type) {
            case 2: {
                return new ImportChange(flags |= 2, Long.toString(this.revision), beforePath, workspacePath, null, null);
            }
            case 3: {
                flags |= 1;
                String archivePath = null;
                IFileProperties properties = tree.getFileProperties(move.getSourcePath());
                if (this.getContents() != null && tree.isContentChange(move.getSourcePath(), this.getContents())) {
                    flags |= 0x100;
                    archivePath = LogCache.getCachedFileName((String)workspacePath, (String)Long.toString(this.revision));
                }
                if (this.propertiesDelta != null) {
                    properties = this.propertiesDelta.applyTo(properties);
                }
                return new ImportChange(flags, Long.toString(this.revision), beforePath, workspacePath, archivePath, properties);
            }
        }
        return null;
    }

    public ImportChange asModificationAfterMove(long currentRevision, String pathPrefix, ISVNRevisionTree tree, MoveDescription move, boolean hasReportedModification) throws TeamRepositoryException {
        String treePath = PathUtils.appendPath((String)pathPrefix, (String)this.path);
        String workspacePath = tree.getWorkspacePath(treePath);
        if (this.revision == currentRevision) {
            if (this.type == 5) {
                return this.createIgnoreFileChange(workspacePath, tree, move.getSourcePath(treePath));
            }
            if (this.type == 3 && (this.getContents() != null || this.propertiesDelta != null)) {
                int flags = 1;
                flags = tree.getNode(move.getSourcePath(treePath)) != null ? (flags |= 0x40) : (flags |= 0x10);
                String archivePath = null;
                String sourcePath = move.getSourcePath(treePath);
                if (this.getContents() != null && hasReportedModification && tree.isContentChange(sourcePath, this.getContents())) {
                    if ((flags & 0x40) != 0) {
                        flags |= 0x100;
                    }
                    archivePath = LogCache.getCachedFileName((String)workspacePath, (String)Long.toString(this.revision));
                }
                IFileProperties properties = tree.getFileProperties(sourcePath);
                if (this.propertiesDelta != null) {
                    properties = this.propertiesDelta.applyTo(properties);
                }
                return new ImportChange(flags, Long.toString(this.revision), workspacePath, workspacePath, archivePath, properties);
            }
            if (this.type == 2 && hasReportedModification && tree.getNode(move.getSourcePath(treePath)) == null) {
                return new ImportChange(18, Long.toString(this.revision), null, workspacePath, null, null);
            }
        }
        return null;
    }

    private ImportChange createIgnoreFileChange(String workspacePath, ISVNRevisionTree tree, String sourceTreePath) {
        String afterPath;
        String beforePath;
        if (PathUtils.getSegments((String)workspacePath).length == 1) {
            return null;
        }
        int flags = 1;
        String currentPattern = null;
        SVNTreeNode node = tree.getNode(PathUtils.getParentFolderPath((String)sourceTreePath));
        if (node instanceof SVNTreeFolder) {
            SVNTreeFolder folder = (SVNTreeFolder)node;
            currentPattern = folder.getIgnorePatterns();
        }
        if (currentPattern == null && this.ignorePatterns != null) {
            flags |= 0x10;
            beforePath = null;
            afterPath = workspacePath;
        } else if (this.ignorePatterns == null && currentPattern != null) {
            flags |= 0x20;
            afterPath = null;
            beforePath = workspacePath;
        } else if (currentPattern != this.ignorePatterns && !currentPattern.equals(this.ignorePatterns)) {
            flags |= 0x140;
            beforePath = workspacePath;
            afterPath = workspacePath;
        } else {
            return null;
        }
        return new IgnoreFileChange(flags, Long.toString(this.revision), beforePath, afterPath, this.ignorePatterns, null);
    }

    public void setIgnorePatterns(String ignorePatterns) {
        this.ignorePatterns = ignorePatterns;
    }

    public String toString() {
        return NLS.bind((String)"{0} in revision {1}: {2}", (Object[])new Object[]{this.getTypeString(), this.revision, this.path});
    }

    private String getTypeString() {
        switch (this.type) {
            case 3: {
                return "ADD FILE";
            }
            case 2: {
                return "ADD FOLDER";
            }
            case 1: {
                return "DELETE";
            }
            case 4: {
                return "CHANGE";
            }
            case 5: {
                return "CHANGE IGNORE";
            }
        }
        return "UNKNOWN";
    }

    public void setFilePropertiesDelta(SVNFilePropertiesDelta propertiesDelta) {
        this.propertiesDelta = propertiesDelta;
    }
}

