/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeFile;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeFolder;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RevisionTree {
    private final Map<String, SVNTreeNode> treeMap;
    private final Map<String, File> files = new HashMap<String, File>();
    private String rootNodePath;
    private File nullFile;

    public RevisionTree() {
        this.treeMap = new HashMap<String, SVNTreeNode>();
    }

    private void initializeTree() {
        SVNTreeFolder root = new SVNTreeFolder(this.rootNodePath);
        this.treeMap.put(root.getPath(), (SVNTreeNode)root);
    }

    protected final String normalizePath(String path) {
        if (this.rootNodePath == null) {
            this.rootNodePath = path.startsWith("/") ? "/" : "";
            if (this.treeMap.isEmpty()) {
                this.initializeTree();
            }
        }
        return PathUtils.normalizePath((String)path, (this.rootNodePath == "/" ? 1 : 0) != 0, (boolean)false);
    }

    public SVNTreeNode getNode(String path) {
        return this.treeMap.get(this.normalizePath(path));
    }

    public void updateRevision(String path, long revision) {
        SVNTreeNode node = this.getNode(path);
        if (node != null && node.getRevision() < revision) {
            node.setRevision(revision);
            this.updateRevision(PathUtils.getParentFolderPath((String)path), revision);
        }
    }

    public void remove(String path, long revision) {
        SVNTreeNode node = this.getNode(path);
        this.remove(revision, node);
    }

    private void remove(long revision, SVNTreeNode treeNode) {
        ArrayList<SVNTreeNode> removals = new ArrayList<SVNTreeNode>();
        this.removeChildren(revision, treeNode, removals);
        removals.add(treeNode);
        this.performRemovals(removals);
        SVNTreeFolder parent = this.getParent(treeNode);
        if (parent != null) {
            parent.removeChild(treeNode.getName());
        }
    }

    private void putNode(SVNTreeNode node) {
        String path = this.normalizePath(node.getPath());
        this.treeMap.put(path, node);
    }

    private SVNTreeFolder getParent(SVNTreeNode treeNode) {
        String path = treeNode.getPath();
        if (path.length() == 0) {
            return null;
        }
        return (SVNTreeFolder)this.getNode(PathUtils.getParentFolderPath((String)path));
    }

    private void performRemovals(List<SVNTreeNode> removals) {
        if (!removals.isEmpty()) {
            for (SVNTreeNode treeNode : removals) {
                this.remove(treeNode);
            }
            removals.clear();
        }
    }

    private SVNTreeNode remove(SVNTreeNode treeNode) {
        String path = treeNode.getPath();
        return this.treeMap.remove(path);
    }

    private void removeChildren(long revision, SVNTreeNode treeNode, List<SVNTreeNode> removals) {
        if (treeNode instanceof SVNTreeFolder) {
            SVNTreeFolder folder = (SVNTreeFolder)treeNode;
            Set children = folder.getChildren();
            for (String childName : children) {
                String childPath = PathUtils.appendPath((String)treeNode.getPath(), (String)childName);
                SVNTreeNode child = this.getNode(childPath);
                if (child == null) continue;
                this.removeChildren(revision, child, removals);
                removals.add(child);
            }
            if (removals.size() > 100) {
                this.performRemovals(removals);
            }
        }
    }

    public void addFolder(String path, long revision) {
        String parentPath = PathUtils.getParentFolderPath((String)path);
        SVNTreeFolder parent = (SVNTreeFolder)this.getNode(parentPath);
        this.add(revision, parent, path, false);
    }

    public void addFile(String path, long revision) {
        String parentPath = PathUtils.getParentFolderPath((String)path);
        SVNTreeFolder parent = (SVNTreeFolder)this.getNode(parentPath);
        this.add(revision, parent, path, true);
    }

    private SVNTreeNode add(long revision, SVNTreeFolder parent, String path, boolean isFile) {
        SVNTreeNode node = this.internalCreateNode(revision, path, isFile);
        this.internalAdd(revision, parent, node);
        return node;
    }

    private void internalAdd(long revision, SVNTreeFolder parent, SVNTreeNode node) {
        parent.addChild(node.getName());
        this.putNode(node);
    }

    private SVNTreeNode internalCreateNode(long revision, String path, boolean isFile) {
        Object node = isFile ? new SVNTreeFile(this.normalizePath(path), revision) : new SVNTreeFolder(this.normalizePath(path), revision);
        return node;
    }

    public void setCurrentFileFor(String path, File currentFile) {
        path = this.normalizePath(path);
        File file = this.getCurrentFileFor(path);
        this.files.put(path, currentFile);
        if (file.exists()) {
            file.delete();
        }
    }

    public File getCurrentFileFor(String path) {
        File file = this.files.get(path = this.normalizePath(path));
        if (file == null) {
            if (this.nullFile == null) {
                try {
                    this.nullFile = DebugUtils.createTempFile((String)"nullFile");
                    this.nullFile.delete();
                }
                catch (IOException e) {
                    StatusUtil.log((Object)this, (Throwable)e);
                }
            }
            file = this.nullFile;
        }
        return file;
    }

    public void dispose() {
        for (File file : this.files.values()) {
            file.delete();
        }
    }

    public void clear() {
        this.treeMap.clear();
        this.initializeTree();
    }
}

