/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNChangeArchiveCreator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.io.SVNRepository;

public class ResponsiveLogFetcher {
    private SVNRepository repository;
    private String[] paths;
    private long firstRevision;
    private long lastRevision;

    public ResponsiveLogFetcher(SVNRepository repository, String[] paths, long firstRevision, long lastRevision) {
        this.repository = repository;
        this.paths = paths;
        this.firstRevision = firstRevision;
        this.lastRevision = lastRevision;
    }

    public List<SVNLogEntry> fetchLogs(IProgressMonitor monitor) throws Error, SVNException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)((int)(this.lastRevision - this.firstRevision)));
        progress.subTask(NLS.bind((String)SVNRCPMessages.SVNChangeArchiveCreator_4, (Object)this.repository.getLocation().toString()));
        final LinkedList<SVNLogEntry> result = new LinkedList<SVNLogEntry>();
        try {
            try {
                this.repository.log(this.paths, this.lastRevision, this.firstRevision, true, true, 0L, new ISVNLogEntryHandler(){

                    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                        ResponsiveLogFetcher.this.reportProgressDuringFetch(result, logEntry, progress);
                        result.addFirst(logEntry);
                    }
                });
            }
            catch (SVNException e) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SVNChangeArchiveCreator.handleWrappedRuntimeException(e);
                if (!this.isFolderNotFoundError(e)) {
                    throw e;
                }
                this.repository.log(new String[]{""}, this.lastRevision, this.firstRevision, true, true, 0L, new ISVNLogEntryHandler(){

                    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                        ResponsiveLogFetcher.this.reportProgressDuringFetch(result, logEntry, progress);
                        result.addFirst(logEntry);
                    }
                });
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private boolean isFolderNotFoundError(SVNException e) {
        return true;
    }

    private void reportProgressDuringFetch(LinkedList<SVNLogEntry> result, SVNLogEntry logEntry, SubMonitor progress) {
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        progress.subTask(NLS.bind((String)SVNRCPMessages.ResponsiveLogFetcher_0, (Object)logEntry.getRevision()));
        long previousRevision = result.isEmpty() ? this.lastRevision : result.getFirst().getRevision();
        progress.worked((int)(previousRevision - logEntry.getRevision()));
    }
}

