/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeFolder;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeNode;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.RevisionTree;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SyncRoot;
import java.util.Set;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;

class Reporter
implements ISVNReporterBaton {
    public static final boolean DEBUG_REPORTER = false;
    private final RevisionTree tree;
    private final long targetRevision;
    private final SubMonitor progress;

    public Reporter(RevisionTree tree, long revision, SubMonitor progress) {
        this.tree = tree;
        this.targetRevision = revision;
        this.progress = progress;
    }

    public void report(ISVNReporter reporter) throws SVNException {
        SVNTreeNode node = this.getTree().getNode("");
        String relativePath = "";
        if (node == null || node.getRevision() == -1L) {
            if (SyncRoot.DEBUG) {
                System.out.println("Report empty tree at revision " + this.targetRevision);
            }
            reporter.setPath("", null, this.targetRevision, true);
        } else {
            if (SyncRoot.DEBUG) {
                System.out.println("Report local tree at revision " + node.getRevision());
            }
            reporter.setPath(relativePath, null, node.getRevision(), false);
        }
        reporter.finishReport();
    }

    private void report(ISVNReporter reporter, String relativePath) throws SVNException {
        if (this.progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        SVNTreeNode node = this.getTree().getNode(relativePath);
        if (SyncRoot.DEBUG) {
            System.out.println("Report: " + node.getPath() + " at revision " + node.getRevision());
        }
        if (node instanceof SVNTreeFolder) {
            SVNTreeFolder folder = (SVNTreeFolder)node;
            Set children = folder.getChildren();
            reporter.setPath(relativePath, null, node.getRevision(), children.isEmpty());
            for (String childName : children) {
                this.report(reporter, PathUtils.appendPath((String)relativePath, (String)childName));
            }
        } else {
            reporter.setPath(relativePath, null, node.getRevision(), false);
        }
    }

    private RevisionTree getTree() {
        return this.tree;
    }
}

