/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class MoveDescription {
    SVNLogEntryPath deleteEntry;
    SVNLogEntryPath copyEntry;
    private MoveDescription parentMove;

    public MoveDescription(SVNLogEntryPath deleteEntry, SVNLogEntryPath copyEntry, MoveDescription parentMove) {
        this.assertPaths(parentMove, deleteEntry, copyEntry);
        this.parentMove = parentMove;
        this.deleteEntry = deleteEntry;
        this.copyEntry = copyEntry;
    }

    private void assertPaths(MoveDescription parentMove, SVNLogEntryPath deleteEntry, SVNLogEntryPath copyEntry) {
        if (parentMove == null) {
            Assert.isTrue((boolean)PathUtils.isPathsEquals((String)deleteEntry.getPath(), (String)copyEntry.getCopyPath()));
        } else {
            Assert.isTrue((boolean)PathUtils.isPathsEquals((String)deleteEntry.getPath(), (String)parentMove.getAfterMovePath(copyEntry.getCopyPath())));
        }
    }

    public boolean isDeletePath(String path) {
        return PathUtils.isPathsEquals((String)this.deleteEntry.getPath(), (String)path);
    }

    public boolean isWithinTargetSubtree(String path) {
        return PathUtils.isParentFolder((String)this.copyEntry.getPath(), (String)path);
    }

    public String getTargetPath() {
        return this.copyEntry.getPath();
    }

    public String getSourcePath() {
        return this.copyEntry.getCopyPath();
    }

    public String getPostParentMoveSourcePath() {
        if (this.parentMove != null) {
            return this.parentMove.getAfterMovePath(this.copyEntry.getCopyPath());
        }
        return this.getSourcePath();
    }

    public String getSourcePath(String targetPath) {
        String relativePath = PathUtils.getRelativePath((String)this.copyEntry.getPath(), (String)targetPath);
        return PathUtils.appendPath((String)this.copyEntry.getCopyPath(), (String)relativePath);
    }

    public MoveDescription getParentMove() {
        return this.parentMove;
    }

    public String toString() {
        if (this.parentMove == null) {
            return NLS.bind((String)"Move from ''{0}'' to ''{1}''", (Object)this.copyEntry.getCopyPath(), (Object)this.copyEntry.getPath());
        }
        return NLS.bind((String)"Nested move from ''{0}'' to ''{1}''", (Object)this.copyEntry.getCopyPath(), (Object)this.copyEntry.getPath());
    }

    public String getAfterMovePath(String path) {
        if (PathUtils.isParentFolder((String)this.copyEntry.getCopyPath(), (String)path)) {
            String relativePath = PathUtils.getRelativePath((String)this.copyEntry.getCopyPath(), (String)path);
            return PathUtils.appendPath((String)this.copyEntry.getPath(), (String)relativePath);
        }
        throw new IllegalArgumentException(NLS.bind((String)SVNRCPMessages.MoveDescription_0, (Object)path, (Object)this.toString()));
    }

    public boolean isAncestorOf(MoveDescription move) {
        if (move.getParentMove() == this) {
            return true;
        }
        if (move.getParentMove() != null) {
            return this.isAncestorOf(move.getParentMove());
        }
        return false;
    }
}

