/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import com.ibm.team.scm.client.importz.svn.internal.SVNTreeNode;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.RevisionTree;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNChange;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNFilePropertiesDelta;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SyncRoot;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowApplyBaton;

class Editor
implements ISVNEditor {
    private static final String ROOT_PATH = "";
    private static final String REVISION_PROPERTY = "svn:entry:committed-rev";
    private static final String IGNORE_PROPERTY = "svn:ignore";
    private final RevisionTree tree;
    private final SubMonitor progress;
    private long targetRevision;
    private String currentDir;
    private File originalFile;
    private File currentFile;
    private SVNFilePropertiesDelta propertiesDelta;
    private SVNDiffWindowApplyBaton currentBaton;
    private String currentChecksum;
    private final Map<String, SVNChange> changesMap = new HashMap<String, SVNChange>();
    private final List<SVNChange> changesList = new ArrayList<SVNChange>();

    public Editor(RevisionTree tree, SubMonitor progress) {
        this.tree = tree;
        this.progress = progress;
        this.currentDir = ROOT_PATH;
    }

    private RevisionTree getTree() {
        return this.tree;
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("textDeltaEnd: " + path);
        }
        this.currentChecksum = this.currentBaton.close();
        this.currentBaton = null;
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("textDeltaChunk: " + path);
        }
        diffWindow.apply(this.currentBaton);
        return null;
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("applyTextDelta: " + path + " checksum " + baseChecksum);
        }
        this.progress.subTask(NLS.bind((String)SVNRCPMessages.Editor_0, (Object)this.targetRevision, (Object)path));
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
        try {
            this.originalFile = this.getTree().getCurrentFileFor(path);
            this.currentFile = DebugUtils.createTempFile((String)PathUtils.getBaseName((String)path));
            this.currentBaton = SVNDiffWindowApplyBaton.create((File)this.originalFile, (File)this.currentFile, (MessageDigest)digest);
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)SVNRCPMessages.Editor_1, (Object)e), (Throwable)e);
        }
    }

    public void targetRevision(long revision) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("targetRevision: " + revision);
        }
        this.targetRevision = revision;
        this.progress.subTask(NLS.bind((String)SVNRCPMessages.Editor_2, (Object)revision));
    }

    public void openRoot(long revision) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("openRoot: " + revision);
        }
        this.progress.subTask(NLS.bind((String)SVNRCPMessages.Editor_3, (Object)this.targetRevision));
        this.internalOpenDir(ROOT_PATH, revision);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("openFile: " + revision + " " + path);
        }
        this.progress.subTask(NLS.bind((String)SVNRCPMessages.Editor_4, (Object)this.targetRevision, (Object)path));
    }

    public void openDir(String path, long revision) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("openDir: " + revision + " " + path);
        }
        this.progress.subTask(NLS.bind((String)SVNRCPMessages.Editor_5, (Object)this.targetRevision, (Object)path));
        this.internalOpenDir(path, revision);
    }

    private void internalOpenDir(String path, long revision) {
        this.checkCanceled();
        this.currentDir = path;
        SVNTreeNode node = this.getTree().getNode(this.currentDir);
        if (node.getRevision() >= 0L) {
            Assert.isTrue((revision >= node.getRevision() ? 1 : 0) != 0);
            if (path.equals(ROOT_PATH)) {
                this.updateRevision(ROOT_PATH, revision);
            }
        } else if (path.equals(ROOT_PATH)) {
            SVNChange change = new SVNChange(2, path, revision);
            this.addChange(change);
        }
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("Delete: " + revision + " " + path);
        }
        this.progress.subTask(NLS.bind((String)SVNRCPMessages.Editor_6, (Object)this.targetRevision, (Object)path));
        SVNChange change = new SVNChange(1, path, revision);
        this.addChange(change);
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("closeFile: " + path + " checksum " + textChecksum);
        }
        if (this.currentChecksum != null && !this.currentChecksum.equals(textChecksum)) {
            StatusUtil.log((Object)this, (String)NLS.bind((String)SVNRCPMessages.Editor_9, (Object[])new String[]{path, textChecksum, this.currentChecksum}));
        }
        SVNChange change = this.getChange(path);
        change.setContents(this.currentFile);
        if (this.propertiesDelta != null) {
            change.setFilePropertiesDelta(this.propertiesDelta);
        }
        this.currentFile = null;
        this.propertiesDelta = null;
    }

    private SVNChange getChange(String path) {
        return this.changesMap.get(path);
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("closeEdit");
        }
        return null;
    }

    public void closeDir() throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("closeDir");
        }
        this.currentDir = PathUtils.getParentFolderPath((String)this.currentDir);
    }

    public void changeFileProperty(String path, String name, String value) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("changeFileProperty: " + path);
            System.out.println("     " + name + " = " + value);
        }
        if (name.equals(REVISION_PROPERTY)) {
            this.updateRevision(path, Long.parseLong(value));
        } else if (name.equals("svn:eol-style")) {
            if (this.propertiesDelta == null) {
                this.propertiesDelta = new SVNFilePropertiesDelta();
            }
            this.propertiesDelta.setEolStyle(value);
        } else if (name.equals("svn:mime-type")) {
            if (this.propertiesDelta == null) {
                this.propertiesDelta = new SVNFilePropertiesDelta();
            }
            this.propertiesDelta.setContentType(value);
        } else if (name.equals("svn:executable")) {
            if (this.propertiesDelta == null) {
                this.propertiesDelta = new SVNFilePropertiesDelta();
            }
            this.propertiesDelta.setExecutable(value != null);
        }
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("changeDirProperty: " + name + " = " + value);
        }
        if (name.equals(REVISION_PROPERTY)) {
            this.updateRevision(this.currentDir, Long.parseLong(value));
        } else if (name.equals(IGNORE_PROPERTY)) {
            this.handleIgnorePropertyChange(value);
        }
    }

    private void handleIgnorePropertyChange(String value) {
        String filePath = PathUtils.appendPath((String)this.currentDir, (String)".jazzignore");
        SVNChange change = new SVNChange(5, filePath, this.targetRevision);
        change.setIgnorePatterns(value);
        this.addChange(change);
    }

    private void updateRevision(String path, long revision) {
        SVNChange change = this.getChange(path);
        if (change == null) {
            change = new SVNChange(4, path, revision);
            this.addChange(change);
        } else if (change.getRevision() < revision) {
            change.setRevision(revision);
        }
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("addFile: " + path);
        }
        this.progress.subTask(NLS.bind((String)SVNRCPMessages.Editor_7, (Object)this.targetRevision, (Object)path));
        SVNChange change = new SVNChange(3, path, this.targetRevision);
        this.addChange(change);
        if (copyFromPath != null && SyncRoot.DEBUG) {
            System.out.println("     copyFrom " + copyFromRevision + " " + copyFromPath);
        }
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("addDir: " + path);
        }
        this.progress.subTask(NLS.bind((String)SVNRCPMessages.Editor_8, (Object)this.targetRevision, (Object)path));
        this.currentDir = path;
        SVNChange change = new SVNChange(2, path, this.targetRevision);
        this.addChange(change);
        if (copyFromPath != null && SyncRoot.DEBUG) {
            System.out.println("     copyFrom " + copyFromRevision + " " + copyFromPath);
        }
    }

    private void addChange(SVNChange change) {
        this.changesMap.put(change.getPath(), change);
        this.changesList.add(change);
    }

    public void absentFile(String path) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("absentFile: " + path);
        }
    }

    public void absentDir(String path) throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("absentDir: " + path);
        }
    }

    public void abortEdit() throws SVNException {
        this.checkCanceled();
        if (SyncRoot.DEBUG) {
            System.out.println("abortEdit");
        }
    }

    private void checkCanceled() {
        if (this.progress.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public List<SVNChange> getChanges() {
        return this.changesList;
    }
}

