/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.esubversive.ui.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.scm.svn.common.SvnBugtraqProperties;
import com.ibm.team.scm.svn.common.SvnLogEntry;
import com.ibm.team.scm.svn.esubversive.ui.internal.SubversiveLogEntry;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.local.property.RemovePropertiesOperation;
import org.eclipse.team.svn.core.operation.local.property.SetPropertiesOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFolder;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryFolder;
import org.eclipse.ui.IWorkbenchPart;

public class SubversiveWorkItemAdapter
extends SVNWorkItemAdapter {
    private static SVNWorkItemAdapter instance;
    private final IWorkbenchPart part;

    public SubversiveWorkItemAdapter(IWorkbenchPart part) {
        this.part = part;
    }

    public static synchronized SVNWorkItemAdapter getInstance() {
        if (instance == null) {
            instance = new SubversiveWorkItemAdapter(null);
        }
        return instance;
    }

    public SvnLogEntry asLogEntry(Object revision) {
        if (this.part != null) {
            return SubversiveLogEntry.create(this.part, revision);
        }
        return null;
    }

    public SvnBugtraqProperties getBugTrackingProperties(IProject project) throws FileSystemException {
        return SubversiveLogEntry.getBugtraqProperties((IResource)project);
    }

    public void setBugTrackingProperties(IProject project, SvnBugtraqProperties properties) throws FileSystemException {
        ArrayList<SVNProperty> result = new ArrayList<SVNProperty>(properties.entrySet().size());
        for (Map.Entry entry : properties.entrySet()) {
            result.add(new SVNProperty((String)entry.getKey(), (String)entry.getValue()));
        }
        SetPropertiesOperation op = new SetPropertiesOperation(new IResource[]{project}, result.toArray(new SVNProperty[result.size()]), false);
        op.run((IProgressMonitor)new NullProgressMonitor());
    }

    public void removeBugTrackingProperties(IProject project) throws FileSystemException {
        ArrayList<SVNProperty> result = new ArrayList<SVNProperty>();
        result.add(new SVNProperty("bugtraq:url", null));
        result.add(new SVNProperty("bugtraq:message", null));
        result.add(new SVNProperty("bugtraq:label", null));
        result.add(new SVNProperty("bugtraq:append", null));
        result.add(new SVNProperty("bugtraq:number", null));
        result.add(new SVNProperty("bugtraq:warnifnoissue", null));
        result.add(new SVNProperty("bugtraq:logregex", null));
        RemovePropertiesOperation op = new RemovePropertiesOperation(new IResource[]{project}, result.toArray(new SVNProperty[result.size()]), false);
        op.run((IProgressMonitor)new NullProgressMonitor());
    }

    public IRepositoryFolder getRemoteFolder(String repoUrl, String revision) {
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        IRepositoryLocation location = null;
        int i = 0;
        while (i < locations.length) {
            IRepositoryLocation l = locations[i];
            if (l.getUrl().equals(repoUrl)) {
                location = l;
                break;
            }
            ++i;
        }
        if (location == null) {
            location = SVNRemoteStorage.instance().newRepositoryLocation();
            location.setUrl(repoUrl);
        }
        SVNRepositoryFolder folder = new SVNRepositoryFolder(location, repoUrl, SVNRevision.HEAD);
        if (revision != null) {
            folder.setRevision(Long.parseLong(revision));
            folder.setPegRevision((SVNRevision)SVNRevision.fromNumber((long)Long.parseLong(revision)));
        }
        return folder;
    }
}

