/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.esubversive.ui.internal;

import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.svn.esubversive.ui.internal.SubversiveLogEntry;
import com.ibm.team.scm.svn.esubversive.ui.internal.SubversiveMessages;
import com.ibm.team.scm.svn.esubversive.ui.internal.SubversiveWorkItemAdapter;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.LocalLinkUpdateOperation;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFolder;
import org.eclipse.team.svn.core.resource.IRepositoryResource;

public class SubversiveLocalLinkUpdateOperation
extends LocalLinkUpdateOperation {
    public SubversiveLocalLinkUpdateOperation(ITeamRepository teamRepository, String url, long startingRevision) {
        super(teamRepository, url, startingRevision, SubversiveWorkItemAdapter.getInstance());
    }

    public void runLocalUpdate(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IRepositoryFolder remoteFolder = ((SubversiveWorkItemAdapter)this.getWorkItemAdapter()).getRemoteFolder(this.getUrl(), null);
        progress.subTask(NLS.bind((String)SubversiveMessages.SubversiveUpdateLinksOperation_0, (Object)this.getUrl(), (Object)Long.toString(this.getStartingRevision())));
        GetLogMessagesOperation op = new GetLogMessagesOperation((IRepositoryResource)remoteFolder, true);
        op.setLimit(1L);
        op.run((IProgressMonitor)progress.newChild(10));
        SVNLogEntry[] messages = op.getMessages();
        if (messages == null || messages.length == 0) {
            return;
        }
        long rev = messages[0].revision;
        long limit = rev - this.getStartingRevision() + 1L;
        if (limit < 1L) {
            return;
        }
        op.setLimit(limit);
        op.run((IProgressMonitor)progress.newChild(40));
        messages = op.getMessages();
        progress.setWorkRemaining(messages.length * 10);
        int i = 0;
        while (i < messages.length) {
            SVNLogEntry logMessage = messages[i];
            this.createLink(logMessage, this.getUrl(), progress.newChild(10));
            ++i;
        }
        if (messages.length > 0) {
            this.setLatestRevision(messages[0].revision);
        }
    }

    private void createLink(SVNLogEntry logMessage, String url, SubMonitor newChild) throws TeamRepositoryException {
        try {
            IURIReference uriReference = SubversiveLogEntry.createUriReference(url, logMessage);
            this.createLinks(uriReference, logMessage.message, (IProgressMonitor)newChild);
        }
        catch (URISyntaxException e) {
            this.getWorkItemAdapter().logException((Throwable)e);
        }
    }
}

