/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.common;

import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.svn.common.SvnBugtraqProperties;
import com.ibm.team.scm.svn.common.model.util.SVNModelMessages;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.osgi.util.NLS;

public abstract class SvnLogEntry
extends PlatformObject {
    public static final String PROTOCOL_PREFIX = "svn+";

    public static URI getRepositoryUriFromRevisionUri(URI uri) throws URISyntaxException {
        return new URI(SvnLogEntry.asRealScheme(uri.getScheme()), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
    }

    public static String getRevisionNumberFromRevisionUri(URI uri) {
        return uri.getFragment();
    }

    private static String asRealScheme(String referenceScheme) {
        if (referenceScheme.indexOf("http") != -1 && referenceScheme.startsWith("svn") && !referenceScheme.startsWith(PROTOCOL_PREFIX)) {
            return referenceScheme.substring("svn".length());
        }
        if (referenceScheme.startsWith(PROTOCOL_PREFIX)) {
            return referenceScheme.substring(PROTOCOL_PREFIX.length());
        }
        return referenceScheme;
    }

    private static String asReferenceScheme(String realScheme) {
        return PROTOCOL_PREFIX + realScheme;
    }

    public IURIReference asUriReference() throws URISyntaxException {
        String comment = this.getComment();
        String revisionString = Long.toString(this.getRevision());
        URI repoUri = new URI(this.getRepositoryUrl());
        URI revisionUri = SvnLogEntry.createURI(repoUri.getScheme(), repoUri.getUserInfo(), repoUri.getHost(), repoUri.getPort(), repoUri.getPath(), revisionString);
        return SvnLogEntry.createReference(revisionUri, comment, revisionString);
    }

    protected static URI createURI(String protocol, String userInfo, String host, int port, String path, String revisionString) throws URISyntaxException {
        protocol = SvnLogEntry.asReferenceScheme(protocol);
        URI uri = new URI(protocol, userInfo, host, port, path, null, revisionString);
        return uri;
    }

    protected static IURIReference createReference(URI uri, String comment, String revisionString) {
        return IReferenceFactory.INSTANCE.createReferenceFromURI(uri, SvnLogEntry.getReferenceComment(comment, revisionString));
    }

    private static String getReferenceComment(String comment, String revisionString) {
        if (comment == null || comment.length() == 0) {
            comment = SVNModelMessages.SvnLogEntry_3;
        }
        if ((comment = NLS.bind((String)SVNModelMessages.SvnLogEntry_4, (Object)revisionString, (Object)comment)).length() > 128) {
            comment = comment.substring(0, 128);
        }
        return comment;
    }

    public abstract String getRepositoryUrl();

    public abstract SvnBugtraqProperties getBugtraqProperties() throws TeamRepositoryException;

    public abstract String getComment();

    public abstract long getRevision();
}

