/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.common;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.providers.LinkProvider;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class RevisionLinks {
    public static final String REVISION_2_WORK_ITEM_LINK_TYPE = "com.ibm.team.scm.svn.linkType.workItem";

    public static final List<ILink> findLinks(LinkProvider linkProvider, IReference revisionReference, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<ILink> links = new ArrayList<ILink>();
        ILinkQueryPage results = linkProvider.findLinksBySource(new String[]{REVISION_2_WORK_ITEM_LINK_TYPE}, revisionReference, (IProgressMonitor)progress.newChild(100));
        ILinkCollection collection = results.getAllLinksFromHereOn();
        links.addAll((Collection<ILink>)collection);
        return links;
    }

    public static List<ILink> createLink(LinkProvider linkProvider, IReference revisionReference, IWorkItemHandle[] workItems, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        RevisionLinks.checkCanceled((IProgressMonitor)progress);
        IReferenceFactory referenceFactory = linkProvider.referenceFactory();
        ArrayList<UUID> existingLinkedWorkItems = new ArrayList<UUID>();
        List<ILink> links = RevisionLinks.findLinks(linkProvider, revisionReference, (IProgressMonitor)progress.newChild(30));
        for (ILink link : links) {
            IItemHandle handle;
            IReference targetRef = link.getTargetRef();
            if (!targetRef.isItemReference() || (handle = ((IItemReference)targetRef).getReferencedItem()).getItemType() != IWorkItem.ITEM_TYPE) continue;
            existingLinkedWorkItems.add(handle.getItemId());
        }
        RevisionLinks.checkCanceled((IProgressMonitor)progress);
        SubMonitor loopProgress = progress.newChild(70).setWorkRemaining(workItems.length);
        links.clear();
        int i = 0;
        while (i < workItems.length) {
            IWorkItemHandle workItemHandle = workItems[i];
            if (!existingLinkedWorkItems.contains(workItemHandle.getItemId())) {
                IItemReference target = referenceFactory.createReferenceToItem((IItemHandle)workItemHandle);
                ILink link = linkProvider.createLink(REVISION_2_WORK_ITEM_LINK_TYPE, revisionReference, (IReference)target);
                linkProvider.saveLink(link, (IProgressMonitor)loopProgress.newChild(1));
                links.add(link);
                RevisionLinks.checkCanceled((IProgressMonitor)loopProgress);
            }
            ++i;
        }
        return links;
    }

    private static void checkCanceled(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static IWorkItemHandle[] getWorkItemHandles(List<ILink> links) {
        ArrayList<IWorkItemHandle> result = new ArrayList<IWorkItemHandle>();
        for (ILink link : links) {
            IItemReference ir;
            IItemHandle handle;
            IReference ref = link.getTargetRef();
            if (!ref.isItemReference() || !((handle = (ir = (IItemReference)ref).getReferencedItem()) instanceof IWorkItemHandle)) continue;
            result.add((IWorkItemHandle)handle);
        }
        return result.toArray(new IWorkItemHandle[result.size()]);
    }

    public static void createLink(LinkProvider linkProvider, IURIReference revisionReference, List<IWorkItemHandle> workItems, IProgressMonitor monitor) throws TeamRepositoryException {
        RevisionLinks.createLink(linkProvider, (IReference)revisionReference, workItems.toArray(new IWorkItemHandle[workItems.size()]), monitor);
    }
}

