/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.client.internal;

import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.svn.client.ISvnClientLibrary;
import com.ibm.team.scm.svn.client.internal.RepositoryEvent;
import com.ibm.team.scm.svn.client.internal.SVNClientMessages;
import com.ibm.team.scm.svn.common.ISvnRepository;
import com.ibm.team.scm.svn.common.ISvnService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SvnClientLibrary
extends EventSource
implements ISvnClientLibrary {
    private final IClientLibraryContext context;

    public SvnClientLibrary(IClientLibraryContext context) {
        this.context = context;
    }

    private ISvnService getService() throws TeamRepositoryException {
        ISvnService service = (ISvnService)this.context.getServiceInterface(ISvnService.class);
        if (service == null) {
            throw new TeamRepositoryException(SVNClientMessages.SvnClientLibrary_0);
        }
        return service;
    }

    @Override
    public ISvnRepository createRepository(final String url, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable runnable = new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ISvnService.PostRepositoryParameters params = new ISvnService.PostRepositoryParameters();
                params.url = url;
                params.revision = 0L;
                params.create = true;
                return SvnClientLibrary.this.getService().postRepository(params);
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISvnRepository result = (ISvnRepository)this.context.callCancelableService(runnable, (IProgressMonitor)progress.newChild(50));
        result = (ISvnRepository)this.context.teamRepository().itemManager().fetchCompleteItem((IItemHandle)result, 1, (IProgressMonitor)progress.newChild(50));
        this.queueChangeEvent(result, 1);
        return result;
    }

    private void queueChangeEvent(ISvnRepository result, int changeType) {
        this.queueEvent((Object)new RepositoryEvent((IEventSource)this, "repositories", changeType, result, this.context.teamRepository()));
    }

    private void queueChangeEvent(Collection<ISvnRepository> repositories, int changeType) {
        this.queueEvent((Object)new RepositoryEvent((IEventSource)this, "repositories", changeType, repositories, this.context.teamRepository()));
    }

    @Override
    public ISvnRepository[] getRepositories(boolean fetchFromServer, IProgressMonitor monitor) throws TeamRepositoryException {
        if (fetchFromServer) {
            IClientLibraryContext.IServiceRunnable runnable = new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return SvnClientLibrary.this.getService().getRepositories();
                }
            };
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ISvnRepository[] result = (ISvnRepository[])this.context.callCancelableService(runnable, (IProgressMonitor)progress.newChild(50));
            return this.updateItemManager(result, (IProgressMonitor)progress.newChild(50));
        }
        IItemManager itemManager = this.context.teamRepository().itemManager();
        List sharedItems = itemManager.getKnownSharedItems(ISvnService.REPO_ITEM_TYPE);
        return sharedItems.toArray(new ISvnRepository[sharedItems.size()]);
    }

    @Override
    public ISvnRepository updateRepositoryRevision(final ISvnRepository repository, final long revision, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable runnable = new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ISvnService.PostRepositoryParameters params = new ISvnService.PostRepositoryParameters();
                params.url = repository.getUrl();
                params.revision = Math.max(revision, repository.getRevision());
                return SvnClientLibrary.this.getService().postRepository(params);
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISvnRepository result = (ISvnRepository)this.context.callCancelableService(runnable, (IProgressMonitor)progress.newChild(50));
        result = (ISvnRepository)this.context.teamRepository().itemManager().fetchCompleteItem((IItemHandle)result, 1, (IProgressMonitor)progress.newChild(50));
        this.queueChangeEvent(result, 3);
        return result;
    }

    @Override
    public void deleteRepository(final ISvnRepository repository, final boolean deleteLinks, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable runnable = new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ISvnService.DeleteRepositoryParameters params = new ISvnService.DeleteRepositoryParameters();
                params.url = repository.getUrl();
                params.deleteLinks = deleteLinks;
                SvnClientLibrary.this.getService().postDeleteRepository(params);
                return repository;
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.context.callCancelableService(runnable, (IProgressMonitor)progress.newChild(50));
        IItemManager itemManager = this.context.teamRepository().itemManager();
        IItem sharedItem = itemManager.getSharedItemIfKnown((IItemHandle)repository);
        if (sharedItem != null) {
            ArrayList<ISvnRepository> list = new ArrayList<ISvnRepository>();
            list.add((ISvnRepository)sharedItem);
            itemManager.applyItemDeletes(list);
        }
        this.queueChangeEvent(repository, 2);
    }

    protected ISvnRepository[] updateItemManager(ISvnRepository[] fetchedRepos, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<ISvnRepository> itemsToFetch = new ArrayList<ISvnRepository>();
        ArrayList<ISvnRepository> itemsToRefresh = new ArrayList<ISvnRepository>();
        ArrayList<ISvnRepository> itemsToDelete = new ArrayList<ISvnRepository>();
        IItemManager itemManager = this.context.teamRepository().itemManager();
        int i = 0;
        while (i < fetchedRepos.length) {
            ISvnRepository svnRepository = fetchedRepos[i];
            IItem sharedItem = itemManager.getSharedItemIfKnown((IItemHandle)svnRepository);
            if (sharedItem == null) {
                itemsToFetch.add(svnRepository);
            } else {
                itemsToRefresh.add((ISvnRepository)sharedItem);
            }
            ++i;
        }
        List sharedItems = itemManager.getKnownSharedItems(ISvnService.REPO_ITEM_TYPE);
        for (Object item : sharedItems) {
            if (itemsToRefresh.contains(item)) continue;
            itemsToDelete.add((ISvnRepository)item);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)((itemsToFetch.size() + itemsToRefresh.size()) * 10));
        ArrayList<ISvnRepository> result = new ArrayList<ISvnRepository>();
        if (!itemsToFetch.isEmpty()) {
            List list = itemManager.fetchCompleteItems(itemsToFetch, 1, (IProgressMonitor)progress.newChild(itemsToFetch.size() * 10));
            for (Object object : list) {
                result.add((ISvnRepository)object);
            }
        }
        if (!itemsToRefresh.isEmpty()) {
            itemManager.refreshSharedItems(itemsToRefresh, (IProgressMonitor)progress.newChild(itemsToRefresh.size() * 10));
            for (Object e : itemsToRefresh) {
                result.add((ISvnRepository)e);
            }
        }
        itemManager.applyItemDeletes(itemsToDelete);
        if (!itemsToFetch.isEmpty()) {
            this.queueChangeEvent(itemsToFetch, 1);
        }
        if (!itemsToDelete.isEmpty()) {
            this.queueChangeEvent(itemsToDelete, 2);
        }
        if (!itemsToRefresh.isEmpty()) {
            this.queueChangeEvent(itemsToRefresh, 3);
        }
        return result.toArray(new ISvnRepository[result.size()]);
    }

    @Override
    public ISvnRepository requestRevisionScan(final ISvnRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable runnable = new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ISvnService.ScanRequestParameters params = new ISvnService.ScanRequestParameters();
                params.url = repository.getUrl();
                return SvnClientLibrary.this.getService().postScanRequest(params);
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISvnRepository result = (ISvnRepository)this.context.callCancelableService(runnable, (IProgressMonitor)progress.newChild(50));
        result = (ISvnRepository)this.context.teamRepository().itemManager().fetchCompleteItem((IItemHandle)result, 1, (IProgressMonitor)progress.newChild(50));
        this.queueChangeEvent(result, 3);
        return result;
    }

    @Override
    public ISvnRepository getRepository(String repositoryUrl, boolean fetchFromServer, IProgressMonitor monitor) throws TeamRepositoryException {
        ISvnRepository[] repositories = this.getRepositories(fetchFromServer, monitor);
        int i = 0;
        while (i < repositories.length) {
            ISvnRepository svnRepository = repositories[i];
            if (this.urlsEqual(svnRepository.getUrl(), repositoryUrl)) {
                return svnRepository;
            }
            ++i;
        }
        return null;
    }

    private boolean urlsEqual(String url1, String url2) {
        if (!url1.endsWith("/")) {
            url1 = String.valueOf(url1) + "/";
        }
        if (!url2.endsWith("/")) {
            url2 = String.valueOf(url2) + "/";
        }
        return url1.equals(url2);
    }
}

