/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.scm.svn.common.ISvnRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RepositoryEvent
extends Event {
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int CHANGED = 3;
    private static final long serialVersionUID = 1L;
    private final List<ISvnRepository> repositories;
    private final ITeamRepository teamRepository;
    private final int changeType;

    public RepositoryEvent(IEventSource eventSource, String eventType, int changeType, ISvnRepository repository, ITeamRepository teamRepository) {
        this(eventSource, eventType, changeType, Collections.singletonList(repository), teamRepository);
    }

    public RepositoryEvent(IEventSource eventSource, String eventType, int changeType, Collection<ISvnRepository> repositories, ITeamRepository teamRepository) {
        super(eventSource, eventType);
        this.repositories = new ArrayList<ISvnRepository>(repositories.size());
        this.repositories.addAll(repositories);
        this.teamRepository = teamRepository;
        this.changeType = changeType;
    }

    public ISvnRepository[] getRepositories() {
        return this.repositories.toArray(new ISvnRepository[this.repositories.size()]);
    }

    public ITeamRepository getTeamRepository() {
        return this.teamRepository;
    }

    public int getChangeType() {
        return this.changeType;
    }
}

