/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.query;

import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.IntegerQueryFilter;
import com.ibm.team.scm.common.internal.ItemQueryFilter;
import com.ibm.team.scm.common.internal.PatternQueryFilter;
import com.ibm.team.scm.common.internal.QueryCriteria;
import com.ibm.team.scm.common.internal.QueryItem;
import com.ibm.team.scm.common.internal.ScmFactory;
import com.ibm.team.scm.common.internal.dto.NameFilter;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.util.ItemQueryUtil;
import com.ibm.team.scm.common.internal.util.QueryFilterFactory;

public interface IQueryItemFactory {
    public static final String QUERY_TYPE_FILTER = "QueryType";
    public static final String NAME_FILTER = "Name";
    public static final String OWNERS_FILTER = "Owners";
    public static final String DATE_RANGE_FILTER = "DateRange";
    public static final String OLDEST_FIRST_FILTER = "OldestFirst";
    public static final String ALPHABETICAL_FILTER = "Alphabetical";
    public static final IQueryItemFactory INSTANCE = new IQueryItemFactory(){

        @Override
        public IQueryItem createQueryItem(String queryName, String queryDescription, IAuditableHandle ownerHandle, int type, IReadScope readScope) throws TeamRepositoryException {
            if (queryName == null || queryName.equals("")) {
                throw new IllegalArgumentException();
            }
            if (ownerHandle == null) {
                throw new IllegalArgumentException();
            }
            if (readScope == null) {
                throw new IllegalArgumentException();
            }
            QueryItem queryItem = ScmFactory.eINSTANCE.createQueryItem();
            queryItem.setRealName(queryName);
            if (queryDescription != null && queryDescription.length() > 0) {
                queryItem.setDescription(queryDescription);
            }
            queryItem.setOwnerAndVisibility(ownerHandle, readScope);
            queryItem.setType(type);
            QueryCriteria queryCriteria = ScmFactory.eINSTANCE.createQueryCriteria();
            queryItem.setCriteria(queryCriteria);
            return queryItem;
        }

        @Override
        public void addFilter(IQueryItem query, String identifier, int filterValue) {
            QueryCriteria criteria = (QueryCriteria)((QueryItem)query).getCriteria();
            IntegerQueryFilter filter = QueryFilterFactory.createIntegerQueryFilter(identifier, filterValue);
            ItemQueryUtil.addFilterToQueryCriteria(criteria, filter);
        }

        @Override
        public void addFilter(IQueryItem query, String identifier, IItemHandle item) {
            QueryCriteria criteria = (QueryCriteria)((QueryItem)query).getCriteria();
            ItemQueryFilter filter = QueryFilterFactory.createItemQueryFilter(identifier, item);
            ItemQueryUtil.addFilterToQueryCriteria(criteria, filter);
        }

        @Override
        public void addNameFilter(IQueryItem query, String identifier, String pattern, boolean isExactMatch, boolean isIgnoreCase) {
            QueryCriteria criteria = (QueryCriteria)((QueryItem)query).getCriteria();
            NameFilter nameFilter = ScmDtoFactory.eINSTANCE.createNameFilter();
            nameFilter.setExact(isExactMatch);
            nameFilter.setIgnoreCase(isIgnoreCase);
            nameFilter.setMatchPattern(pattern);
            PatternQueryFilter filter = QueryFilterFactory.createPatternQueryFilter(identifier, nameFilter);
            ItemQueryUtil.addFilterToQueryCriteria(criteria, filter);
        }
    };

    public IQueryItem createQueryItem(String var1, String var2, IAuditableHandle var3, int var4, IReadScope var5) throws TeamRepositoryException;

    public void addFilter(IQueryItem var1, String var2, int var3);

    public void addFilter(IQueryItem var1, String var2, IItemHandle var3);

    public void addNameFilter(IQueryItem var1, String var2, String var3, boolean var4, boolean var5);
}

