/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.process;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.internal.Messages;
import com.ibm.team.scm.common.internal.dto.NameItemPair;
import com.ibm.team.scm.common.internal.dto.ServiceConfigurationProvider;
import com.ibm.team.scm.common.internal.process.AdvisorDataMarshaller;
import com.ibm.team.scm.common.process.CommitItem;
import com.ibm.team.scm.common.process.ICommitItem;
import com.ibm.team.scm.common.process.ICommitOperationData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class CommitOperationData
implements ICommitOperationData,
AdvisorDataMarshaller.IScmAdvisorMarshallable {
    private Map<UUID, IVersionable> cachedStateIdToState = new HashMap<UUID, IVersionable>();
    private Map<UUID, ICommitItem> items = new HashMap<UUID, ICommitItem>();
    private Map<UUID, Collection<UUID>> changeSetToItemMap = new HashMap<UUID, Collection<UUID>>();
    private Set<UUID> itemsWithExistingChanges = new HashSet<UUID>();
    private IScmService scmService;
    private IWorkspace workspace;
    private IComponent component;
    private ResolvedPaths paths;

    public CommitOperationData(IWorkspace workspace, IComponent component, IScmService scmService) {
        this.workspace = workspace;
        this.component = component;
        this.scmService = scmService;
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public IComponent getComponent() {
        return this.component;
    }

    public void setItem(IVersionableHandle beforeState, IVersionableHandle afterState, ICommitItem.ChangeType type) {
        CommitItem prop = new CommitItem(beforeState, afterState, type);
        if (afterState != null) {
            this.items.put(afterState.getItemId(), prop);
        } else {
            this.items.put(beforeState.getItemId(), prop);
        }
    }

    @Override
    public List<ICommitItem> getItems() {
        return new ArrayList<ICommitItem>(this.items.values());
    }

    @Override
    public ICommitItem getItem(UUID itemId) {
        return this.items.get(itemId);
    }

    @Override
    public void cacheStates(Collection<IVersionableHandle> versionableHandleList) throws TeamRepositoryException {
        if (versionableHandleList != null && !versionableHandleList.isEmpty()) {
            this.ensureCached(versionableHandleList);
        }
    }

    @Override
    public IVersionable getCachedState(IVersionableHandle versionableHandle) throws TeamRepositoryException {
        if (versionableHandle == null || versionableHandle.getStateId() == null) {
            return null;
        }
        IVersionable versionable = this.cachedStateIdToState.get(versionableHandle.getStateId());
        if (versionable != null) {
            return versionable;
        }
        throw new TeamRepositoryException(NLS.bind((String)Messages.getString("CommitOperationData.0"), (Object)versionableHandle.getStateId().getUuidValue()));
    }

    private void ensureCached(Collection<IVersionableHandle> versionableHandleList) throws TeamRepositoryException {
        int size;
        List<IVersionableHandle> versionableHandlesToFetch = this.listItemsToFetchFromServer(versionableHandleList);
        int left = size = versionableHandlesToFetch.size();
        int from = 0;
        while (left != 0) {
            IVersionable[] states;
            int toFetch = Math.min(2048, left);
            IVersionable[] iVersionableArray = states = this.scmService.fetchStates(versionableHandlesToFetch.subList(from, from + toFetch).toArray(new IVersionableHandle[toFetch]), IScmService.COMPLETE, null);
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                IVersionable v = iVersionableArray[n2];
                if (v != null) {
                    this.cachedStateIdToState.put(v.getStateId(), v);
                }
                ++n2;
            }
            left -= toFetch;
            from += toFetch;
        }
    }

    private List<IVersionableHandle> listItemsToFetchFromServer(Collection<IVersionableHandle> versionableHandleList) {
        ArrayList<IVersionableHandle> versionableHandlesToFetch = new ArrayList<IVersionableHandle>();
        for (IVersionableHandle item : versionableHandleList) {
            UUID stateId;
            if (item == null || (stateId = item.getStateId()) == null || this.cachedStateIdToState.containsKey(stateId)) continue;
            if (item instanceof IVersionable) {
                this.cachedStateIdToState.put(stateId, (IVersionable)item);
                continue;
            }
            versionableHandlesToFetch.add(item);
        }
        return versionableHandlesToFetch;
    }

    @Override
    public ICommitOperationData.IResolvedPaths getResolvedPaths() {
        if (this.paths == null) {
            this.paths = new ResolvedPaths();
        }
        return this.paths;
    }

    public void addChangeSetChanges(IChangeSetHandle changeSetHandle, Set<UUID> itemsForChangeSet) {
        this.changeSetToItemMap.put(changeSetHandle.getItemId(), itemsForChangeSet);
    }

    @Override
    public Collection<UUID> getChangedItemIds(IChangeSetHandle changeSetHandle) {
        Collection<UUID> result = this.changeSetToItemMap.get(changeSetHandle.getItemId());
        if (result == null) {
            return null;
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Collection<IChangeSetHandle> getAffectedChangeSets() {
        ArrayList<IChangeSetHandle> result = new ArrayList<IChangeSetHandle>();
        for (UUID itemId : this.changeSetToItemMap.keySet()) {
            result.add((IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(itemId, null));
        }
        return result;
    }

    @Override
    public boolean hasExistingChangeInActiveChangeSet(ICommitItem item) {
        UUID itemId = this.getItemId(item);
        return this.itemsWithExistingChanges.contains(itemId);
    }

    private UUID getItemId(ICommitItem item) {
        if (item.getAfterStateHandle() != null) {
            return item.getAfterStateHandle().getItemId();
        }
        return item.getBeforeStateHandle().getItemId();
    }

    public void addItemsWithExistingChangesInActiveChangeSets(Set<UUID> existingModifications) {
        this.itemsWithExistingChanges.addAll(existingModifications);
    }

    public class ResolvedPaths
    implements ICommitOperationData.IResolvedPaths {
        private Map<UUID, String> cachedStateIdToPath = new HashMap<UUID, String>();
        private Map<UUID, String> itemIdToBeforePath = new HashMap<UUID, String>();
        private Map<UUID, String> itemIdToAfterPath = new HashMap<UUID, String>();
        private Map<UUID, String> parentIdToPath = new HashMap<UUID, String>();
        private boolean pathsResolved = false;

        @Override
        public String getBeforePath(ICommitItem item) throws TeamRepositoryException {
            if (item == null) {
                return null;
            }
            this.ensurePathsAreCached();
            return this.cachedStateIdToPath.get(item.getBeforeStateHandle().getStateId());
        }

        @Override
        public String getAfterPath(ICommitItem item) throws TeamRepositoryException {
            if (item == null) {
                return null;
            }
            this.ensurePathsAreCached();
            return this.cachedStateIdToPath.get(item.getAfterStateHandle().getStateId());
        }

        private void ensurePathsAreCached() throws TeamRepositoryException {
            this.cachePaths(new ArrayList<ICommitItem>(CommitOperationData.this.items.values()));
        }

        private void cachePaths(List<ICommitItem> items) throws TeamRepositoryException {
            if (items == null || items.isEmpty() || this.pathsResolved) {
                return;
            }
            boolean isPathValidationRequired = false;
            ArrayList<IVersionableHandle> versionableHandleList = new ArrayList<IVersionableHandle>();
            for (ICommitItem item : items) {
                if (item.getChangeType().equals((Object)ICommitItem.ChangeType.MOVE_RENAME_TYPE)) {
                    isPathValidationRequired = true;
                }
                versionableHandleList.add(item.getBeforeStateHandle());
                versionableHandleList.add(item.getAfterStateHandle());
            }
            if (!versionableHandleList.isEmpty()) {
                CommitOperationData.this.ensureCached(versionableHandleList);
            }
            Map<UUID, String> beforeStateIdToPath = this.getBeforeStatePath(items);
            if (isPathValidationRequired) {
                this.populateItemIdToPath(beforeStateIdToPath, true);
            }
            Map<UUID, String> afterStateIdToPath = this.getAfterStatePath(items);
            if (isPathValidationRequired) {
                this.populateItemIdToPath(afterStateIdToPath, false);
                this.validateFetchedPaths(afterStateIdToPath);
            }
            this.cachedStateIdToPath.putAll(beforeStateIdToPath);
            this.cachedStateIdToPath.putAll(afterStateIdToPath);
            this.pathsResolved = true;
        }

        private void populateItemIdToPath(Map<UUID, String> stateIdToPath, boolean beforeState) {
            Set<UUID> stateIds = stateIdToPath.keySet();
            for (UUID stateId : stateIds) {
                IVersionable verItem = (IVersionable)CommitOperationData.this.cachedStateIdToState.get(stateId);
                if (beforeState) {
                    this.itemIdToBeforePath.put(verItem.getItemId(), stateIdToPath.get(stateId));
                    continue;
                }
                this.itemIdToAfterPath.put(verItem.getItemId(), stateIdToPath.get(stateId));
            }
        }

        private Map<UUID, String> getBeforeStatePath(List<ICommitItem> items) throws TeamRepositoryException {
            ArrayList<IVersionableHandle> pathsToFetch = new ArrayList<IVersionableHandle>();
            HashMap<UUID, String> stateIdToPath = new HashMap<UUID, String>();
            for (ICommitItem item : items) {
                if (item.getChangeType().equals((Object)ICommitItem.ChangeType.ADD_TYPE)) continue;
                this.populateBeforeStatePathsToFetch(item.getBeforeStateHandle(), stateIdToPath, pathsToFetch);
            }
            if (!pathsToFetch.isEmpty()) {
                stateIdToPath.putAll(this.fetchPaths(CommitOperationData.this.workspace, CommitOperationData.this.component, pathsToFetch, true));
            }
            return stateIdToPath;
        }

        private void populateBeforeStatePathsToFetch(IVersionableHandle stateHandle, Map<UUID, String> stateIdToPath, List<IVersionableHandle> pathsToFetch) {
            UUID stateId = stateHandle.getStateId();
            if (stateId != null) {
                if (this.cachedStateIdToPath.containsKey(stateId)) {
                    stateIdToPath.put(stateId, this.cachedStateIdToPath.get(stateId));
                } else {
                    pathsToFetch.add(stateHandle);
                }
            }
        }

        private Map<UUID, String> getAfterStatePath(List<ICommitItem> items) throws TeamRepositoryException {
            ArrayList<IVersionableHandle> parentPathsToFetch = new ArrayList<IVersionableHandle>();
            for (ICommitItem item : items) {
                UUID afterStateId = item.getAfterStateHandle().getStateId();
                if (afterStateId == null) continue;
                IVersionable verItem = (IVersionable)CommitOperationData.this.cachedStateIdToState.get(afterStateId);
                parentPathsToFetch.add(this.getParentPathsToFetch(verItem));
            }
            if (parentPathsToFetch != null) {
                this.parentIdToPath = this.fetchPaths(CommitOperationData.this.workspace, CommitOperationData.this.component, parentPathsToFetch, false);
            }
            HashMap<UUID, String> stateIdToPath = new HashMap<UUID, String>();
            for (ICommitItem item : items) {
                UUID afterStateId = item.getAfterStateHandle().getStateId();
                if (afterStateId == null) continue;
                IVersionable verItem = (IVersionable)CommitOperationData.this.cachedStateIdToState.get(afterStateId);
                stateIdToPath.put(afterStateId, this.fetchAfterPath(verItem, new StringBuffer()));
            }
            return stateIdToPath;
        }

        private IVersionableHandle getParentPathsToFetch(IVersionable item) throws TeamRepositoryException {
            if (CommitOperationData.this.items.keySet().contains(item.getParent().getItemId())) {
                return this.getParentPathsToFetch(this.getParentState(item));
            }
            return item.getParent();
        }

        private String fetchAfterPath(IVersionable item, StringBuffer path) throws TeamRepositoryException {
            UUID parentId = item.getParent().getItemId();
            if (CommitOperationData.this.items.keySet().contains(parentId)) {
                this.fetchAfterPath(this.getParentState(item), path);
            } else {
                path.append(this.parentIdToPath.get(parentId));
            }
            path.append(File.separator);
            path.append(item.getName());
            if (item.getItemType().equals(IFolder.ITEM_TYPE)) {
                this.parentIdToPath.put(item.getItemId(), path.toString());
            }
            return path.toString();
        }

        private IVersionable getParentState(IVersionable item) {
            ICommitItem parentItem = (ICommitItem)CommitOperationData.this.items.get(item.getParent().getItemId());
            IVersionable parentState = null;
            parentState = parentItem.getAfterStateHandle().getStateId() != null ? (IVersionable)CommitOperationData.this.cachedStateIdToState.get(parentItem.getAfterStateHandle().getStateId()) : (IVersionable)CommitOperationData.this.cachedStateIdToState.get(parentItem.getBeforeStateHandle().getStateId());
            return parentState;
        }

        private Map<UUID, String> fetchPaths(IWorkspaceHandle workspace, IComponentHandle component, List<IVersionableHandle> handles, boolean fetchBeforeState) throws TeamRepositoryException {
            int size;
            int left = size = handles.size();
            int from = 0;
            HashMap<UUID, String> idToPath = new HashMap<UUID, String>();
            while (left != 0) {
                int toFetch = Math.min(2048, left);
                IAncestorReport[] ancestorReports = CommitOperationData.this.scmService.configurationLocateAncestors(ServiceConfigurationProvider.FACTORY.create(workspace, component), handles.subList(from, from + toFetch).toArray(new IVersionableHandle[toFetch]), null, null);
                int i = 0;
                while (i < ancestorReports.length) {
                    StringBuffer buffer = new StringBuffer();
                    for (Object o : ancestorReports[i].getNameItemPairs()) {
                        NameItemPair pair = (NameItemPair)o;
                        if (pair.getName() == null) continue;
                        buffer.append(File.separator);
                        buffer.append(pair.getName());
                    }
                    if (fetchBeforeState) {
                        idToPath.put(handles.get(i).getStateId(), buffer.toString());
                    } else {
                        idToPath.put(handles.get(i).getItemId(), buffer.toString());
                    }
                    ++i;
                }
                left -= toFetch;
                from += toFetch;
            }
            return idToPath;
        }

        private void validateFetchedPaths(Map<UUID, String> stateIdToPath) {
            HashMap<Integer, ArrayList<UUID>> sortedStateIds = new HashMap<Integer, ArrayList<UUID>>();
            Set<UUID> stateIds = stateIdToPath.keySet();
            ArrayList<Integer> keys = new ArrayList<Integer>();
            for (UUID stateId : stateIds) {
                String path = stateIdToPath.get(stateId);
                String[] segments = path.split(Pattern.quote(File.separator));
                int key = segments.length;
                keys.add(key);
                if (sortedStateIds.containsKey(key)) {
                    ((List)sortedStateIds.get(key)).add(stateId);
                    continue;
                }
                sortedStateIds.put(key, new ArrayList<UUID>(Arrays.asList(stateId)));
            }
            if (keys.size() > 1) {
                Collections.sort(keys);
                int maxNumberOfSegments = (Integer)keys.get(keys.size() - 1);
                int i = 0;
                while (i < keys.size()) {
                    if ((Integer)keys.get(i) < maxNumberOfSegments) {
                        List stateIdsToCheckWith = (List)sortedStateIds.get(keys.get(i));
                        List stateIdsWhosePathNeedToBeValidated = (List)sortedStateIds.get(keys.get(i + 1));
                        for (UUID stateId : stateIdsToCheckWith) {
                            IVersionable verItem = (IVersionable)CommitOperationData.this.cachedStateIdToState.get(stateId);
                            String pathToCheckWith = this.itemIdToBeforePath.get(verItem.getItemId());
                            if (pathToCheckWith == null) continue;
                            String updatedSubPath = this.itemIdToAfterPath.get(verItem.getItemId());
                            this.UpdatePath(pathToCheckWith, updatedSubPath, stateIdToPath, stateIdsWhosePathNeedToBeValidated);
                        }
                    }
                    ++i;
                }
            }
        }

        private void UpdatePath(String subPathToCheck, String updatedSubPath, Map<UUID, String> stateIdToPath, List<UUID> stateIdsToReplaceFor) {
            for (UUID stateId : stateIdsToReplaceFor) {
                String unValidatedAfterPath = stateIdToPath.get(stateId);
                if (!unValidatedAfterPath.startsWith(subPathToCheck, 0)) continue;
                String updatedPath = null;
                if (updatedSubPath != null) {
                    String unalteredPath = unValidatedAfterPath.substring(subPathToCheck.length());
                    updatedPath = String.valueOf(updatedSubPath) + unalteredPath;
                }
                stateIdToPath.put(stateId, updatedPath);
                this.itemIdToAfterPath.put(((IVersionable)CommitOperationData.this.cachedStateIdToState.get(stateId)).getItemId(), updatedPath);
            }
        }
    }
}

