/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.location;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.internal.util.LocationUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ScmPackage;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EClass;

public class SCMLocationUtil {
    private static final ItemType VERSIONABLE_ITEM_TYPE = ItemUtil.itemTypeFor((EClass)ScmPackage.eINSTANCE.getVersionable());

    private SCMLocationUtil() {
    }

    public static Location getVersionableLocation(String repoURI, IWorkspaceHandle workspaceHandle, IComponentHandle component, IPath remotePath) {
        Location workspaceLoc = Location.itemLocation((IItemHandle)workspaceHandle, null);
        Location componentLoc = Location.itemLocation((IItemHandle)component, null);
        String query = "workspace=" + workspaceLoc + "&component=" + componentLoc;
        Location versionableLoc = Location.pathLocation((IItemType)VERSIONABLE_ITEM_TYPE, (String)repoURI, (String[])remotePath.segments(), (String)query, null);
        return versionableLoc;
    }

    public static String getEncodedRelativeVersionableLocationSegment(IVersionableHandle itemHandle) throws TeamRepositoryException {
        Location loc = itemHandle.hasStateId() ? Location.stateLocation((IItemHandle)itemHandle, null) : Location.itemLocation((IItemHandle)itemHandle, null);
        String segment = loc.toRelativeUri().toString();
        try {
            return LocationUtil.encode((String)segment);
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getEncodedRelativeItemLocationSegments(IItemHandle itemHandle) throws TeamRepositoryException {
        String segment = SCMLocationUtil.getRelativeItemLocationSegments(itemHandle);
        try {
            return LocationUtil.encode((String)segment);
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getRelativeItemLocationSegments(IItemHandle itemHandle) {
        Location loc = Location.itemLocation((IItemHandle)itemHandle, null);
        String segment = loc.toRelativeUri().toString();
        return segment;
    }

    public static String getItemTypeString(IItemType itemType) {
        String ns = itemType.getNamespaceURI();
        String name = itemType.getName();
        return String.valueOf(ns) + "." + name;
    }

    public static IItemType getItemTypeFromString(String qualifiedName) {
        int separatorIndex = qualifiedName.lastIndexOf(".");
        Assert.isLegal((separatorIndex != -1 ? 1 : 0) != 0, (String)("Unqualified name \"" + qualifiedName + "\""));
        Assert.isLegal((separatorIndex < qualifiedName.length() - 1 ? 1 : 0) != 0);
        String namespace = qualifiedName.substring(0, separatorIndex);
        String name = qualifiedName.substring(separatorIndex + 1);
        Assert.isLegal((!namespace.isEmpty() ? 1 : 0) != 0);
        Assert.isLegal((!name.isEmpty() ? 1 : 0) != 0);
        return IItemType.IRegistry.INSTANCE.getItemType(name, namespace);
    }

    public static String getItemTypeString(IItemHandle handle) {
        return SCMLocationUtil.getItemTypeString(handle.getItemType());
    }

    public static String getItemIdString(IItemHandle handle) {
        return handle.getItemId().getUuidValue();
    }

    public static String getStateIdString(IItemHandle handle) {
        return handle.getStateId().getUuidValue();
    }

    public static String join(String sep, String ... entries) {
        if (entries.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(entries[0]);
        int i = 1;
        while (i < entries.length) {
            result.append(sep);
            result.append(entries[i]);
            ++i;
        }
        return result.toString();
    }
}

