/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.links;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class LinkTypeUtils {
    private LinkTypeUtils() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    public static String getIconPath(IEndPointDescriptor descriptor, String bundleName) {
        String uri = null;
        if (descriptor != null && descriptor.getIcon() != null) {
            Path path = new Path(descriptor.getIcon().getPath());
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle != null) {
                URL file = FileLocator.find((Bundle)bundle, (IPath)path, null);
                try {
                    URL resolved = FileLocator.resolve((URL)file);
                    if (resolved != null) {
                        uri = resolved.toString();
                        uri = uri.replaceAll(" ", "%20");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return uri;
    }

    static String oslcPropertyDTORepresentation(URI oslcProperty) {
        return oslcProperty.toString();
    }

    static URI oslcPropertyDBToURI(String oslcPropertyDtoStr) {
        try {
            return new URI(oslcPropertyDtoStr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid OSLC property: %s", oslcPropertyDtoStr));
        }
    }
}

