/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.links;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.links.common.ILinkTypeHandle;
import com.ibm.team.links.common.LinkTypeExtendedPropertyUtil;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.scm.common.internal.dto.ExternalLinkEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;

public final class LinkTypeIdentifier {
    private static String HAS_INSTANCE_ID = "Link type has instance info";
    private final String idValue;
    private final String instanceId;

    public static LinkTypeIdentifier createFromLinkTypeHandle(ILinkTypeHandle linkTypeHandle) {
        return LinkTypeIdentifier.createFromLinkTypeIdAndInstance(linkTypeHandle.getLinkTypeId(), linkTypeHandle.getLinkTypeInstanceId());
    }

    public static LinkTypeIdentifier createFromDTO(ExternalLinkEntry dtoValue) {
        if (dtoValue == null) {
            throw new IllegalArgumentException("dtoValue can not be null");
        }
        return LinkTypeIdentifier.createFromLinkTypeIdAndInstance(dtoValue.getType(), dtoValue.getTypeInstanceId());
    }

    public static LinkTypeIdentifier create(ILinkType type) {
        ILinkTypeHandle linkTypeHandle = LinkTypeExtendedPropertyUtil.getInstance().getLinkTypeHandle(type);
        return LinkTypeIdentifier.createFromLinkTypeHandle(linkTypeHandle);
    }

    public static LinkTypeIdentifier create(DataInputStream in) throws IOException {
        String internalId;
        String firstVal = in.readUTF();
        String internalInstanceId = null;
        if (HAS_INSTANCE_ID.equals(firstVal)) {
            internalId = in.readUTF();
            internalInstanceId = in.readUTF();
        } else {
            internalId = firstVal;
        }
        return LinkTypeIdentifier.createFromLinkTypeIdAndInstance(internalId, internalInstanceId);
    }

    public static LinkTypeIdentifier createFromLinkTypeIdAndInstance(String linkTypeId, String linkTypeInstanceId) {
        Assert.isNotNull((Object)linkTypeId);
        return new LinkTypeIdentifier(linkTypeId, linkTypeInstanceId);
    }

    private LinkTypeIdentifier(String idValue, String instanceId) {
        this.idValue = idValue;
        this.instanceId = instanceId;
        assert (idValue != null);
    }

    public String toString() {
        String format = this.instanceId != null ? "<{0}, {1}>" : "<{0}>";
        return MessageFormat.format((String)format, (Object[])new Object[]{this.idValue, this.instanceId});
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        if (this.instanceId == null) {
            out.writeUTF(this.idValue);
        } else {
            out.writeUTF(HAS_INSTANCE_ID);
            out.writeUTF(this.idValue);
            out.writeUTF(this.instanceId);
        }
    }

    public String toLinkServiceId() {
        return this.idValue;
    }

    public boolean sameLinkTypeAs(ILinkType registeredLinkType) {
        String internalId = registeredLinkType.getLinkTypeId();
        return this.toLinkServiceId().equals(internalId);
    }

    public boolean sameLinkTypeAs(LinkTypeIdentifier otherType) {
        if (otherType == null) {
            return false;
        }
        return Objects.equals(this.idValue, otherType.idValue);
    }

    public boolean sameLinkTypeAndInstanceAs(LinkTypeIdentifier otherType) {
        return Objects.equals(this.idValue, otherType.idValue) && Objects.equals(this.instanceId, otherType.instanceId);
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

