/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.links;

import com.ibm.team.links.common.LinkTypeExtendedPropertyUtil;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.scm.common.links.ILinkTypeInfo;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;

public final class CustomLinkTypeInfo
implements ILinkTypeInfo {
    private final String label;
    private final URI iconUri;
    private final String reverseLabel;
    private final URI reverseIconUri;
    private final URI oslcProperty;

    public static ILinkTypeInfo create(ILinkType type) {
        if (type == null) {
            return null;
        }
        return new CustomLinkTypeInfo(CustomLinkTypeInfo.getLabel(type.getTargetEndPointDescriptor()), CustomLinkTypeInfo.getIconUri(type.getTargetEndPointDescriptor()), CustomLinkTypeInfo.getLabel(type.getSourceEndPointDescriptor()), CustomLinkTypeInfo.getIconUri(type.getSourceEndPointDescriptor()), CustomLinkTypeInfo.getOslcPropertyUri(type));
    }

    private static String getLabel(IEndPointDescriptor endPointDescriptor) {
        if (endPointDescriptor == null) {
            return null;
        }
        return endPointDescriptor.getDisplayName();
    }

    private static URI getIconUri(IEndPointDescriptor endPointDescriptor) {
        if (endPointDescriptor == null || endPointDescriptor.getIcon() == null) {
            return null;
        }
        try {
            return endPointDescriptor.getIcon().toURI();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static URI getOslcPropertyUri(ILinkType type) {
        return LinkTypeExtendedPropertyUtil.getInstance().getOslcPropertyUri(type);
    }

    private CustomLinkTypeInfo(String label, URI iconUri, String reverseLabel, URI reverseIconUri, URI oslcProperty) {
        this.label = label;
        this.iconUri = iconUri;
        this.reverseLabel = reverseLabel;
        this.reverseIconUri = reverseIconUri;
        this.oslcProperty = oslcProperty;
        Assert.isNotNull((Object)label);
        Assert.isNotNull((Object)reverseLabel);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getReverseLinkLabel() {
        return this.reverseLabel;
    }

    @Override
    public URI getIconUri() {
        return this.iconUri;
    }

    @Override
    public URI getReverseLinkIconUri() {
        return this.reverseIconUri;
    }

    @Override
    public URI getOslcPropertyUri() {
        return this.oslcProperty;
    }
}

