/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.links;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.ItemProviderUtil;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.providers.LinkProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChangeSetLinks {
    public static final List<ILink> findLinks(ProviderFactory providerFactory, IChangeSetHandle changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return ChangeSetLinks.findLinks(providerFactory, changeSetHandle, null, monitor);
    }

    public static final List<ILink> findLinks(ProviderFactory providerFactory, IChangeSetHandle changeSetHandle, String[] linkTypeIds, IProgressMonitor monitor) throws TeamRepositoryException {
        LinkProvider linkProvider = providerFactory.getLinkProvider();
        return ChangeSetLinks.findLinks(linkProvider, changeSetHandle, linkTypeIds, monitor);
    }

    public static List<ILink> findLinks(LinkProvider linkProvider, IChangeSetHandle changeSetHandle, String[] linkTypeIds, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<ILink> links = new ArrayList<ILink>();
        IItemReference source = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)changeSetHandle, "", "");
        ILinkQueryPage results = null;
        results = linkTypeIds == null ? linkProvider.findLinksBySource((IReference)source, (IProgressMonitor)progress.newChild(100)) : linkProvider.findLinksBySource(linkTypeIds, (IReference)source, (IProgressMonitor)progress.newChild(100));
        ILinkCollection collection = results.getAllLinksFromHereOn();
        links.addAll((Collection<ILink>)collection);
        return links;
    }

    public static Map<IChangeSet, List<IAuditable>> resolveLinks(ProviderFactory providerFactory, List<IChangeSetHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return ChangeSetLinks.resolveLinks(providerFactory, handles, "com.ibm.team.filesystem.workitems.change_set", monitor);
    }

    public static Map<IChangeSet, List<IAuditable>> resolveLinks(ProviderFactory providerFactory, List<IChangeSetHandle> handles, String linkTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeSet changeSet;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List changeSetIds = ItemLists.handlesToIds(handles);
        Map<ItemId<IChangeSet>, List<ItemId<IAuditable>>> unfetched = ItemProviderUtil.resolveLinks(providerFactory, changeSetIds, linkTypeId, (IProgressMonitor)progress.newChild(60));
        HashSet toFetch = NewCollection.hashSet();
        for (Map.Entry<ItemId<IChangeSet>, List<ItemId<IAuditable>>> e : unfetched.entrySet()) {
            ItemId nextCs = e.getKey();
            ItemId auditable = ItemId.upcast(nextCs);
            toFetch.add(auditable);
            toFetch.addAll((Collection)e.getValue());
        }
        for (ItemId nextCs : changeSetIds) {
            ItemId auditable = ItemId.upcast(nextCs);
            toFetch.add(auditable);
        }
        Map fetched = ItemProviderUtil.fetchCurrents(providerFactory, toFetch, (IProgressMonitor)progress.newChild(40));
        HashMap<IChangeSet, List<IAuditable>> result = NewCollection.hashMap();
        for (Map.Entry<ItemId<IChangeSet>, List<ItemId<IAuditable>>> next : unfetched.entrySet()) {
            changeSet = (IChangeSet)fetched.get(next.getKey());
            if (changeSet == null) continue;
            ArrayList auditables = NewCollection.arrayList();
            for (ItemId<IAuditable> nextAuditable : next.getValue()) {
                IAuditable aud = (IAuditable)fetched.get(nextAuditable);
                if (aud == null) continue;
                auditables.add(aud);
            }
            result.put(changeSet, auditables);
        }
        for (ItemId nextCs : changeSetIds) {
            changeSet = (IChangeSet)fetched.get(nextCs);
            if (changeSet == null || result.containsKey(changeSet)) continue;
            result.put(changeSet, Collections.emptyList());
        }
        return result;
    }

    public static final String summarizeLink(ProviderFactory providerFactory, ILink link, IProgressMonitor monitor) throws TeamRepositoryException {
        IReference targetRef = link.getTargetRef();
        if (targetRef.isItemReference()) {
            IManagedItemHandle handle = (IManagedItemHandle)((IItemReference)targetRef).getReferencedItem();
            try {
                IManagedItem item = providerFactory.getItemProvider().fetchItem(handle, monitor);
                return ChangeSetLinks.describe((IItem)item);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return "";
    }

    public static final String getPlannedFor(ProviderFactory providerFactory, ILink link, IProgressMonitor monitor) throws TeamRepositoryException {
        IReference targetRef = link.getTargetRef();
        if (targetRef.isItemReference()) {
            IManagedItemHandle handle = (IManagedItemHandle)((IItemReference)targetRef).getReferencedItem();
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IManagedItem item = providerFactory.getItemProvider().fetchItem(handle, (IProgressMonitor)progress.newChild(50));
                IIterationHandle iterationHandle = ChangeSetLinks.getIteration((IItem)item);
                if (iterationHandle != null) {
                    IIteration iteration = (IIteration)providerFactory.getItemProvider().fetchItem((IManagedItemHandle)iterationHandle, (IProgressMonitor)progress.newChild(50));
                    String name = iteration.getName();
                    if (!name.isEmpty()) {
                        return name;
                    }
                } else {
                    progress.done();
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final IIterationHandle getIteration(IItem workItem) {
        try {
            Method getTargetMethod = workItem.getClass().getMethod("getTarget", new Class[0]);
            return (IIterationHandle)getTargetMethod.invoke((Object)workItem, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final String describe(IItem item) {
        try {
            Method getDescriptionMethod = item.getClass().getMethod("getSummary", new Class[0]);
            Method getIdMethod = item.getClass().getMethod("getId", new Class[0]);
            String summary = (String)getDescriptionMethod.invoke((Object)item, new Object[0]);
            Integer id = (Integer)getIdMethod.invoke((Object)item, new Object[0]);
            return id + ": " + summary;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<ILink> filter(List<ILink> links, String linkTypeId) {
        ArrayList<ILink> result = new ArrayList<ILink>();
        for (ILink link : links) {
            if (!link.getLinkTypeId().equals(linkTypeId)) continue;
            result.add(link);
        }
        return result;
    }

    public static String serializeExtraInfo(String repoUri, UUID repoUuid) {
        return NLS.bind((String)"<repository uri=\"{0}\" id=\"{1}\"/>", (Object)repoUri, (Object[])new Object[]{repoUuid.getUuidValue()});
    }
}

