/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.calm.foundation.common.SecureDocumentBuilderFactory;
import com.ibm.team.repository.common.LogFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class XMLUtil {
    public static final String XML_CONSTANTS_ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";
    public static final String XML_CONSTANTS_ACCESS_EXTERNAL_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
    public static final String XML_CONSTANTS_ACCESS_EXTERNAL_STYLESHEET = "http://javax.xml.XMLConstants/property/accessExternalStylesheet";
    public static final String ALLOWED_EXTERNAL_LOAD_PROTOCOL = "bundleresource,jar:file,file";

    public static DocumentBuilderFactory getSecureDocumentBuilderFactory() throws ParserConfigurationException {
        return SecureDocumentBuilderFactory.newInstance();
    }

    public static DocumentBuilderFactory getSecureDocumentBuilderFactoryForDTD() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        XMLUtil.setFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        XMLUtil.setFeature(factory, "http://xml.org/sax/features/validation", false);
        XMLUtil.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        XMLUtil.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        XMLUtil.setFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        XMLUtil.setFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setAttribute(XML_CONSTANTS_ACCESS_EXTERNAL_SCHEMA, ALLOWED_EXTERNAL_LOAD_PROTOCOL);
        return factory;
    }

    private static void setFeature(DocumentBuilderFactory factory, String feature, boolean enabled) {
        try {
            factory.setFeature(feature, enabled);
        }
        catch (ParserConfigurationException e) {
            LogFactory.getLog((String)SecureDocumentBuilderFactory.class.getName()).warn((Object)NLS.bind((String)"Could not set feature {0} to {1} for XML parser", (Object)feature, (Object)enabled), (Throwable)e);
        }
    }

    public static SAXParserFactory getSecureSAXParserFactory() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return SecureDocumentBuilderFactory.getSecureSAXParserFactory();
    }
}

