/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;

public class SiloedItemId<T extends IVersionable> {
    private IItemType itemType;
    private UUID itemId;
    private UUID componentId;

    private SiloedItemId(ItemId<T> item, UUID componentId) {
        this(item.getItemType(), item.getItemUUID(), componentId);
    }

    public SiloedItemId(IItemType itemType, UUID itemUUID, UUID componentId) {
        this.itemType = itemType;
        this.itemId = itemUUID;
        this.componentId = componentId;
    }

    public ItemId<T> getItemId() {
        return new ItemId(this.itemType, this.itemId);
    }

    public ItemId<IComponent> getComponent() {
        return new ItemId<IComponent>(IComponent.ITEM_TYPE, this.componentId);
    }

    public static <T extends IVersionable> SiloedItemId<T> create(ItemId<T> item, ItemId<IComponent> component) {
        return new SiloedItemId<T>(item, component.getItemUUID());
    }

    public static <T extends IVersionable> SiloedItemId<T> create(IItemType itemType, UUID itemId, UUID componentId) {
        return new SiloedItemId<T>(itemType, itemId, componentId);
    }

    public static <T extends IVersionable> SiloedItemId<T> create(IVersionableHandle itemId, ItemId<IComponent> component) {
        return SiloedItemId.create(new ItemId((IItemHandle)itemId), component);
    }

    public static <T extends IVersionable> SiloedItemId<T> create(IVersionableHandle itemId, IComponentHandle component) {
        return new SiloedItemId(new ItemId((IItemHandle)itemId), component.getItemId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.componentId == null ? 0 : this.componentId.hashCode());
        result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
        result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiloedItemId other = (SiloedItemId)obj;
        if (this.componentId == null ? other.componentId != null : !this.componentId.equals((Object)other.componentId)) {
            return false;
        }
        if (this.itemId == null ? other.itemId != null : !this.itemId.equals((Object)other.itemId)) {
            return false;
        }
        return !(this.itemType == null ? other.itemType != null : !this.itemType.equals(other.itemType));
    }

    public static <K extends IVersionable, T extends K> SiloedItemId<K> upcast(SiloedItemId<T> create) {
        return create;
    }

    public String toString() {
        return "(" + this.itemType.getName() + ", " + this.itemId.getUuidValue() + ", " + this.componentId.getUuidValue() + ")";
    }

    public UUID getItemUUID() {
        return this.itemId;
    }

    public UUID getComponentUUID() {
        return this.componentId;
    }

    public IVersionableHandle toHandle() {
        return (IVersionableHandle)this.itemType.createItemHandle(this.itemId, null);
    }

    public IVersionableHandle toHandle(Object origin) {
        return (IVersionableHandle)this.itemType.createItemHandle(origin, this.itemId, null);
    }

    public IComponentHandle getComponentHandle() {
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(this.componentId, null);
    }

    public boolean isNull() {
        return this.itemId.equals((Object)ItemId.getNullItemUUID());
    }

    public static <T extends IVersionable> SiloedItemId<T> getNullItem(IItemType itemType2) {
        return SiloedItemId.create(ItemId.getNullItem(itemType2), (ItemId<IComponent>)ItemId.getNullItem(IComponent.ITEM_TYPE));
    }

    public IItemType getItemType() {
        return this.itemType;
    }

    public boolean isUntyped() {
        return this.itemType == ItemId.getNullItemType();
    }

    public IVersionableHandle toHandle(IItemType type) {
        if (this.itemType == type) {
            return this.toHandle();
        }
        return SiloedItemId.create(type, this.itemId, this.componentId).toHandle();
    }
}

