/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.dto.IAccessGroupScope;
import com.ibm.team.scm.common.dto.IArchivedScope;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.internal.dto.AccessGroupScope;
import com.ibm.team.scm.common.internal.dto.ArchivedScope;
import com.ibm.team.scm.common.internal.dto.ContributorDeferringScope;
import com.ibm.team.scm.common.internal.dto.DeletedScope;
import com.ibm.team.scm.common.internal.dto.PrivateScope;
import com.ibm.team.scm.common.internal.dto.ProcessAreaScope;
import com.ibm.team.scm.common.internal.dto.PublicScope;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.TeamAreaPrivateScope;

public abstract class ReadScopeUtils {
    public static final UUID CUSTOM_PRIVATE = UUID.valueOf((String)"_p57xQODvEd2JvqtXLuqiiw");
    public static final UUID NON_NULL_CONTEXT = UUID.valueOf((String)"_41lL4EG-EeWd1OFb3L5ZOQ");
    public static final UUID OWNER_SENTINEL = UUID.valueOf((String)"_sWwvYCRGEeufe97885bueg");
    public static final UUID CUSTOM_PUBLIC = null;

    private static IAuditableHandle computeProcessAreaScope(UUID customContext) {
        if (customContext == null) {
            return null;
        }
        if (customContext.equals((Object)CUSTOM_PRIVATE)) {
            return null;
        }
        return (IAuditableHandle)IProjectArea.ITEM_TYPE.createItemHandle(customContext, null);
    }

    public static IReadScope computeReadScope(IAuditableHandle owner, int readPermissionMode, UUID context) {
        switch (readPermissionMode) {
            case 16: {
                ArchivedScope archived = (ArchivedScope)IReadScope.FACTORY.createArchivedScope();
                archived.setOwner(owner);
                return archived;
            }
            case 0: {
                if (owner instanceof IContributorHandle) {
                    if (context == null) {
                        PublicScope pub = (PublicScope)IReadScope.FACTORY.createPublicScope();
                        if (!OWNER_SENTINEL.equals((Object)owner.getItemId())) {
                            pub.setOwner(owner);
                        }
                        return pub;
                    }
                    if (CUSTOM_PRIVATE.equals((Object)context)) {
                        PrivateScope pri = (PrivateScope)IReadScope.FACTORY.createPrivateScope();
                        if (!OWNER_SENTINEL.equals((Object)owner.getItemId())) {
                            pri.setOwner(owner);
                        }
                        return pri;
                    }
                    if (NON_NULL_CONTEXT.equals((Object)context)) {
                        return IReadScope.FACTORY.createContributorDeferringScope();
                    }
                    IAuditableHandle item = ReadScopeUtils.computeProcessAreaScope(context);
                    if (item == null) {
                        return IReadScope.FACTORY.createUnknownScope();
                    }
                    IContributorDeferringScope cds = IReadScope.FACTORY.createContributorDeferringScope();
                    cds.setScope(item);
                    return cds;
                }
                if (owner instanceof IProcessAreaHandle || owner == null) {
                    ProcessAreaScope pas = (ProcessAreaScope)IReadScope.FACTORY.createProcessAreaScope();
                    if (owner != null && !owner.getItemId().equals((Object)OWNER_SENTINEL)) {
                        pas.setProcessArea(owner);
                    }
                    return pas;
                }
                return IReadScope.FACTORY.createUnknownScope();
            }
            case 1: {
                TeamAreaPrivateScope taps = (TeamAreaPrivateScope)IReadScope.FACTORY.createTeamAreaPrivateScope();
                taps.setTeamArea(owner);
                return taps;
            }
            case 2: {
                if (context == null) {
                    return IReadScope.FACTORY.createUnknownScope();
                }
                AccessGroupScope ags = (AccessGroupScope)IReadScope.FACTORY.createAccessGroupScope();
                ags.setAccessGroup((IAuditableHandle)IAccessGroup.ITEM_TYPE.createItemHandle(context, null));
                return ags;
            }
            case 32: 
            case 64: {
                DeletedScope deleted = ScmDtoFactory.eINSTANCE.createDeletedScope();
                deleted.setDeletedBy(owner);
                return deleted;
            }
        }
        return IReadScope.FACTORY.createUnknownScope();
    }

    public static int getReadPermissionModeFor(IReadScope scope) throws TeamRepositoryException {
        if (scope instanceof PrivateScope) {
            return 0;
        }
        if (scope instanceof PublicScope) {
            return 0;
        }
        if (scope instanceof ContributorDeferringScope) {
            return 0;
        }
        if (scope instanceof ProcessAreaScope) {
            return 0;
        }
        if (scope instanceof TeamAreaPrivateScope) {
            return 1;
        }
        if (scope instanceof AccessGroupScope) {
            return 2;
        }
        if (scope instanceof ArchivedScope) {
            return 16;
        }
        if (scope instanceof DeletedScope) {
            return 64;
        }
        throw new TeamRepositoryException((Throwable)new IllegalArgumentException("Unknown scope: " + scope.getClass().getName()));
    }

    public static UUID getCustomContext(IReadScope scope) throws TeamRepositoryException {
        if (scope instanceof PublicScope) {
            return CUSTOM_PUBLIC;
        }
        if (scope instanceof PrivateScope) {
            return CUSTOM_PRIVATE;
        }
        if (scope instanceof ContributorDeferringScope) {
            IAuditableHandle context = ((ContributorDeferringScope)scope).getScope();
            return context != null ? context.getItemId() : NON_NULL_CONTEXT;
        }
        if (scope instanceof AccessGroupScope) {
            return ((AccessGroupScope)scope).getAccessGroupId();
        }
        return null;
    }

    public static boolean equals(IReadScope rs1, IReadScope rs2) {
        if (rs1 == null && rs2 == null) {
            return true;
        }
        if (rs1 == null || rs2 == null) {
            return false;
        }
        if (rs1 instanceof IContributorDeferringScope && rs2 instanceof IContributorDeferringScope) {
            return ((IContributorDeferringScope)rs1).getScope().sameItemId((IItemHandle)((IContributorDeferringScope)rs2).getScope());
        }
        if (rs1 instanceof IPrivateScope && rs2 instanceof IPrivateScope) {
            return true;
        }
        if (rs1 instanceof IArchivedScope && rs2 instanceof IArchivedScope) {
            if (((ArchivedScope)rs1).getOwner() == null) {
                return ((ArchivedScope)rs2).getOwner() == null;
            }
            return ((ArchivedScope)rs1).getOwner().sameItemId((IItemHandle)((ArchivedScope)rs2).getOwner());
        }
        if (rs1 instanceof IProcessAreaScope && rs2 instanceof IProcessAreaScope) {
            if (((IProcessAreaScope)rs1).getProcessArea() == null) {
                return ((IProcessAreaScope)rs2).getProcessArea() == null;
            }
            return ((IProcessAreaScope)rs1).getProcessArea().sameItemId((IItemHandle)((IProcessAreaScope)rs2).getProcessArea());
        }
        if (rs1 instanceof IPublicScope && rs2 instanceof IPublicScope) {
            return true;
        }
        if (rs1 instanceof ITeamAreaPrivateScope && rs2 instanceof ITeamAreaPrivateScope) {
            if (((ITeamAreaPrivateScope)rs1).getTeamArea() == null) {
                return ((ITeamAreaPrivateScope)rs2).getTeamArea() == null;
            }
            return ((ITeamAreaPrivateScope)rs1).getTeamArea().sameItemId((IItemHandle)((ITeamAreaPrivateScope)rs2).getTeamArea());
        }
        if (rs1 instanceof IAccessGroupScope && rs2 instanceof IAccessGroupScope) {
            if (((IAccessGroupScope)rs1).getAccessGroupId() == null) {
                return ((IAccessGroupScope)rs2).getAccessGroupId() == null;
            }
            return ((IAccessGroupScope)rs1).getAccessGroupId().equals((Object)((IAccessGroupScope)rs2).getAccessGroupId());
        }
        return false;
    }

    public static void validateOwnerAndVisibility(IAuditableHandle owner, IReadScope scope) throws TeamRepositoryException {
        IAuditableHandle processArea;
        if (!(owner instanceof IContributorHandle) && !(owner instanceof IProcessAreaHandle)) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        if (!(!(owner instanceof IContributorHandle) || scope instanceof PrivateScope || scope instanceof PublicScope || scope instanceof ContributorDeferringScope || scope instanceof AccessGroupScope || scope instanceof ArchivedScope)) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException("Contributor owner is not compatible with scope:" + scope.getClass().getName()));
        }
        if (owner instanceof IProjectAreaHandle && !(scope instanceof ProcessAreaScope) && !(scope instanceof AccessGroupScope)) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException("Project Area owner is not compatible with scope: " + scope.getClass().getName()));
        }
        if (owner instanceof ITeamAreaHandle && !(scope instanceof TeamAreaPrivateScope) && !(scope instanceof ProcessAreaScope) && !(scope instanceof AccessGroupScope)) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException("Team Area owner is not compatible with scope: " + scope.getClass().getName()));
        }
        if (scope instanceof ContributorDeferringScope) {
            ContributorDeferringScope cds = (ContributorDeferringScope)scope;
            if (cds.getScope() == null) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException("Missing scope"));
            }
            if (!(cds.getScope() instanceof IProjectAreaHandle)) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException("Wrong scope type: " + cds.getScope().getClass().getName()));
            }
        }
        if (scope instanceof ProcessAreaScope && (processArea = ((ProcessAreaScope)scope).getProcessArea()) != null) {
            if (!(processArea instanceof IProcessAreaHandle)) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
            }
            if (!processArea.sameItemId((IItemHandle)owner)) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException("Owner and scope must match: " + processArea + " != " + owner));
            }
        }
    }

    public static IAuditableHandle getOwner(IReadScope scope) {
        if (scope instanceof PrivateScope) {
            IAuditableHandle owner = ((PrivateScope)scope).getOwner();
            return owner != null ? owner : (IAuditableHandle)IContributor.ITEM_TYPE.createItemHandle(OWNER_SENTINEL, null);
        }
        if (scope instanceof PublicScope) {
            IAuditableHandle owner = ((PublicScope)scope).getOwner();
            return owner != null ? owner : (IAuditableHandle)IContributor.ITEM_TYPE.createItemHandle(OWNER_SENTINEL, null);
        }
        if (scope instanceof ContributorDeferringScope) {
            return (IAuditableHandle)IContributor.ITEM_TYPE.createItemHandle(OWNER_SENTINEL, null);
        }
        if (scope instanceof ProcessAreaScope) {
            IAuditableHandle processArea = ((ProcessAreaScope)scope).getProcessArea();
            return processArea != null ? processArea : (IAuditableHandle)IProjectArea.ITEM_TYPE.createItemHandle(OWNER_SENTINEL, null);
        }
        if (scope instanceof TeamAreaPrivateScope) {
            return ((TeamAreaPrivateScope)scope).getTeamArea();
        }
        if (scope instanceof AccessGroupScope) {
            return ((AccessGroupScope)scope).getAccessGroup();
        }
        if (scope instanceof ArchivedScope) {
            return ((ArchivedScope)scope).getOwner();
        }
        if (scope instanceof DeletedScope) {
            return ((DeletedScope)scope).getDeletedBy();
        }
        return null;
    }
}

