/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import com.ibm.team.scm.common.dto.IDateOrderedItemQueryPageDescriptor;
import com.ibm.team.scm.common.dto.IDateOrderedQueryPageDescriptor;
import com.ibm.team.scm.common.dto.IQueryPageDescriptor;
import com.ibm.team.scm.common.internal.dto2.DateOrderedItemQueryPageDescriptor;
import com.ibm.team.scm.common.internal.dto2.DateOrderedQueryPageDescriptor;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import com.ibm.team.scm.common.internal.dto2.SelectedVersionablesPageDescriptor;
import com.ibm.team.scm.common.internal.dto2.StringOrderedQueryPageDescriptor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class QueryPageDescriptorSerializer
implements IQueryPageDescriptor.IQueryPageDescriptorSerializer {
    private static final String SEPARATOR = ":";
    private static final String VERSION = "1";
    private static final String DATE_ITEM = "DI";
    private static final String DATE = "D";
    private static final String STRING = "S";
    private static final String SELECTED_VERSIONABLES = "V";

    @Override
    public String serialize(IQueryPageDescriptor pageDescriptor) throws TeamRepositoryException {
        String result;
        block7: {
            if (pageDescriptor == null) {
                return null;
            }
            result = VERSION;
            try {
                if (pageDescriptor instanceof IDateOrderedItemQueryPageDescriptor) {
                    IDateOrderedItemQueryPageDescriptor p = (IDateOrderedItemQueryPageDescriptor)pageDescriptor;
                    result = String.valueOf(result) + ":DI";
                    result = String.valueOf(result) + SEPARATOR + this.encodeUUID(p.getItemId());
                    result = String.valueOf(result) + SEPARATOR + (p.getTimestamp() != null ? String.valueOf(p.getTimestamp().getTime()) : "");
                    break block7;
                }
                if (pageDescriptor instanceof IDateOrderedQueryPageDescriptor) {
                    IDateOrderedQueryPageDescriptor p = (IDateOrderedQueryPageDescriptor)pageDescriptor;
                    result = String.valueOf(result) + ":D";
                    result = String.valueOf(result) + SEPARATOR + (p.getTimestamp() != null ? String.valueOf(p.getTimestamp().getTime()) : "");
                    break block7;
                }
                if (pageDescriptor instanceof StringOrderedQueryPageDescriptor) {
                    StringOrderedQueryPageDescriptor p = (StringOrderedQueryPageDescriptor)pageDescriptor;
                    result = String.valueOf(result) + ":S";
                    result = String.valueOf(result) + SEPARATOR + this.encodeUUID(p.getItemId());
                    result = String.valueOf(result) + SEPARATOR + this.encodeString(p.getString());
                    break block7;
                }
                if (pageDescriptor instanceof SelectedVersionablesPageDescriptor) {
                    SelectedVersionablesPageDescriptor p = (SelectedVersionablesPageDescriptor)pageDescriptor;
                    result = String.valueOf(result) + ":V";
                    result = String.valueOf(result) + SEPARATOR + this.encodeUUID(p.getChangeHistoryId());
                    result = String.valueOf(result) + SEPARATOR + this.encodeList(p.getIndicies());
                    break block7;
                }
                throw new IllegalArgumentException();
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public IQueryPageDescriptor deserialize(String pagingString, int maxPageSize) throws TeamRepositoryException {
        if (pagingString == null || pagingString.isEmpty()) {
            return null;
        }
        String[] parts = pagingString.split(SEPARATOR);
        String type = parts[1];
        try {
            if (DATE_ITEM.equals(type)) {
                if (parts.length != 4) {
                    throw new IllegalArgumentException();
                }
                DateOrderedItemQueryPageDescriptor descriptor = ScmDto2Factory.eINSTANCE.createDateOrderedItemQueryPageDescriptor();
                descriptor.setItemId(this.decodeUUID(parts[2]));
                descriptor.setTimestamp(new Timestamp(Long.valueOf(parts[3])));
                descriptor.setMaxPageSize(maxPageSize);
                return descriptor;
            }
            if (DATE.equals(type)) {
                if (parts.length != 3) {
                    throw new IllegalArgumentException();
                }
                DateOrderedQueryPageDescriptor descriptor = ScmDto2Factory.eINSTANCE.createDateOrderedQueryPageDescriptor();
                descriptor.setTimestamp(new Timestamp(Long.valueOf(parts[2])));
                descriptor.setMaxPageSize(maxPageSize);
                return descriptor;
            }
            if (STRING.equals(type)) {
                if (parts.length < 4) {
                    throw new IllegalArgumentException();
                }
                StringOrderedQueryPageDescriptor descriptor = ScmDto2Factory.eINSTANCE.createStringOrderedQueryPageDescriptor();
                descriptor.setItemId(this.decodeUUID(parts[2]));
                String str = String.join((CharSequence)SEPARATOR, Arrays.asList(parts).subList(3, parts.length));
                descriptor.setString(this.decodeString(str));
                descriptor.setMaxPageSize(maxPageSize);
                return descriptor;
            }
            if (SELECTED_VERSIONABLES.equals(type)) {
                if (parts.length != 4) {
                    throw new IllegalArgumentException();
                }
                SelectedVersionablesPageDescriptor descriptor = ScmDto2Factory.eINSTANCE.createSelectedVersionablesPageDescriptor();
                descriptor.setChangeHistoryId(this.decodeUUID(parts[2]));
                descriptor.setMaxPageSize(maxPageSize);
                descriptor.getIndicies().addAll(this.decodeList(parts[3]));
                return descriptor;
            }
            throw new IllegalArgumentException();
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private String encodeString(String input) throws IOException {
        if (input == null || input.isEmpty()) {
            return "$";
        }
        UnsynchronizedByteArrayOutputStream bytesOut = new UnsynchronizedByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (DataOutputStream out = new DataOutputStream(new DeflaterOutputStream((OutputStream)bytesOut));){
            out.writeUTF(input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String encoded = Base64.getEncoder().encodeToString(bytesOut.toByteArray());
        return encoded.length() > input.length() + 1 ? "$" + input : encoded;
    }

    private String decodeString(String input) throws IOException {
        if (input == null || input.isEmpty()) {
            return null;
        }
        if (input.charAt(0) == '$') {
            return input.substring(1);
        }
        byte[] bytes = Base64.getDecoder().decode(input);
        UnsynchronizedByteArrayInputStream bytesIn = new UnsynchronizedByteArrayInputStream(bytes);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DataInputStream in = new DataInputStream(new InflaterInputStream((InputStream)bytesIn));){
            return in.readUTF();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String encodeList(List<Integer> indices) throws IOException {
        if (indices == null || indices.isEmpty()) {
            return "";
        }
        UnsynchronizedByteArrayOutputStream bytesOut = new UnsynchronizedByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (DataOutputStream out = new DataOutputStream(new DeflaterOutputStream((OutputStream)bytesOut));){
            out.writeInt(indices.size());
            for (Integer i : indices) {
                out.writeInt(i);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Base64.getEncoder().encodeToString(bytesOut.toByteArray());
    }

    private List<Integer> decodeList(String string) throws IOException {
        if (string == null || string.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        byte[] bytes = Base64.getDecoder().decode(string);
        UnsynchronizedByteArrayInputStream bytesIn = new UnsynchronizedByteArrayInputStream(bytes);
        Throwable throwable = null;
        Object var6_7 = null;
        try (DataInputStream in = new DataInputStream(new InflaterInputStream((InputStream)bytesIn));){
            int size = in.readInt();
            int i = 0;
            while (i < size) {
                result.add(in.readInt());
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private String encodeUUID(UUID id) throws IOException {
        if (id == null) {
            return "";
        }
        return id.getUuidValue();
    }

    private UUID decodeUUID(String string) throws IOException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return UUID.valueOf((String)string);
    }
}

