/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.scm.common.IQueryCriteria;
import com.ibm.team.scm.common.dto.IQueryItemSearchCriteria;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.internal.IntegerQueryFilter;
import com.ibm.team.scm.common.internal.ItemQueryFilter;
import com.ibm.team.scm.common.internal.QueryCriteria;
import com.ibm.team.scm.common.internal.QueryFilter;
import com.ibm.team.scm.common.internal.dto.DateRange;
import com.ibm.team.scm.common.internal.dto.NameFilter;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.util.ItemQueryUtil;
import com.ibm.team.scm.common.internal.util.QueryFilterFactory;
import java.util.ArrayList;
import java.util.List;

public class QueryItemSearchCriteria
implements IQueryItemSearchCriteria {
    private int type;
    private NameFilter name;
    private List<IAuditableHandle> filterByOwner = new ArrayList<IAuditableHandle>(2);
    private DateRange dateRange;
    private boolean oldestFirst;
    private boolean alphabetical;

    @Override
    public DateRange getDateRange() {
        return ItemQueryUtil.cloneDateRange(this.dateRange);
    }

    @Override
    public void setDateRange(DateRange range) {
        this.dateRange = ItemQueryUtil.cloneDateRange(range);
    }

    @Override
    public void setOldestFirst(boolean oldestFirst) {
        this.oldestFirst = oldestFirst;
    }

    @Override
    public boolean isOldestFirst() {
        return this.oldestFirst;
    }

    @Override
    public void setAlphabetical(boolean alphabetical) {
        this.alphabetical = alphabetical;
    }

    @Override
    public boolean isAlphabetical() {
        return this.alphabetical;
    }

    @Override
    public NameFilter getOptionalNameFilter() {
        return this.name;
    }

    private void setOptionalNameFilter(NameFilter name) {
        this.name = name;
    }

    @Override
    public ISearchCriteria setPartialName(String namePattern) {
        NameFilter name = ScmDtoFactory.eINSTANCE.createNameFilter();
        name.setExact(false);
        name.setMatchPattern(namePattern);
        this.setOptionalNameFilter(name);
        return this;
    }

    @Override
    public ISearchCriteria setPartialNameIgnoreCase(String namePattern) {
        NameFilter name = ScmDtoFactory.eINSTANCE.createNameFilter();
        name.setExact(false);
        name.setIgnoreCase(true);
        name.setMatchPattern(namePattern);
        this.setOptionalNameFilter(name);
        return this;
    }

    @Override
    public ISearchCriteria setExactName(String namePattern) {
        NameFilter name = ScmDtoFactory.eINSTANCE.createNameFilter();
        name.setExact(true);
        name.setMatchPattern(namePattern);
        this.setOptionalNameFilter(name);
        return this;
    }

    @Override
    public ISearchCriteria setNameIgnoreCase(String namePattern) {
        NameFilter name = ScmDtoFactory.eINSTANCE.createNameFilter();
        name.setExact(true);
        name.setIgnoreCase(true);
        name.setMatchPattern(namePattern);
        this.setOptionalNameFilter(name);
        return this;
    }

    @Override
    public int getQueryType() {
        return this.type;
    }

    @Override
    public void setQueryType(int type) {
        this.type = type;
    }

    @Override
    public List<IAuditableHandle> getFilterByOwnerOptional() {
        return this.filterByOwner;
    }

    @Override
    public IQueryCriteria asQueryCriteria() {
        QueryCriteria queryCriteria = ItemQueryUtil.asQueryCriteria(this);
        ItemQueryUtil.addFilterToQueryCriteria(queryCriteria, QueryFilterFactory.createIntegerQueryFilter("QueryType", this.getQueryType()));
        ItemQueryUtil.addFilterToQueryCriteria(queryCriteria, QueryFilterFactory.createItemQueryFilter("Owners", this.getFilterByOwnerOptional()));
        return queryCriteria;
    }

    @Override
    public void populateFrom(IQueryCriteria queryCriteria) {
        ItemQueryUtil.populateBasic(queryCriteria, this);
        QueryFilter type = ItemQueryUtil.getQueryFilter(queryCriteria, "QueryType");
        if (type instanceof IntegerQueryFilter) {
            this.setQueryType(((IntegerQueryFilter)type).getValue());
        } else if (type != null) {
            throw new IllegalArgumentException();
        }
        QueryFilter owners = ItemQueryUtil.getQueryFilter(queryCriteria, "Owners");
        if (owners instanceof ItemQueryFilter) {
            ItemQueryFilter iqf = (ItemQueryFilter)owners;
            this.getFilterByOwnerOptional().addAll(iqf.getItems());
        }
    }
}

