/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.AttributeQueryFilter;
import com.ibm.team.scm.common.internal.BooleanQueryFilter;
import com.ibm.team.scm.common.internal.DateRangeQueryFilter;
import com.ibm.team.scm.common.internal.FlowQueryFilter;
import com.ibm.team.scm.common.internal.IntegerQueryFilter;
import com.ibm.team.scm.common.internal.ItemQueryFilter;
import com.ibm.team.scm.common.internal.PatternQueryFilter;
import com.ibm.team.scm.common.internal.QueryFilter;
import com.ibm.team.scm.common.internal.QueryFilterSet;
import com.ibm.team.scm.common.internal.ReadScopeQueryFilter;
import com.ibm.team.scm.common.internal.ScmFactory;
import com.ibm.team.scm.common.internal.StringQueryFilter;
import com.ibm.team.scm.common.internal.UUIDQueryFilter;
import com.ibm.team.scm.common.internal.dto.DateRange;
import com.ibm.team.scm.common.internal.dto.FlowFilter;
import com.ibm.team.scm.common.internal.dto.NameFilter;
import com.ibm.team.scm.common.internal.dto2.CustomAttributeSearchFilter;
import com.ibm.team.scm.common.internal.util.ItemQueryUtil;
import com.ibm.team.scm.common.internal.util.ReadScopeUtils;
import java.util.Collections;
import java.util.List;

public class QueryFilterFactory {
    public static QueryFilterSet createFilterQuerySet(String identifier) {
        QueryFilterSet qf = ScmFactory.eINSTANCE.createQueryFilterSet();
        qf.setIdentifier(identifier);
        return qf;
    }

    public static BooleanQueryFilter createBooleanQueryFilter(String identifier, boolean value) {
        BooleanQueryFilter qf = ScmFactory.eINSTANCE.createBooleanQueryFilter();
        qf.setIdentifier(identifier);
        qf.setValue(value);
        return qf;
    }

    public static IntegerQueryFilter createIntegerQueryFilter(String identifier, int value) {
        IntegerQueryFilter qf = ScmFactory.eINSTANCE.createIntegerQueryFilter();
        qf.setIdentifier(identifier);
        qf.setValue(value);
        return qf;
    }

    public static QueryFilter createStringQueryFilter(String identifier, String value) {
        StringQueryFilter qf = ScmFactory.eINSTANCE.createStringQueryFilter();
        qf.setIdentifier(identifier);
        qf.setValue(value);
        return qf;
    }

    public static QueryFilter createUuidQueryFilter(String identifier, UUID value) {
        UUIDQueryFilter qf = ScmFactory.eINSTANCE.createUUIDQueryFilter();
        qf.setIdentifier(identifier);
        qf.setValue(value);
        return qf;
    }

    public static PatternQueryFilter createPatternQueryFilter(String identifier, NameFilter filter) {
        if (filter == null) {
            return null;
        }
        return QueryFilterFactory.createPatternQueryFilter(identifier, filter.getMatchPattern(), ItemQueryUtil.getPatternMatchKind(filter));
    }

    public static PatternQueryFilter createPatternQueryFilter(String identifier, String pattern, int kind) {
        PatternQueryFilter qf = ScmFactory.eINSTANCE.createPatternQueryFilter();
        qf.setIdentifier(identifier);
        qf.setMatchPattern(pattern);
        qf.setMatchKind(kind);
        return qf;
    }

    public static DateRangeQueryFilter createDateRangeQueryFilter(String identifier, DateRange range) {
        if (range == null) {
            return null;
        }
        DateRangeQueryFilter qf = ScmFactory.eINSTANCE.createDateRangeQueryFilter();
        qf.setIdentifier(identifier);
        qf.setBeforeDate(range.getEnd());
        qf.setBeforeDateInclusive(range.isEndInclusive());
        qf.setAfterDate(range.getStart());
        qf.setAfterDateInclusive(range.isStartInclusive());
        return qf;
    }

    public static ItemQueryFilter createItemQueryFilter(String identifier, IItemHandle handle) {
        if (handle == null) {
            return null;
        }
        return QueryFilterFactory.createItemQueryFilter(identifier, Collections.singletonList(handle));
    }

    public static ItemQueryFilter createItemQueryFilter(String identifier, List<? extends IItemHandle> handles) {
        if (handles == null || handles.isEmpty()) {
            return null;
        }
        ItemQueryFilter qf = ScmFactory.eINSTANCE.createItemQueryFilter();
        qf.setIdentifier(identifier);
        qf.getItems().addAll(handles);
        return qf;
    }

    public static QueryFilterSet createReadScopeQueryFilter(String identifier, List<IReadScope> readScopes) {
        if (readScopes == null || readScopes.isEmpty()) {
            return null;
        }
        try {
            QueryFilterSet scopes = ScmFactory.eINSTANCE.createQueryFilterSet();
            scopes.setIdentifier(identifier);
            for (IReadScope object : readScopes) {
                if (!(object instanceof IReadScope)) continue;
                IReadScope rs = object;
                ReadScopeQueryFilter qf = ScmFactory.eINSTANCE.createReadScopeQueryFilter();
                qf.setIdentifier("ReadScope");
                qf.setReadPermissionMode(ReadScopeUtils.getReadPermissionModeFor(rs));
                qf.setOwner(ReadScopeUtils.getOwner(rs));
                qf.setContext(ReadScopeUtils.getCustomContext(rs));
                scopes.getChildren().add(qf);
            }
            return scopes;
        }
        catch (TeamRepositoryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static FlowQueryFilter createFlowQueryFilter(String identifier, FlowFilter flowFilter) {
        if (flowFilter == null) {
            return null;
        }
        FlowQueryFilter qf = ScmFactory.eINSTANCE.createFlowQueryFilter();
        qf.setIdentifier(identifier);
        qf.setFlowTarget(flowFilter.getTarget());
        qf.setFlowKind(flowFilter.getFlowKind());
        return qf;
    }

    public static QueryFilter createCustomAttributeQueryFilter(String identifier, List<CustomAttributeSearchFilter> filters) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        QueryFilterSet customAttributeFilters = ScmFactory.eINSTANCE.createQueryFilterSet();
        customAttributeFilters.setIdentifier(identifier);
        for (CustomAttributeSearchFilter filter : filters) {
            AttributeQueryFilter attributeQueryFilter = ScmFactory.eINSTANCE.createAttributeQueryFilter();
            attributeQueryFilter.setIdentifier("CustomAttribute");
            attributeQueryFilter.setName(filter.getAttributeName());
            if (filter.isSetStringValue() && filter.getStringValue() != null) {
                attributeQueryFilter.setStringValue(filter.getStringValue());
            }
            if (filter.isSetValueType() && filter.getValueType() != null) {
                attributeQueryFilter.setValueType(filter.getValueType());
            }
            customAttributeFilters.getChildren().add(attributeQueryFilter);
        }
        return customAttributeFilters;
    }
}

