/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.StringUtils;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.ILockPageFetchDescriptor;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchResult2;
import com.ibm.team.scm.common.internal.dto.ComponentLocks;
import com.ibm.team.scm.common.internal.dto.ContributorLocks;
import com.ibm.team.scm.common.internal.dto.LockSearchResult2;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.ScmDtoPackage;
import com.ibm.team.scm.common.internal.dto.WorkspaceLocks;
import com.ibm.team.scm.common.internal.dto2.ComponentEntryLockState;
import com.ibm.team.scm.common.internal.dto2.LockPageFetchDescriptor;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class LockSearchUtil {
    private static final String LOCK_STATE = "lockState";
    private static final String COMPONENT_ID = "componentId";
    private static final String WORKSPACE_ID = "workspaceId";
    private static final String FETCH_DIRECTION = "fetchDirection";
    private static final String COMPONENT_OFFSET = "componentOffset";
    private static final String WORKSPACE_OFFSET = "workspaceOffset";
    private static final String VERSIONABLE_OFFSET = "versionableOffset";
    private static final String COMPONENT_ENTRY_LOCK_STATE = "componentEntryLockState";

    public static Iterator<ILockSearchCriteria> partitionCriteria(ILockSearchCriteria searchCriteria, int size) {
        if (size <= 0) {
            size = 512;
        }
        final int pageSize = Math.min(size, 512);
        return new Iterator<ILockSearchCriteria>(searchCriteria){
            private EObject original;
            private EObject previous;
            private int[] indexes;
            private EStructuralFeature[] features;
            {
                this.previous = this.original = (EObject)iLockSearchCriteria;
                this.indexes = new int[]{-1, -1, -1};
                this.features = new EStructuralFeature[]{ScmDtoPackage.eINSTANCE.getLockSearchCriteria_Streams(), ScmDtoPackage.eINSTANCE.getLockSearchCriteria_Components(), ScmDtoPackage.eINSTANCE.getLockSearchCriteria_Versionables()};
            }

            @Override
            public boolean hasNext() {
                int i = 0;
                while (i < this.indexes.length) {
                    List list = (List)this.original.eGet(this.features[i]);
                    if (this.indexes[i] < list.size()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            @Override
            public ILockSearchCriteria next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                EObject clone = EcoreUtil.copy((EObject)this.previous);
                this.advance(clone, this.indexes.length - 1);
                this.previous = clone;
                return (ILockSearchCriteria)clone;
            }

            private void advance(EObject destination, int level) {
                if (level < 0) {
                    return;
                }
                if (this.indexes[level] == -1 || this.indexes[level] == ((List)this.original.eGet(this.features[level])).size()) {
                    this.advance(destination, level - 1);
                    this.indexes[level] = 0;
                }
                List sourceList = (List)this.original.eGet(this.features[level]);
                List destinationList = (List)destination.eGet(this.features[level]);
                int toIndex = Math.min(this.indexes[level] + pageSize, sourceList.size());
                destinationList.clear();
                destinationList.addAll(sourceList.subList(this.indexes[level], toIndex));
                this.indexes[level] = toIndex;
            }
        };
    }

    public static ILockSearchResult2 apppendLockPage(ILockSearchResult2 originalPage, ILockSearchResult2 additionalPage) {
        return LockSearchUtil.mergeLockResults(Arrays.asList(originalPage, additionalPage));
    }

    public static ILockSearchResult2 mergeLockResults(List<ILockSearchResult2> results) {
        LockSearchResult2 page = ScmDtoFactory.eINSTANCE.createLockSearchResult2();
        for (ILockSearchResult2 result : results) {
            if (result == null) continue;
            page.setLockCount(page.getVersionableLockCount() + result.getVersionableLockCount());
            page.setStale(page.isResultStale() || result.isResultStale());
            page.setNext(result.getNextFetchDescriptor());
        }
        WorkspaceLocks[] locks = (WorkspaceLocks[])results.stream().filter(Objects::nonNull).flatMap(r -> r.getStreamReports().stream()).toArray(WorkspaceLocks[]::new);
        page.getStreamReports().clear();
        page.getStreamReports().addAll(LockSearchUtil.merge(locks));
        return page;
    }

    public static String toJSONizedString(LockPageFetchDescriptor pageDescriptor) {
        if (pageDescriptor == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)FETCH_DIRECTION, (Object)pageDescriptor.getFetchDirection());
        result.put((Object)WORKSPACE_OFFSET, (Object)pageDescriptor.getWorkspaceOffset());
        result.put((Object)COMPONENT_OFFSET, (Object)pageDescriptor.getComponentOffset());
        result.put((Object)VERSIONABLE_OFFSET, (Object)pageDescriptor.getVersionableOffset());
        if (pageDescriptor.getComponentEntryLockState() != null) {
            ComponentEntryLockState state = pageDescriptor.getComponentEntryLockState();
            JSONObject lockState = new JSONObject();
            lockState.put((Object)WORKSPACE_ID, (Object)state.getWorkspaceId().getUuidValue());
            lockState.put((Object)COMPONENT_ID, (Object)state.getComponentId().getUuidValue());
            lockState.put((Object)LOCK_STATE, (Object)state.getLockState());
            result.put((Object)COMPONENT_ENTRY_LOCK_STATE, (Object)lockState);
        }
        return result.toString();
    }

    public static ILockPageFetchDescriptor fromJSONizedString(String pageDescriptorString, int pageSize) throws TeamRepositoryException {
        LockPageFetchDescriptor pageFetchDescriptor = ScmDto2Factory.eINSTANCE.createLockPageFetchDescriptor();
        pageFetchDescriptor.setPageSize(pageSize);
        if (pageDescriptorString != null) {
            if ("first".equals(pageDescriptorString)) {
                return pageFetchDescriptor;
            }
            StringReader reader = new StringReader(pageDescriptorString);
            JSONObject pageDescriptorJSON = null;
            try {
                pageDescriptorJSON = JSONObject.parse((Reader)reader);
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException(e));
            }
            if (pageDescriptorJSON != null) {
                String valueStr;
                Object value = pageDescriptorJSON.get((Object)FETCH_DIRECTION);
                if (value != null && !StringUtils.isEmpty((String)(valueStr = value.toString()))) {
                    pageFetchDescriptor.setFetchDirection(valueStr);
                }
                if ((value = pageDescriptorJSON.get((Object)COMPONENT_OFFSET)) != null && !StringUtils.isEmpty((String)(valueStr = value.toString()))) {
                    pageFetchDescriptor.setComponentOffset(valueStr);
                }
                if ((value = pageDescriptorJSON.get((Object)WORKSPACE_OFFSET)) != null && !StringUtils.isEmpty((String)(valueStr = value.toString()))) {
                    pageFetchDescriptor.setWorkspaceOffset(valueStr);
                }
                if ((value = pageDescriptorJSON.get((Object)VERSIONABLE_OFFSET)) != null && !StringUtils.isEmpty((String)(valueStr = value.toString()))) {
                    pageFetchDescriptor.setVersionableOffset(valueStr);
                }
                ComponentEntryLockState compEntryLockState = ScmDto2Factory.eINSTANCE.createComponentEntryLockState();
                JSONObject componentEntryLockStateJSON = (JSONObject)pageDescriptorJSON.get((Object)COMPONENT_ENTRY_LOCK_STATE);
                if (componentEntryLockStateJSON != null) {
                    String valueStr2;
                    value = componentEntryLockStateJSON.get((Object)COMPONENT_ID);
                    if (value != null && !StringUtils.isEmpty((String)(valueStr2 = value.toString()))) {
                        compEntryLockState.setComponentId(UUID.valueOf((String)valueStr2));
                    }
                    if ((value = componentEntryLockStateJSON.get((Object)LOCK_STATE)) != null && !StringUtils.isEmpty((String)(valueStr2 = value.toString()))) {
                        compEntryLockState.setLockState(Long.parseLong(valueStr2));
                    }
                    if ((value = componentEntryLockStateJSON.get((Object)WORKSPACE_ID)) != null && !StringUtils.isEmpty((String)(valueStr2 = value.toString()))) {
                        compEntryLockState.setWorkspaceId(UUID.valueOf((String)valueStr2));
                    }
                }
                pageFetchDescriptor.setComponentEntryLockState(compEntryLockState);
            }
        }
        return pageFetchDescriptor;
    }

    private static List<WorkspaceLocks> merge(WorkspaceLocks ... locks) {
        HashMap<MergeKey, Long> lockTimes = new HashMap<MergeKey, Long>();
        TreeMap<MergeKey, List> map = new TreeMap<MergeKey, List>();
        WorkspaceLocks[] workspaceLocksArray = locks;
        int n = locks.length;
        int n2 = 0;
        while (n2 < n) {
            WorkspaceLocks workspaceLocks = workspaceLocksArray[n2];
            IWorkspaceHandle workspace = workspaceLocks.getWorkspace();
            for (ComponentLocks componentLocks : workspaceLocks.getComponentLocks()) {
                IComponentHandle component = componentLocks.getComponent();
                MergeKey componentKey = new MergeKey(workspace, component, null);
                lockTimes.putIfAbsent(componentKey, componentLocks.getLockTime());
                for (ContributorLocks contributorLocks : componentLocks.getContributorLocks()) {
                    IContributorHandle contributor = contributorLocks.getContributor();
                    MergeKey key = new MergeKey(workspace, component, contributor);
                    List existing = map.putIfAbsent(key, contributorLocks.getVersionables());
                    if (existing == null) continue;
                    existing.addAll(contributorLocks.getVersionables());
                }
            }
            ++n2;
        }
        ArrayList<WorkspaceLocks> result = new ArrayList<WorkspaceLocks>();
        WorkspaceLocks w = null;
        ComponentLocks c = null;
        ContributorLocks u = null;
        for (MergeKey mergeKey : map.keySet()) {
            if (w == null || !mergeKey.workspace.sameItemId((IItemHandle)w.getWorkspace())) {
                w = ScmDtoFactory.eINSTANCE.createWorkspaceLocks();
                w.setWorkspace(mergeKey.workspace);
                result.add(w);
                c = null;
                u = null;
            }
            if (c == null || !mergeKey.component.sameItemId((IItemHandle)c.getComponent())) {
                c = ScmDtoFactory.eINSTANCE.createComponentLocks();
                c.setComponent(mergeKey.component);
                w.getComponentLocks().add(c);
                c.setLockTime((Long)lockTimes.get(new MergeKey(w.getWorkspace(), c.getComponent(), null)));
                u = null;
            }
            if (u == null || !mergeKey.contributor.sameItemId((IItemHandle)u.getContributor())) {
                u = ScmDtoFactory.eINSTANCE.createContributorLocks();
                u.setContributor(mergeKey.contributor);
                c.getContributorLocks().add(u);
            }
            u.getVersionables().addAll((Collection)map.get(mergeKey));
        }
        return result;
    }

    private static class MergeKey
    implements Comparable {
        public IWorkspaceHandle workspace;
        public IComponentHandle component;
        public IContributorHandle contributor;
        private String key;

        public MergeKey(IWorkspaceHandle workspace, IComponentHandle component, IContributorHandle contributor) {
            this.workspace = workspace;
            this.component = component;
            this.contributor = contributor;
            this.key = workspace.getItemId().getUuidValue();
            this.key = String.valueOf(this.key) + component.getItemId().getUuidValue();
            if (contributor != null) {
                this.key = String.valueOf(this.key) + contributor.getItemId().getUuidValue();
            }
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public int compareTo(Object o) {
            if (o != null && o instanceof MergeKey) {
                return this.key.compareTo(o.toString());
            }
            return 1;
        }

        public String toString() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof MergeKey) {
                return this.key.equals(o.toString());
            }
            return false;
        }
    }
}

