/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.scm.common.IQueryCriteria;
import com.ibm.team.scm.common.IQueryFilter;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.ICustomAttributeSearchFilter;
import com.ibm.team.scm.common.dto.IItemSearchCriteria;
import com.ibm.team.scm.common.dto.IOrderedSearchCriteria;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.AttributeQueryFilter;
import com.ibm.team.scm.common.internal.BooleanQueryFilter;
import com.ibm.team.scm.common.internal.DateRangeQueryFilter;
import com.ibm.team.scm.common.internal.IDateRangeSearchCriteria;
import com.ibm.team.scm.common.internal.INamedSearchCritieria;
import com.ibm.team.scm.common.internal.PatternQueryFilter;
import com.ibm.team.scm.common.internal.QueryCriteria;
import com.ibm.team.scm.common.internal.QueryFilter;
import com.ibm.team.scm.common.internal.QueryFilterSet;
import com.ibm.team.scm.common.internal.ReadScopeQueryFilter;
import com.ibm.team.scm.common.internal.ScmFactory;
import com.ibm.team.scm.common.internal.dto.DateRange;
import com.ibm.team.scm.common.internal.dto.NameFilter;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.util.QueryFilterFactory;
import com.ibm.team.scm.common.internal.util.ReadScopeUtils;

public class ItemQueryUtil {
    public static final String FILTERS = "Filters";
    public static final String CREATORS = "Creators";
    public static final String COMPONENTS = "Components";
    public static final String WORKSPACES = "Workspaces";
    public static final String PROCESS_AREAS = "ProcessAreas";
    public static final String BASELINES = "Baselines";
    public static final String READ_SCOPES = "ReadScopes";
    public static final String READ_SCOPE = "ReadScope";
    public static final String OWNER_NAME_FILTER = "OwnerNameFilter";
    public static final String OWNING_WORKSPACE_TYPE_FILTER = "OwningWorkspaceTypeFilter";
    public static final String FLOW_FILTER = "FlowFilter";
    public static final String NAME_FILTER_UNION = "NameFilterUnion";
    public static final String WORKSPACE_KIND = "WorkspaceKind";
    public static final String SUSPENDED_BY = "SuspendedBy";
    public static final String CHANGE_TYPE = "ChangeType";
    public static final String VERSIONABLES = "Versionables";
    public static final String VERSIONABLE_NAME = "VersionableName";
    public static final String SEARCH_INTERMEDIATES = "SearchIntermediates";
    public static final String SOURCE = "Source";
    public static final String CUSTOM_ATTRIBUTES_FILTER = "CustomAttributes";
    public static final String CUSTOM_ATTRIBUTE_FILTER = "CustomAttribute";
    public static final String COMPONENT_FILTER = "COMPONENT_FILTER";

    public static boolean isExactMatchPattern(int kind) {
        return (kind & 1) > 0;
    }

    public static boolean isPartialIgnoreCasePattern(int kind) {
        int prefixIgnore = 6;
        return (kind & prefixIgnore) == prefixIgnore;
    }

    public static boolean isIgnoreCasePattern(int kind) {
        return (kind & 4) != 0;
    }

    public static boolean isPartialPattern(int kind) {
        int prefixIgnore = 6;
        return (kind & prefixIgnore) == 2;
    }

    public static void setNamedCriteriaPattern(INamedSearchCritieria criteria, String pattern, int kind) {
        if (ItemQueryUtil.isExactMatchPattern(kind)) {
            criteria.setExactName(pattern);
        } else if (ItemQueryUtil.isPartialIgnoreCasePattern(kind)) {
            criteria.setPartialNameIgnoreCase(pattern);
        } else if (ItemQueryUtil.isPartialPattern(kind)) {
            criteria.setPartialName(pattern);
        }
    }

    public static int getPatternMatchKind(NameFilter nameFilter) {
        int matchKind = 0;
        matchKind = nameFilter.isExact() ? (matchKind |= 1) : (matchKind |= 2);
        if (nameFilter.isIgnoreCase()) {
            matchKind |= 4;
        }
        return matchKind;
    }

    public static QueryCriteria asQueryCriteria(IItemSearchCriteria searchCriteria) {
        QueryCriteria queryCriteria = ScmFactory.eINSTANCE.createQueryCriteria();
        if (searchCriteria instanceof IOrderedSearchCriteria) {
            IOrderedSearchCriteria orderedCriteria = (IOrderedSearchCriteria)searchCriteria;
            ItemQueryUtil.addFilterToQueryCriteria(queryCriteria, QueryFilterFactory.createBooleanQueryFilter("OldestFirst", orderedCriteria.isOldestFirst()));
        }
        if (searchCriteria instanceof INamedSearchCritieria) {
            INamedSearchCritieria namedCriteria = (INamedSearchCritieria)((Object)searchCriteria);
            ItemQueryUtil.addFilterToQueryCriteria(queryCriteria, QueryFilterFactory.createPatternQueryFilter("Name", namedCriteria.getOptionalNameFilter()));
            if (searchCriteria instanceof IOrderedSearchCriteria) {
                ItemQueryUtil.addFilterToQueryCriteria(queryCriteria, QueryFilterFactory.createBooleanQueryFilter("Alphabetical", namedCriteria.isAlphabetical()));
            }
        }
        if (searchCriteria instanceof IDateRangeSearchCriteria) {
            IDateRangeSearchCriteria dateCriteria = (IDateRangeSearchCriteria)searchCriteria;
            ItemQueryUtil.addFilterToQueryCriteria(queryCriteria, QueryFilterFactory.createDateRangeQueryFilter("DateRange", dateCriteria.getDateRange()));
        }
        return queryCriteria;
    }

    public static void addFilterToQueryCriteria(QueryCriteria queryCriteria, QueryFilter queryFilter) {
        if (queryFilter != null) {
            IQueryFilter query = queryCriteria.getQuery();
            if (query instanceof QueryFilterSet) {
                QueryFilterSet qfs = (QueryFilterSet)query;
                qfs.getChildren().add(queryFilter);
            } else {
                QueryFilterSet children = QueryFilterFactory.createFilterQuerySet(FILTERS);
                queryCriteria.setQuery(children);
                children.getChildren().add(queryFilter);
                if (query != null) {
                    children.getChildren().add(query);
                }
            }
        }
    }

    public static QueryFilter getQueryFilter(IQueryCriteria queryCriteria, String identifier) {
        QueryFilter qf;
        IQueryFilter query = ((QueryCriteria)queryCriteria).getQuery();
        if (query instanceof QueryFilterSet) {
            QueryFilterSet qfs = (QueryFilterSet)query;
            for (Object o : qfs.getChildren()) {
                QueryFilter qf2;
                if (!(o instanceof QueryFilter) || !(qf2 = (QueryFilter)o).getIdentifier().equals(identifier)) continue;
                return qf2;
            }
        }
        if (query instanceof QueryFilter && (qf = (QueryFilter)query).getIdentifier().equals(identifier)) {
            return qf;
        }
        return null;
    }

    public static IItemSearchCriteria asSearchCriteria(QueryCriteria queryCriteria, int type) {
        IDateRangeSearchCriteria searchCriteria;
        switch (type) {
            case 1: {
                searchCriteria = IBaselineSearchCriteria.FACTORY.newInstance();
                break;
            }
            case 2: {
                searchCriteria = IBaselineSetSearchCriteria.FACTORY.newInstance();
                break;
            }
            case 3: {
                searchCriteria = IChangeSetSearchCriteria.FACTORY.newInstance();
                break;
            }
            case 4: {
                searchCriteria = IComponentSearchCriteria.FACTORY.newInstance();
                break;
            }
            case 5: {
                searchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance();
                break;
            }
            default: {
                return null;
            }
        }
        searchCriteria.populateFrom(queryCriteria);
        return searchCriteria;
    }

    public static void populateBasic(IQueryCriteria queryCriteria, ISearchCriteria searchCriteria) {
        BooleanQueryFilter booleanQueryFilter;
        QueryFilter queryFilter;
        if (searchCriteria instanceof IOrderedSearchCriteria) {
            IOrderedSearchCriteria orderedCriteria = (IOrderedSearchCriteria)searchCriteria;
            queryFilter = ItemQueryUtil.getQueryFilter(queryCriteria, "OldestFirst");
            if (queryFilter instanceof BooleanQueryFilter) {
                booleanQueryFilter = (BooleanQueryFilter)queryFilter;
                orderedCriteria.setOldestFirst(booleanQueryFilter.isValue());
            } else if (queryFilter != null) {
                throw new IllegalArgumentException();
            }
        }
        if (searchCriteria instanceof INamedSearchCritieria) {
            INamedSearchCritieria namedCriteria = (INamedSearchCritieria)searchCriteria;
            queryFilter = ItemQueryUtil.getQueryFilter(queryCriteria, "Name");
            if (queryFilter instanceof PatternQueryFilter) {
                PatternQueryFilter pattern = (PatternQueryFilter)queryFilter;
                ItemQueryUtil.setNamedCriteriaPattern(namedCriteria, pattern.getMatchPattern(), pattern.getMatchKind());
            } else if (queryFilter != null) {
                throw new IllegalArgumentException();
            }
            if (searchCriteria instanceof IOrderedSearchCriteria) {
                queryFilter = ItemQueryUtil.getQueryFilter(queryCriteria, "Alphabetical");
                if (queryFilter instanceof BooleanQueryFilter) {
                    booleanQueryFilter = (BooleanQueryFilter)queryFilter;
                    namedCriteria.setAlphabetical(booleanQueryFilter.isValue());
                } else if (queryFilter != null) {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (searchCriteria instanceof IDateRangeSearchCriteria) {
            IDateRangeSearchCriteria dateCriteria = (IDateRangeSearchCriteria)searchCriteria;
            queryFilter = ItemQueryUtil.getQueryFilter(queryCriteria, "DateRange");
            if (queryFilter instanceof DateRangeQueryFilter) {
                DateRangeQueryFilter range = (DateRangeQueryFilter)queryFilter;
                DateRange r = ScmDtoFactory.eINSTANCE.createDateRange();
                r.setStart(range.getAfterDate());
                r.setStartInclusive(range.isAfterDateInclusive());
                r.setEnd(range.getBeforeDate());
                r.setEndInclusive(range.isBeforeDateInclusive());
                dateCriteria.setDateRange(r);
            } else if (queryFilter != null) {
                throw new IllegalArgumentException();
            }
        }
    }

    public static IReadScope asReadScope(ReadScopeQueryFilter child) {
        if (child == null) {
            return null;
        }
        return ReadScopeUtils.computeReadScope(child.getOwner(), child.getReadPermissionMode(), child.getContext());
    }

    public static ICustomAttributeSearchFilter asCustomAttributeSearchFilter(AttributeQueryFilter filter) {
        if (filter.getValueType() != null && filter.getValueType().equals("Boolean")) {
            if (filter.getStringValue() == null || filter.getStringValue().length() == 0) {
                return ICustomAttributeSearchFilter.FACTORY.hasBooleanAttribute(filter.getName());
            }
            return ICustomAttributeSearchFilter.FACTORY.attributeMatches(filter.getName(), Boolean.parseBoolean(filter.getStringValue()));
        }
        if (filter.getStringValue() == null || filter.getStringValue().length() == 0) {
            return ICustomAttributeSearchFilter.FACTORY.hasAttribute(filter.getName());
        }
        return ICustomAttributeSearchFilter.FACTORY.attributeMatches(filter.getName(), filter.getStringValue());
    }

    public static boolean containsFilter(IQueryFilter query, String id) {
        if (query.getIdentifier().equals(id)) {
            return true;
        }
        if (query instanceof QueryFilterSet) {
            QueryFilterSet qfs = (QueryFilterSet)query;
            for (Object o : qfs.getChildren()) {
                IQueryFilter child;
                if (!(o instanceof IQueryFilter) || !ItemQueryUtil.containsFilter(child = (IQueryFilter)o, id)) continue;
                return true;
            }
        }
        return false;
    }

    public static DateRange cloneDateRange(DateRange dateRange) {
        if (dateRange == null) {
            return null;
        }
        DateRange newRange = ScmDtoFactory.eINSTANCE.createDateRange();
        newRange.setStart(dateRange.getStart());
        newRange.setStartInclusive(dateRange.isStartInclusive());
        newRange.setEnd(dateRange.getEnd());
        newRange.setEndInclusive(dateRange.isEndInclusive());
        return newRange;
    }
}

