/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IHistoryReferenceSerializer;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;

public class HistoryReferenceSerializer
implements IHistoryReferenceSerializer {
    private static final String SEPARATOR = "/";
    private static final String WORKSPACE_COMPONENT_STATE = "WorkspaceComponentState";

    @Override
    public IHistoryReference deserializeReference(String data) {
        String[] segments = data.split(SEPARATOR);
        if (segments[0].equals(WORKSPACE_COMPONENT_STATE)) {
            if (segments.length != 4) {
                throw new IllegalArgumentException();
            }
            try {
                IWorkspaceHandle workspace = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)segments[1]), null);
                IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)segments[2]), null);
                long state = Long.parseLong(segments[3]);
                WorkspaceComponentState result = ScmDto2Factory.eINSTANCE.createWorkspaceComponentState();
                result.setWorkspace(workspace);
                result.setComponent(component);
                result.setState(state);
                return result;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (segments.length != 3) {
            throw new IllegalArgumentException();
        }
        if (segments[1].equals(IWorkspace.ITEM_TYPE.getName())) {
            return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)segments[2]), null);
        }
        if (segments[1].equals(IBaselineSet.ITEM_TYPE.getName())) {
            return (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)segments[2]), null);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String serializeReference(IHistoryReference reference) {
        if (reference instanceof IItemHandle) {
            IItemHandle handle = (IItemHandle)reference;
            return String.valueOf(handle.getItemType().getNamespaceURI()) + SEPARATOR + handle.getItemType().getName() + SEPARATOR + handle.getItemId().getUuidValue();
        }
        if (reference instanceof WorkspaceComponentState) {
            WorkspaceComponentState wcs = (WorkspaceComponentState)reference;
            return "WorkspaceComponentState/" + wcs.getWorkspace().getItemId().getUuidValue() + SEPARATOR + wcs.getComponent().getItemId().getUuidValue() + SEPARATOR + wcs.getState();
        }
        return null;
    }
}

