/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.internal.repository.rcp.streams.LengthLimitedInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Map;

public class DebugMarshaller {
    private Marshaller marshaller;
    private Map<String, String> config;

    public DebugMarshaller(Map<String, String> config) {
        this.config = config;
        try {
            Method m = MarshalFactory.class.getMethod("getMarshaller", MarshallerType.class);
            this.marshaller = (Marshaller)m.invoke((Object)MarshalFactory.eINSTANCE, MarshallerType.EOBJECT_LITERAL);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate debug marshaller.");
        }
    }

    protected DataInputStream asDataInputStream(InputStream inputStream) {
        if (inputStream instanceof DataInputStream) {
            return (DataInputStream)inputStream;
        }
        return new DataInputStream(inputStream);
    }

    protected DataOutputStream asDataOutputStream(OutputStream outputStream) {
        if (outputStream instanceof DataOutputStream) {
            return (DataOutputStream)outputStream;
        }
        return new DataOutputStream(outputStream);
    }

    public Object demarshal(InputStream inputStream) throws TeamRepositoryException {
        DataInputStream dis = this.asDataInputStream(inputStream);
        try {
            long size = dis.readLong();
            return this.marshaller.demarshalInputStreamToObject((InputStream)new LengthLimitedInputStream((InputStream)dis, size));
        }
        catch (MarshallingException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws TeamRepositoryException {
        try {
            UnsynchronizedByteArrayOutputStream tempOut = new UnsynchronizedByteArrayOutputStream();
            this.marshaller.marshalObjectToOutputStream(object, (OutputStream)tempOut, HttpUtil.CharsetEncoding.UTF8.toCharset(), this.config);
            try {
                tempOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] bytes = tempOut.toByteArray();
            DataOutputStream dos = this.asDataOutputStream(outputStream);
            dos.writeLong(bytes.length);
            dos.write(bytes);
        }
        catch (MarshallingException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }
}

