/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Contributor;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.Messages;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class ComponentLockData {
    public static final String COMPONENT_LOCKED_BY_PROPERTY_KEY_PREFIX = "scm.component.locked.by.";

    public static ILockOwner getLockedBy(IWorkspace workspace, IComponentHandle component) throws TeamRepositoryException {
        String propertyName = COMPONENT_LOCKED_BY_PROPERTY_KEY_PREFIX + component.getItemId().getUuidValue();
        String lockedByString = workspace.getProperties().get(propertyName);
        if (lockedByString != null) {
            try {
                return ComponentLockData.parseLockOwner(lockedByString, component);
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        return null;
    }

    private static ILockOwner parseLockOwner(String lockedByString, IComponentHandle component) throws IOException {
        String contributorId;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(lockedByString.getBytes())));
        while ((contributorId = bufferedReader.readLine()) != null) {
            if (contributorId.isEmpty()) continue;
            String jazzId = bufferedReader.readLine();
            if (jazzId == null) {
                throw new IOException(NLS.bind((String)Messages.getString("ComponentLockData.1"), (Object)component.getItemId().getUuidValue()));
            }
            String name = bufferedReader.readLine();
            if (name == null) {
                throw new IOException(NLS.bind((String)Messages.getString("ComponentLockData.1"), (Object)component.getItemId().getUuidValue()));
            }
            return new OwnerEntry(contributorId, jazzId, name);
        }
        return null;
    }

    private ComponentLockData() {
    }

    public static void lockComponents(Workspace workspace, Set<ItemId<IComponent>> components, Contributor contributor) {
        for (ItemId<IComponent> component : components) {
            ComponentLockData.lockComponent(workspace, component, (IContributor)contributor);
        }
    }

    public static Set<ItemId<IComponent>> unlockComponents(Workspace workspace, Set<ItemId<IComponent>> components) {
        HashSet<ItemId<IComponent>> unlocked = new HashSet<ItemId<IComponent>>();
        for (ItemId<IComponent> component : components) {
            if (!ComponentLockData.unlockComponent(workspace, component)) continue;
            unlocked.add(component);
        }
        return unlocked;
    }

    private static boolean unlockComponent(Workspace workspace, ItemId<IComponent> component) {
        String propertyName = COMPONENT_LOCKED_BY_PROPERTY_KEY_PREFIX + component.getItemUUID().getUuidValue();
        return workspace.getProperties().remove(propertyName) != null;
    }

    public static void lockComponent(IWorkspace workspace, ItemId<IComponent> component, IContributor contributor) {
        String propertyName = COMPONENT_LOCKED_BY_PROPERTY_KEY_PREFIX + component.getItemUUID().getUuidValue();
        OwnerEntry ownerEntry = new OwnerEntry(contributor);
        StringBuffer buffer = new StringBuffer();
        ownerEntry.write(buffer);
        workspace.getProperties().put(propertyName, buffer.toString());
    }

    public static boolean containsComponentLocks(Workspace workspace) {
        Set keySet = workspace.getProperties().keySet();
        for (String key : keySet) {
            if (!key.startsWith(COMPONENT_LOCKED_BY_PROPERTY_KEY_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public static interface ILockOwner {
        public boolean isLockedBy(IContributorHandle var1);

        public UUID getContributorItemId();

        public IContributorHandle getContributor();

        public String getUserId();

        public String getName();
    }

    private static class OwnerEntry
    implements ILockOwner {
        private ItemId<IContributor> contributor;
        private String jazzId;
        private String name;

        public OwnerEntry(IContributor currentUser) {
            this.contributor = ItemId.create((IItemHandle)currentUser);
            this.jazzId = currentUser.getUserId();
            this.name = currentUser.getName();
        }

        public OwnerEntry(String contributorId, String jazzId, String name) {
            UUID contributorUUID = UUID.valueOf((String)contributorId);
            this.contributor = new ItemId(IContributor.ITEM_TYPE, contributorUUID);
            this.jazzId = jazzId;
            this.name = name;
        }

        public void write(StringBuffer buffer) {
            buffer.append(this.contributor.getItemUUID().getUuidValue());
            buffer.append("\n");
            buffer.append(this.jazzId);
            if (this.name != null) {
                buffer.append("\n");
                buffer.append(this.name);
            }
        }

        @Override
        public boolean isLockedBy(IContributorHandle authenticatedContributor) {
            return this.contributor.getItemUUID().equals((Object)authenticatedContributor.getItemId());
        }

        @Override
        public UUID getContributorItemId() {
            return this.contributor.getItemUUID();
        }

        @Override
        public IContributorHandle getContributor() {
            return (IContributorHandle)this.contributor.toHandle();
        }

        @Override
        public String getUserId() {
            return this.jazzId;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

