/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.rest;

import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.util.NLS;
import java.util.Map;

public class PropertyRequest
extends JSONObject {
    private static final long serialVersionUID = 1894131156428713632L;
    private RecurseOption recurseOption;
    private JSONObject whereConstraints;

    public PropertyRequest() {
        this(new JSONObject());
    }

    public PropertyRequest(JSONObject src) {
        this.whereConstraints = null;
        if (src != null) {
            this.putAll((Map)src);
        }
    }

    public PropertyRequest(PropertyRequest src) {
        this.putAll(src);
    }

    public void putAll(PropertyRequest src) {
        if (src != null) {
            this.putAll((Map)((Object)src));
            this.setRecurseOption(src.getRecurseOption());
            JSONObject srcConstraints = src.getWhereConstraints();
            if (this.whereConstraints == null) {
                this.whereConstraints = srcConstraints;
            } else if (srcConstraints != null) {
                this.whereConstraints.putAll((Map)srcConstraints);
            }
        }
    }

    public Object put(String key, PropertyRequest value) {
        if (value == null) {
            return super.put((Object)key, null);
        }
        JSONObject valueObject = new JSONObject();
        valueObject.putAll((Map)((Object)value));
        return super.put((Object)key, (Object)valueObject);
    }

    public static PropertyRequest propertyRequest(String ... keys) {
        PropertyRequest request = new PropertyRequest();
        request.addRequest(keys);
        return request;
    }

    public PropertyRequest addRequest(String ... keys) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.addRequest(key, (PropertyRequest)null);
            ++n2;
        }
        return this;
    }

    public static PropertyRequest propertyRequest(String key, PropertyRequest value) {
        PropertyRequest request = new PropertyRequest();
        return request.addRequest(key, value);
    }

    public PropertyRequest addRequest(String key, PropertyRequest value) {
        this.put(key, value);
        return this;
    }

    public PropertyRequest getPropertyRequest(String name) {
        PropertyRequest result;
        Object value = super.get((Object)name);
        if (value == null) {
            result = null;
        } else if (value instanceof PropertyRequest) {
            result = (PropertyRequest)((Object)value);
        } else if (value instanceof Map) {
            result = new PropertyRequest();
            result.putAll((Map)value);
        } else {
            throw new IllegalStateException(NLS.bind((String)"cannot create a property request from: {0}", (Object)value, (Object[])new Object[0]));
        }
        return result;
    }

    public void setRecurseOption(RecurseOption recurseOption) {
        this.recurseOption = recurseOption;
    }

    public void setRecurseOption(String recurseOptionString) {
        if (recurseOptionString == null) {
            return;
        }
        try {
            this.recurseOption = RecurseOption.valueOf(recurseOptionString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public RecurseOption getRecurseOption() {
        return this.recurseOption != null ? this.recurseOption : RecurseOption.none;
    }

    public void setWhereConstraints(JSONObject src) {
        this.whereConstraints = src;
    }

    public JSONObject getWhereConstraints() {
        return this.whereConstraints;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        StringBuffer result = new StringBuffer();
        result.append("recurseOption: ");
        result.append(this.getRecurseOption().toString());
        result.append(", ");
        result.append("whereConstraints: ");
        result.append(this.getWhereConstraints());
        result.append(", ");
        result.append(super.toString(verbose));
        return result.toString();
    }

    public static enum RecurseOption {
        none,
        immediate,
        component,
        all;

    }
}

