/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.rest;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.transport.ITeamModelledRestService;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.rest.IJazzProxy;
import com.ibm.team.scm.common.internal.rest.PropertyRequest;
import com.ibm.team.scm.common.internal.rest.PropertyResult;
import com.ibm.team.scm.common.internal.rest.ResourceProperties;
import com.ibm.team.scm.common.internal.rest.dto.ComponentDTO;
import com.ibm.team.scm.common.internal.rest.dto.ComponentListDTO;
import com.ibm.team.scm.common.internal.rest2.dto.AccessGroupDTO;
import com.ibm.team.scm.common.internal.rest2.dto.BaselineDTO;
import com.ibm.team.scm.common.internal.rest2.dto.BaselineDTO2;
import com.ibm.team.scm.common.internal.rest2.dto.BaselineHistoryDTO;
import com.ibm.team.scm.common.internal.rest2.dto.BaselineSearchResultDTO;
import com.ibm.team.scm.common.internal.rest2.dto.BasicProcessAreaDTO;
import com.ibm.team.scm.common.internal.rest2.dto.ChangeHistoryWithBaselinesResultDTO;
import com.ibm.team.scm.common.internal.rest2.dto.ChangeSetPlusDTO;
import com.ibm.team.scm.common.internal.rest2.dto.ChangeSetSearchResultDTO;
import com.ibm.team.scm.common.internal.rest2.dto.CheckInStateDTO;
import com.ibm.team.scm.common.internal.rest2.dto.ComponentContextDTO;
import com.ibm.team.scm.common.internal.rest2.dto.ComponentDTO2;
import com.ibm.team.scm.common.internal.rest2.dto.ComponentSearchResultDTO;
import com.ibm.team.scm.common.internal.rest2.dto.ContextDTO;
import com.ibm.team.scm.common.internal.rest2.dto.CustomAttributesDTO;
import com.ibm.team.scm.common.internal.rest2.dto.FileSearchResultDTO;
import com.ibm.team.scm.common.internal.rest2.dto.HistoryPlusDTO;
import com.ibm.team.scm.common.internal.rest2.dto.LocksDTO;
import com.ibm.team.scm.common.internal.rest2.dto.OwnerDTO;
import com.ibm.team.scm.common.internal.rest2.dto.ProcessAreaDTO;
import com.ibm.team.scm.common.internal.rest2.dto.ProcessAreaDTO2;
import com.ibm.team.scm.common.internal.rest2.dto.ScmChangeSetLocationsResult;
import com.ibm.team.scm.common.internal.rest2.dto.ScmNewWorkspaceConfigurationData;
import com.ibm.team.scm.common.internal.rest2.dto.ScmQueryItemList;
import com.ibm.team.scm.common.internal.rest2.dto.SnapshotDTO;
import com.ibm.team.scm.common.internal.rest2.dto.SnapshotSearchResultDTO;
import com.ibm.team.scm.common.internal.rest2.dto.VersionableCustomAttributesDTO;
import com.ibm.team.scm.common.internal.rest2.dto.VersionablePlusDTO;
import com.ibm.team.scm.common.internal.rest2.dto.WorkspaceContextDTO;
import com.ibm.team.scm.common.internal.rest2.dto.WorkspaceHistoryDTO;
import com.ibm.team.scm.common.internal.rest2.dto.WorkspaceOperationDescriptionDTO;
import com.ibm.team.scm.common.internal.rest2.dto.WorkspacePlusDTO;
import com.ibm.team.scm.common.internal.rest2.dto.WorkspacePlusSearchResultDTO;
import com.ibm.team.scm.common.internal.rest2.dto.WorkspaceSearchResultDTO;

public interface IScmRestService2
extends ITeamModelledRestService {
    public static final String DIRECTION_ASCENDING = "asc";
    public static final String DIRECTION_DESCENDING = "desc";
    public static final String OPERATION_ACQUIRE = "acquire";
    public static final String OPERATION_RELEASE = "release";
    public static final String OPERATION_ACQUIRE_SUBTREE = "acquire_subtree";
    public static final String OPERATION_RELEASE_SUBTREE = "release_subtree";
    public static final String OPERATION_DESTROY = "destroy";
    public static final String WORD_REAL_BASELINE = "REAL_BASELINE";
    public static final String WORD_BASELINE = "baseline";
    public static final String WORD_CHANGE_SET = "changeSet";
    public static final String WORD_COMPONENT = "component";
    public static final String WORD_HINT = "hint";
    public static final String WORD_ID = "id";
    public static final String WORD_LOCK = "lock";
    public static final String WORD_PATH = "path";
    public static final String WORD_POSTHINT = "preHint";
    public static final String WORD_PREHINT = "postHint";
    public static final String WORD_SNAPSHOT = "snapshot";
    public static final String WORD_STREAM = "stream";
    public static final String WORD_VERSTATE_ID = "verStateId";
    public static final String WORD_WORKSPACE = "workspace";
    public static final String WORD_WS = "ws";
    public static final String CAPITAL_ID = "Id";
    public static final String STATE_ID = "StateId";
    public static final String WORKSPACE_ID_SLASH = "workspaceId/";
    public static final String COMPONENT_ID_SLASH = "componentId/";
    public static final String BASELINE_ID_SLASH = "baselineId/";
    public static final String CHANGE_SET_ID_SLASH = "changeSetId/";
    public static final String CHANGE_SET_STATE_ID_SLASH = "changeSetStateId/";
    public static final String PATH_SLASH = "path/";
    public static final String ID_SLASH = "id/";
    public static final String OWNER_TYPE_CONTRIBUTOR = "contributor";
    public static final String OWNER_TYPE_TEAM_AREA = "teamarea";
    public static final String OWNER_TYPE_PROJECT_AREA = "projectarea";
    public static final String OWNER_TYPE_UNKNOWN = "unknown";
    public static final String VISIBILITY_TYPE_PRIVATE = "private";
    public static final String VISIBILITY_TYPE_PUBLIC = "public";
    public static final String VISIBILITY_TYPE_TEAM_AREA = "teamarea";
    public static final String VISIBILITY_TYPE_PROJECT_AREA = "projectarea";
    public static final String VISIBILITY_TYPE_ACCESS_GROUP = "accessgroup";
    public static final String VISIBILITY_TYPE_UNKNOWN = "unknown";
    public static final String MATCH_KIND_EXACT = "exact";
    public static final String MATCH_KIND_PARTIAL = "partial";
    public static final String MATCH_KIND_PARTIAL_IGNORECASE = "partial ignorecase";
    public static final String STREAMS = "streams";
    public static final String WORKSPACES = "workspaces";
    public static final String BOTH = "both";
    public static final String FLOW_TYPE_ACCEPT = "ACCEPT";
    public static final String FLOW_TYPE_DELIVER = "DELIVER";
    public static final String PATH = "path";
    public static final String CURRENT_USER = "current";
    public static final String READSCOPE_PUBLIC = "public_scope";
    public static final String READSCOPE_CONTRIBUTOR_DEFERRING = "contributor_deferring_scope";
    public static final String READSCOPE_PRIVATE = "private_scope";
    public static final String READSCOPE_ARCHIVED = "archived_scope";
    public static final String READSCOPE_PROCESS_AREA = "process_area_scope";
    public static final String READSCOPE_TEAM_AREA_PRIVATE = "team_area_private_scope";
    public static final String READSCOPE_ACCESS_GROUP = "access_group_scope";
    public static final String READSCOPE_UNKNOWN = "unknown_scope";
    public static final String EXCLUSIVE_FILE_LOCK_PATTERN = "exclusiveFileLockPattern";
    public static final String COMMAND = "command";
    public static final String ITEM_ID = "itemId";
    public static final String REMOTE_REPO_URI = "remoteRepoUri";
    public static final String REMOTE_REPO_ID = "remoteRepoId";
    public static final String NAME = "name";
    public static final String COMPONENT_ADD_COMMAND = "addComponent";
    public static final String COMPONENT_REMOVE_COMMAND = "removeComponent";
    public static final String COMPONENT_REPLACE_COMMAND = "replaceComponent";
    public static final String COMPONENT_SEED_TYPE = "seedType";
    public static final String COMPONENT_SEED_ITEM_ID = "seedItemId";
    public static final String FLOW_TARGET_ADD_COMMAND = "addFlowTarget";
    public static final String FLOW_TARGET_REMOVE_COMMAND = "removeFlowTarget";
    public static final String FLOW_TARGET_UPDATE_COMMAND = "updateFlowTarget";
    public static final String FLOW_TARGET_SET_COMMAND = "setFlowTarget";
    public static final String FLOW_TARGET_DIRECTION_INCOMING = "isFlowDirectionIncoming";
    public static final String FLOW_TARGET_DIRECTION_OUTGOING = "isFlowDirectionOutgoing";
    public static final String FLOW_TARGET_COMPONENT_SCOPES = "componentScopes";
    public static final String FLOW_TARGET_CURRENT_INCOMING = "currentIncoming";
    public static final String FLOW_TARGET_CURRENT_OUTGOING = "currentOutgoing";
    public static final String FLOW_TARGET_DEFAULT_INCOMING = "defaultIncoming";
    public static final String FLOW_TARGET_DEFAULT_OUTGOING = "defaultOutgoing";
    public static final String FLOW_TARGET_UNSET = "unset";
    public static final int ACCESS_MEMBER_PROJECT_AREA_TYPE = 0;
    public static final int ACCESS_MEMBER_TEAM_AREA_TYPE = 1;
    public static final int ACCESS_MEMBER_CONTRIBUTOR_TYPE = 2;

    public void postAddChangeRequests(ParmsAddChangeRequests var1) throws TeamRepositoryException;

    public void postRemoveChangeRequests(ParmsRemoveChangeRequests var1) throws TeamRepositoryException;

    public void postUpdateLocks(ParmsPostLocks var1) throws TeamRepositoryException;

    public VersionablePlusDTO getVersionablePlus(ParmsGetVersionablePlus var1) throws TeamRepositoryException;

    public HistoryPlusDTO getHistoryPlus(ParmsGetHistoryPlus var1) throws TeamRepositoryException;

    public ChangeHistoryWithBaselinesResultDTO getChangeHistoryWithBaselines(ParmsGetChangeHistoryWithBaseline var1) throws TeamRepositoryException;

    public WorkspacePlusSearchResultDTO getSearchWorkspacesPlus(ParmsSearchWorkspacesPlus var1) throws TeamRepositoryException;

    public WorkspaceSearchResultDTO getSearchWorkspaces(ParmsSearchWorkspaces var1) throws TeamRepositoryException;

    public ComponentSearchResultDTO getSearchComponents(ParmsSearchComponents var1) throws TeamRepositoryException;

    public BaselineSearchResultDTO getSearchBaselines(ParmsSearchBaselines var1) throws TeamRepositoryException;

    public BaselineDTO2 getBaseline2(ParmsGetBaseline var1) throws TeamRepositoryException;

    public BaselineHistoryDTO getBaselineHistory(ParmsGetBaselineHistory var1) throws TeamRepositoryException;

    public ChangeSetSearchResultDTO getSearchChangeSets(ParmsSearchChangeSets var1) throws TeamRepositoryException;

    public SnapshotSearchResultDTO getSearchSnapshots(ParmsSearchBaselineSets var1) throws TeamRepositoryException;

    public LocksDTO postFetchLocks(ParmsGetLocks var1) throws TeamRepositoryException;

    public LocksDTO getLocks(ParmsGetLocks var1) throws TeamRepositoryException;

    public SnapshotDTO getSnapshot(ParmsGetSnapshot var1) throws TeamRepositoryException;

    public BaselineDTO getBaseline(ParmsGetBaseline var1) throws TeamRepositoryException;

    public ComponentContextDTO[] getComponentsInHierarchy(ParmsGetComponentsInHierarchy var1) throws TeamRepositoryException;

    public ComponentDTO[] getComponentsInWorkspace(ParmsGetComponentsInWorkspace var1) throws TeamRepositoryException;

    public ComponentDTO2 getComponentHierarchy(ParmsGetComponentHierarchy var1) throws TeamRepositoryException;

    public WorkspaceContextDTO getWorkspace(ParmsGetWorkspace var1) throws TeamRepositoryException;

    public ComponentListDTO getComponentsById(ParmsGetComponentsById var1) throws TeamRepositoryException;

    public ComponentContextDTO[] getComponentsById2(ParmsGetComponentsById var1) throws TeamRepositoryException;

    public ChangeSetPlusDTOAndChangeSet getChangeSetPlus(ParmsGetChangeSetPlus var1) throws TeamRepositoryException;

    public CheckInStateDTO[] getChangeSetCheckinHistory(ParmsGetChangeSetCheckinHistory var1) throws TeamRepositoryException;

    public BasicProcessAreaDTO[] getAllProjectAreas(ParmsGetAllProjectAreas var1) throws TeamRepositoryException;

    public ProcessAreaDTO getProcessAreaRolesAndHierarchy(ParmsGetProcessAreaRolesAndHierarchy var1) throws TeamRepositoryException;

    public WorkspaceHistoryDTO getWorkspaceHistory(ParmsGetWorkspaceHistory var1) throws TeamRepositoryException;

    public WorkspaceOperationDescriptionDTO getOperationDescription(ParmsGetOperationDescription var1) throws TeamRepositoryException;

    public FileSearchResultDTO[] getSearchFiles(ParmsSearchFiles var1) throws TeamRepositoryException;

    public IVersionable getVersionableByPath(String var1, String var2, String var3) throws TeamRepositoryException;

    public IVersionable getVersionableById(String var1, String var2, IItemType var3, String var4, String var5) throws TeamRepositoryException;

    public WorkspaceContextDTO postPutWorkspace(ParmsPutWorkspace var1) throws TeamRepositoryException;

    public AccessGroupDTO[] getAvailableAccessGroups(ParmsGetAvailableAccessGroups var1) throws TeamRepositoryException;

    public ProcessAreaDTO2[] postGetProcessAreas(ParmsGetProcessAreas var1) throws TeamRepositoryException;

    public BaselineDTO postPutBaseline(ParmsPutBaseline var1) throws TeamRepositoryException;

    public SnapshotDTO postPutSnapshot(ParmsPutSnapshot var1) throws TeamRepositoryException;

    public SnapshotDTO postSnapshot(ParmsPostSnapshot var1) throws TeamRepositoryException;

    public BaselineDTO postNewBaseline(ParmsPostBaseline var1) throws TeamRepositoryException;

    public ComponentContextDTO postPutComponent(ParmsPutComponent var1) throws TeamRepositoryException;

    public IJazzProxy lookup(String var1) throws TeamRepositoryException;

    public PropertyResult getProperties(IJazzProxy var1, PropertyRequest var2, ProxyPropertyHelper var3) throws TeamRepositoryException;

    public PropertyResult compare(IJazzProxy var1, IJazzProxy var2, PropertyRequest var3, ProxyPropertyHelper var4) throws TeamRepositoryException;

    public ComponentDTO2[] getComponentHierarchyInWorkspace(ParmsGetWorkspace var1) throws TeamRepositoryException;

    public ScmChangeSetLocationsResult postLocateChangeSets(ParmsGetChangeSetLocations var1) throws TeamRepositoryException;

    public BaselineSearchResultDTO postFetchBaselinesInWorkspace(ParmsGetCompBaselinesInWorkspace var1) throws TeamRepositoryException;

    public ScmNewWorkspaceConfigurationData getNewWorkspaceConfigurationData(ParmsNewWorkspaceConfigurationData var1) throws TeamRepositoryException;

    public void postDeleteWorkspace(ParmsDeleteWorkspace var1) throws TeamRepositoryException;

    public void postBackupAndDeleteStream(ParmsBackupAndDeleteStream var1) throws TeamRepositoryException;

    public void postAddBaselineSet(ParmsAddBaselineSet var1) throws TeamRepositoryException;

    public void postDeleteBaselineSet(ParmsDeleteBaselineSet var1) throws TeamRepositoryException;

    public CustomAttributesDTO postSetCustomAttributes(ParmsSetCustomAttributes var1) throws TeamRepositoryException;

    public CustomAttributesDTO postGetCustomAttributes(ParmsGetCustomAttributes var1) throws TeamRepositoryException;

    public String[] postGetDefinedCustomAttributeIdentifiers(ParmsGetCustomAttributeIdentifiers var1) throws TeamRepositoryException;

    public ContextDTO postGetProjectAreaContextForWorkspace(ParmsItemId var1) throws TeamRepositoryException;

    public WorkspacePlusDTO postGetWorkspacePlus(ParmsItemId var1) throws TeamRepositoryException;

    public OwnerDTO postGetWorkspaceOwner(ParmsItemId var1) throws TeamRepositoryException;

    public WorkspacePlusSearchResultDTO postGetStreamsForContributor(ParmsGetStreamsForContributor var1) throws TeamRepositoryException;

    public ScmQueryItemList postGetSavedScmItemQueries(ParmsGetSavedScmItemQueries var1) throws TeamRepositoryException;

    public WorkspacePlusSearchResultDTO postRunSavedWorkspaceQuery(ParmsRunSavedQuery var1) throws TeamRepositoryException;

    public SnapshotSearchResultDTO postRunSavedSnapshotQuery(ParmsRunSavedQuery var1) throws TeamRepositoryException;

    public BaselineSearchResultDTO postRunSavedBaselineQuery(ParmsRunSavedQuery var1) throws TeamRepositoryException;

    public VersionableCustomAttributesDTO postGetCustomAttributesForVersionables(ParmsGetVersionableCustomAttributes var1) throws TeamRepositoryException;

    public CustomAttributesDTO postSetCustomAttributesForVersionables(ParmsSetVersionableCustomAttributes var1) throws TeamRepositoryException;

    public SnapshotDTO[] getBaselineSets(ParmsSearchBaselineSets var1) throws TeamRepositoryException;

    public static final class ChangeSetPlusDTOAndChangeSet {
        public ChangeSetPlusDTO changeSetPlusDTO;
        public IChangeSet changeSet;
        public IContextHandle contextHandle;
    }

    public static final class ParmsAddBaselineSet
    implements IParameterWrapper {
        public String baselineSetItemId;
        public String peerWorkspaceItemId;
    }

    public static final class ParmsAddChangeRequests
    implements IParameterWrapper {
        public String changeSetItemId;
        public String workspaceId;
        public String[] targetOslcResourceUris;
        public String[] targetLabels;
        public String[] targetRepoIds;
        public String[] targetRepositoryURIs;
    }

    public static final class ParmsBackupAndDeleteStream
    implements IParameterWrapper {
        public String workspaceItemId;
        public String peerWorkspaceItemId;
    }

    public static final class ParmsDeleteBaselineSet
    implements IParameterWrapper {
        public String baselineSetItemId;
        public String owningWorkspaceItemId;
    }

    public static final class ParmsDeleteWorkspace
    implements IParameterWrapper {
        public String workspaceItemId;
    }

    public static final class ParmsGetAllProjectAreas
    implements IParameterWrapper {
        public String nameFilter;
        public Integer startIndex = 0;
        public Integer size = 100;
        public boolean includeArchived = false;
    }

    public static final class ParmsGetAvailableAccessGroups
    implements IParameterWrapper {
        public String owningApplicationKey;
        public String nameFilter;
        public boolean inlcudeMembersDetails = false;
        public int maxResults = 250;
    }

    public static final class ParmsGetBaseline
    implements IParameterWrapper {
        public String baselineItemId;
        public boolean includeComponentRoots;
        public boolean fetchCustomAttributes = false;
        public boolean includeVisibility = false;
    }

    public static final class ParmsGetBaselineHistory
    implements IParameterWrapper {
        public String componentId;
        public String[] workspaceIds;
        public int maxResultSize = -1;
        public long start = -1L;
        public long end;
        public String nextPage;
        public boolean fetchCompleteFlowPath = false;
    }

    public static final class ParmsGetChangeHistoryWithBaseline
    implements IParameterWrapper {
        public String workspaceId;
        public String componentId;
        public String nextPageToken;
        public String pageDirection;
        public int pageSize;

        public boolean isPagingDirectionAscending() {
            return IScmRestService2.DIRECTION_ASCENDING.equalsIgnoreCase(this.pageDirection);
        }

        public boolean isPagingDirectionDescending() {
            return !this.isPagingDirectionAscending();
        }
    }

    public static final class ParmsGetChangeSetCheckinHistory
    implements IParameterWrapper {
        public String changeSetId;
        public String versionableId;
    }

    public static final class ParmsGetChangeSetLocations
    implements IParameterWrapper {
        public static final int MAX_CHANGESETS = 256;
        public static final int MAX_TARGETS = 512;
        public String[] changeSetItemIds;
        public String[] workspaceItemIds;
        public String[] snapshotItemIds;
        public String[] baselineItemIds;
        public boolean includePorts = false;
    }

    public static final class ParmsGetChangeSetPlus
    implements IParameterWrapper {
        public String changeSetPath;
    }

    public static final class ParmsGetCompBaselinesInWorkspace
    implements IParameterWrapper {
        public String workspaceItemId;
        public String componentItemId;
        public String startIdx;
        public String maxResult;
    }

    public static final class ParmsGetComponentHierarchy
    implements IParameterWrapper {
        public String componentItemId;
        public String workspaceItemId;
    }

    public static final class ParmsGetComponentsById
    implements IParameterWrapper {
        public String[] componentItemIds;
    }

    public static final class ParmsGetComponentsInHierarchy
    implements IParameterWrapper {
        public String[] componentItemIds;
        public String workspaceItemId;
        public boolean includeOwnerAndVisibility;
    }

    public static final class ParmsGetComponentsInWorkspace
    implements IParameterWrapper {
        public String workspaceItemId;
        public boolean visibleOnly;
    }

    public static final class ParmsGetCustomAttributeIdentifiers
    implements IParameterWrapper {
        public String projectAreaItemId;
        public int attributeArtifactType;
    }

    public static final class ParmsGetCustomAttributes
    implements IParameterWrapper {
        public String itemId;
        public String itemType;
    }

    public static final class ParmsGetHistoryPlus
    implements IParameterWrapper {
        public String path;
        public String last;
        public String first;
        public String n;
    }

    public static final class ParmsGetLocks
    implements IParameterWrapper {
        public Long lockTime;
        public String[] streamItemIds;
        public String[] componentItemIds;
        public String[] versionableItemId;
        public String[] versionableItemType;
        public String[] versionableItemTypeNamespace;
        public String lockedByContributorId;
        public Integer length;
        public String versionableName;
        public boolean exactSearch;
        public boolean caseInSensitive;
        public String pageDescriptor;
    }

    public static final class ParmsGetOperationDescription
    implements IParameterWrapper {
        public String workspaceId;
        public String componentId;
        public long componentState;
        public int maxDetailSize;
    }

    public static final class ParmsGetProcessAreaRolesAndHierarchy
    implements IParameterWrapper {
        public boolean includeDetailsForChildren = true;
        public String itemID;
    }

    public static final class ParmsGetProcessAreas
    implements IParameterWrapper {
        public String[] processAreaItemNamespace;
        public String[] processAreaItemName;
        public String[] processAreaItemIds;
    }

    public static final class ParmsGetSavedScmItemQueries
    implements IParameterWrapper {
        public String queryType;
        public String namePattern;
        public String[] queryItemIds;
        public int maxResult;
    }

    public static final class ParmsGetSnapshot
    implements IParameterWrapper {
        public String snapshotItemId;
        public boolean fetchCustomAttributes = false;
        public boolean includeBaselines = true;
        public boolean includeVisibility = false;
    }

    public static final class ParmsGetStreamsForContributor
    implements IParameterWrapper {
        public String contributorItemId;
        public String processAreaId;
        public int maxResults;
    }

    public static final class ParmsGetVersionableCustomAttributes
    implements IParameterWrapper {
        public String[] itemId;
        public String[] stateId;
        public String[] versionableNamespace;
        public String[] versionableItemType;
    }

    public static final class ParmsGetVersionablePlus
    implements IParameterWrapper {
        public String versionablePath;
        public String gcContext;
        public boolean isFetchLinks;
    }

    public static final class ParmsGetWorkspace
    implements IParameterWrapper {
        public String workspaceItemId;
        public boolean fetchCustomAttributes = false;
        public boolean includeComponentProjectAreaAndVisibility = false;
        public boolean filterComponents = false;
        public String[] componentIdsFilter;
    }

    public static final class ParmsGetWorkspaceHistory
    implements IParameterWrapper {
        public String workspaceId;
        public String historyReferenceId;
        public String pageToken;
        public String pagingDirection;
        public long startTime;
        public long endTime;
        public int maxResultSize;
        public int maxDetailSize;
        public String[] componentFilter;
        public String[] userFilter;
        public boolean includeDetails;
        public boolean includeCheckins;

        public boolean isPagingDirectionAscending() {
            return IScmRestService2.DIRECTION_ASCENDING.equalsIgnoreCase(this.pagingDirection);
        }

        public boolean isPagingDirectionDescending() {
            return !this.isPagingDirectionAscending();
        }
    }

    public static final class ParmsItemId
    implements IParameterWrapper {
        public String itemId;
    }

    public static final class ParmsNewWorkspaceConfigurationData
    implements IParameterWrapper {
        public String streamItemId;

        public IWorkspaceHandle getStreamHandle() throws TeamRepositoryException {
            try {
                return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.streamItemId), null);
            }
            catch (Exception e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
    }

    public static final class ParmsPostBaseline
    implements IParameterWrapper {
        public String name;
        public String description;
        public String workspaceItemId;
        public String componentItemId;
    }

    public static final class ParmsPostLocks
    implements IParameterWrapper {
        public String[] operation;
        public String[] streamId;
        public String[] componentId;
        public String[] versionableNamespace;
        public String[] versionableItemType;
        public String[] versionableItemId;
    }

    public static final class ParmsPostSnapshot
    implements IParameterWrapper {
        public String name;
        public String comment;
        public String owningWorkspaceItemId;
        public String[] excludedComponents;
        public boolean forceCreateBaseline;
    }

    public static final class ParmsPutBaseline
    implements IParameterWrapper {
        public String itemId;
        public String name;
        public String comment;
    }

    public static final class ParmsPutComponent
    implements IParameterWrapper {
        public String itemId;
        public String name;
        public String newOwnerItemId;
        public String newOwnerItemType;
        public String readScope;
        public String readScopeDeferTo;
    }

    public static final class ParmsPutSnapshot
    implements IParameterWrapper {
        public String itemId;
        public String name;
        public String comment;
        public String owningWorkspaceItemId;
        public String[] customAttrsToSet;
        public String[] customAttrsToUnset;
    }

    public static final class ParmsPutWorkspace
    implements IParameterWrapper {
        public String itemId;
        public String name;
        public String description;
        public String newOwnerItemId;
        public String newOwnerItemType;
        public String[] flowTargets;
        public String[] components;
        public String repositoryUrl;
        public String readScope;
        public String readScopeDeferTo;
        public String autoLockFilePattern;
        public String[] customAttrsToSet;
        public String[] customAttrsToUnset;
    }

    public static final class ParmsRemoveChangeRequests
    implements IParameterWrapper {
        public String changeSetItemId;
        public String[] targetOslcResourceUris;
    }

    public static final class ParmsRunSavedQuery
    implements IParameterWrapper {
        public String queryItemId;
        public String queryType;
        public long pageToken;
        public int maxResult;
    }

    public static final class ParmsSearchBaselineSets
    implements IParameterWrapper {
        public String baselineSetName;
        public String baselineSetNameKind;
        public long modifiedBefore;
        public long modifiedAfter;
        public int maxResultSize;
        public String workspaceItemId;
        public String processAreaItemTypeNamespace;
        public String processAreaItemType;
        public String processAreaItemItemId;
    }

    public static final class ParmsSearchBaselines
    implements IParameterWrapper {
        public String componentId;
        public String baselineName;
        public String baselineNameKind;
        public long modifiedBefore;
        public long modifiedAfter;
        public int maxResultSize;
        public String[] creatorItemItemId;
    }

    public static final class ParmsSearchChangeSets
    implements IParameterWrapper {
        public String workspaceOrStreamItemId;
        public String componentItemId;
        public String suspendedByContributorId;
        public String authorId;
        public int changeKind;
        public String filenamePrefix;
        public String itemTypeNamespace;
        public String itemType;
        public String itemItemId;
        public String portId;
        public long modifiedBefore;
        public long modifiedAfter;
        public int maxResultSize;
    }

    public static final class ParmsSearchComponents
    implements IParameterWrapper {
        public String componentName;
        public String componentNameKind;
        public String[] ownerItemTypeNamespace;
        public String[] ownerItemType;
        public String[] ownerItemItemId;
        public String[] readScopeType;
        public String[] readScopeContextId;
        public long modifiedBefore;
        public long modifiedAfter;
        public int maxResultSize;
    }

    public static final class ParmsSearchFiles
    implements IParameterWrapper {
        public String contextItemId;
        public String contextItemType;
        public String[] componentItemIds;
        public String fileNamePattern;
        public boolean isCaseSensitive = false;
        public int maxResultSize;
        public String[] customAttributes;
    }

    public static class ParmsSearchWorkspaces
    implements IParameterWrapper {
        public String workspaceName;
        public String workspaceNameKind;
        public String ownerName;
        public String ownerNameKind;
        public boolean unionOwnerAndWorkspaceName;
        public String workspaceKind;
        public String flowFilterItemId;
        public String flowType;
        public String[] ownerItemTypeNamespace;
        public String[] ownerItemType;
        public String[] ownerItemItemId;
        public String[] readScopeType;
        public String[] readScopeContextId;
        public long modifiedBefore;
        public long modifiedAfter;
        public int maxResultSize;
        public String[] hasComponentIds;
    }

    public static final class ParmsSearchWorkspacesPlus
    extends ParmsSearchWorkspaces {
        public boolean fetchOwner = false;
    }

    public static final class ParmsSetCustomAttributes
    implements IParameterWrapper {
        public String itemId;
        public String itemType;
        public String[] customAttrsToSet;
        public String[] customAttrsToUnset;
    }

    public static final class ParmsSetVersionableCustomAttributes
    implements IParameterWrapper {
        public String itemId;
        public String stateId;
        public String itemType;
        public String namespace;
        public String[] customAttrsToSet;
        public String[] customAttrsToUnset;
    }

    public static interface ProxyPropertyHelper {
        public Object getThisProperty(IJazzProxy var1, ResourceProperties.PropertyName var2, PropertyRequest var3) throws TeamRepositoryException;

        public PropertyResult getDefaultProperties(IJazzProxy var1, PropertyRequest var2) throws TeamRepositoryException;
    }
}

