/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.process;

import com.ibm.team.repository.common.IRepositoryRootHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.internal.process.AdvisorDetailConstants;
import com.ibm.team.scm.common.internal.process.UnifiedProcessDescriptionUtil;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AdvisorMarkupText {
    protected final Document doc = UnifiedProcessDescriptionUtil.createXmlDoc();
    protected final Element root = AdvisorDetailConstants.makeDescAndAppend(this.doc);
    protected final UUID defaultRepoRoot;

    public AdvisorMarkupText(IRepositoryRootHandle repoRoot) throws TeamRepositoryException {
        this.defaultRepoRoot = repoRoot.getItemId();
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element appendList(AdvisorDetailConstants.ListType t) {
        Element list = AdvisorDetailConstants.makeList(this.doc, t);
        this.root.appendChild(list);
        return list;
    }

    public void appendParagraph(String text, Object ... toSubstituteIn) {
        Element para = AdvisorDetailConstants.makeParaAndAppend(this.doc, this.root);
        UnifiedProcessDescriptionUtil.xmlBind(this.doc, para, text, toSubstituteIn);
    }

    public String serialize() throws TeamRepositoryException {
        return UnifiedProcessDescriptionUtil.serializeDoc(this.doc);
    }

    public Element makeChangeSetLink(String linkText, IContextHandle ctx, IComponentHandle comp, List csHandles) {
        IChangeSetHandle[] array = csHandles.toArray(new IChangeSetHandle[csHandles.size()]);
        return AdvisorDetailConstants.makeChangeSetLink(this.doc, linkText, this.defaultRepoRoot, ctx, comp, array);
    }

    public Element makeChangeSetLink(String linkText, IContextHandle ctx, IComponentHandle comp, IChangeSetHandle ... csHandles) {
        return AdvisorDetailConstants.makeChangeSetLink(this.doc, linkText, this.defaultRepoRoot, ctx, comp, csHandles);
    }

    public Element makeChangeSetLink(String csLinkText, Collection<IChangeSet> csHandles) {
        IChangeSetHandle[] array = csHandles.toArray(new IChangeSetHandle[csHandles.size()]);
        return AdvisorDetailConstants.makeChangeSetLink(this.doc, csLinkText, this.defaultRepoRoot, null, null, array);
    }

    public Element makeComponentLink(IComponent comp, IContextHandle ctx) {
        return AdvisorDetailConstants.makeComponentLink(this.doc, comp.getName(), this.defaultRepoRoot, comp, comp.getName(), ctx);
    }

    public Element makePara(String text, Object ... toSubstituteIn) {
        Element para = this.doc.createElement("paragraph");
        UnifiedProcessDescriptionUtil.xmlBind(this.doc, para, text, toSubstituteIn);
        return para;
    }

    public Object makeEm(String string) {
        return AdvisorDetailConstants.makeEm(this.doc, string);
    }

    public void appendListContent(AdvisorDetailConstants.ListType numbers, Element ... children) {
        Element list = this.appendList(numbers);
        Element[] elementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Element li = elementArray[n2];
            AdvisorDetailConstants.appendToList(this.doc, list, li);
            ++n2;
        }
    }

    public void appendListContent(AdvisorDetailConstants.ListType numbers, Iterable<Element> children) {
        Element list = this.appendList(numbers);
        for (Element li : children) {
            AdvisorDetailConstants.appendToList(this.doc, list, li);
        }
    }
}

