/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.gc;

import com.ibm.team.scm.common.internal.dto2.OslcFileLinkDTO;
import com.ibm.team.scm.common.internal.gc.Direction;
import java.net.URI;
import org.eclipse.core.runtime.Assert;

public final class OslcFileLink {
    private final URI relatedArtifactUrl;
    private final String relationshipDisplayName;
    private final URI relationshipIconUri;
    private final URI oslcRelationshipUri;
    private final Direction direction;

    public static OslcFileLink create(URI relatedArtifactUrl, String relationshipDisplayName, URI relationshipIconUri, URI oslcRelationshipUri, Direction direction) {
        Assert.isNotNull((Object)relatedArtifactUrl);
        Assert.isNotNull((Object)relationshipDisplayName);
        Assert.isNotNull((Object)((Object)direction));
        return new OslcFileLink(relatedArtifactUrl, relationshipDisplayName, relationshipIconUri, oslcRelationshipUri, direction);
    }

    public static OslcFileLink create(OslcFileLinkDTO dto) {
        Assert.isNotNull((Object)dto);
        Assert.isNotNull((Object)dto.getRelatedArtifactUrl());
        Assert.isNotNull((Object)dto.getRelationshipDisplayName());
        Assert.isNotNull((Object)dto.getOslcRelationshipUri());
        URI relatedArtifactUri = URI.create(dto.getRelatedArtifactUrl());
        URI relationshipIcon = dto.getRelationshipIcon() == null ? null : URI.create(dto.getRelationshipIcon());
        URI oslcRelationshipUri = URI.create(dto.getOslcRelationshipUri());
        return OslcFileLink.create(relatedArtifactUri, dto.getRelationshipDisplayName(), relationshipIcon, oslcRelationshipUri, Direction.valueOf(dto.isIsOutgoingLink()));
    }

    private OslcFileLink(URI relatedArtifactUrl, String relationshipDisplayName, URI relationshipIconPath, URI oslcRelationshipUri, Direction direction) {
        this.relatedArtifactUrl = relatedArtifactUrl;
        this.relationshipDisplayName = relationshipDisplayName;
        this.relationshipIconUri = relationshipIconPath;
        this.oslcRelationshipUri = oslcRelationshipUri;
        this.direction = direction;
    }

    public URI getRelatedArtifactUrl() {
        return this.relatedArtifactUrl;
    }

    public String getRelationshipDisplayName() {
        return this.relationshipDisplayName;
    }

    public URI getRelationshipIcon() {
        return this.relationshipIconUri;
    }

    public URI getOslcRelationshipUri() {
        return this.oslcRelationshipUri;
    }

    public Direction getDirection() {
        return this.direction;
    }
}

