/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.gc;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.ICustomAttributeHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.CustomAttribute;
import com.ibm.team.scm.common.internal.dto.ExternalLinkEntries;
import com.ibm.team.scm.common.internal.gc.ExternalLink;
import com.ibm.team.scm.common.internal.gc.ExternalLinkOptions;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.gc.ExternalLinksDTOUtils;
import com.ibm.team.scm.common.internal.gc.ExternalLinksVisitor;
import com.ibm.team.scm.common.internal.gc.LinkDiffReport;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SCMItemUtil;
import com.ibm.team.scm.common.links.LinkTypeIdentifier;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public final class LinkUtils {
    private LinkUtils() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    public static ExternalLinks getLinks(IVersionableHandle stateHandle, IScmService scmService, IProgressMonitor monitor) throws TeamRepositoryException {
        if (stateHandle == null) {
            return ExternalLinks.create();
        }
        Assert.isLegal((boolean)stateHandle.hasStateId(), (String)"Handle must have a state.");
        IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
        ExternalLinkEntries[] externalLinks = scmService.getLinksInternal(new IVersionableHandle[]{stateHandle}, ExternalLinkOptions.DEFAULT, progressMonitor);
        if (externalLinks != null && externalLinks.length > 0 && externalLinks[0] != null && externalLinks[0].isSetLinks()) {
            List entries = externalLinks[0].getLinks();
            return ExternalLinksDTOUtils.createFromExternalLinkEntries(entries);
        }
        return ExternalLinks.create();
    }

    public static boolean areUnchanged(ExternalLinks before, ExternalLinks after) {
        if (before == null) {
            return after == null;
        }
        if (after == null) {
            return false;
        }
        LinkDiffReport diff = LinkUtils.makeDifferenceReport(before, after);
        return diff.isUnchanged();
    }

    public static String getURL(IReference reference, ItemFetcher itemFetcher, UriResolver uriResolver) throws TeamRepositoryException {
        String result;
        Assert.isLegal((reference != null ? 1 : 0) != 0, (String)"reference is required");
        Assert.isLegal((itemFetcher != null ? 1 : 0) != 0, (String)"itemFetcher is required");
        Assert.isLegal((uriResolver != null ? 1 : 0) != 0, (String)"uriResolver is required");
        if (reference.isItemReference()) {
            IItemReference itemReference = (IItemReference)reference;
            IVersionableHandle versionable = LinkUtils.getSourceVersionableState((IReference)itemReference, itemFetcher);
            result = uriResolver.resolveUri((IItemHandle)versionable);
        } else {
            IURIReference uriReference = (IURIReference)reference;
            result = uriReference.getURI().toString();
        }
        return result;
    }

    public static IVersionableHandle getSourceVersionableState(IReference sourceReference, ItemFetcher itemFetcher) throws TeamRepositoryException {
        Assert.isLegal((sourceReference != null ? 1 : 0) != 0, (String)"sourceReference is required");
        Assert.isLegal((boolean)sourceReference.isItemReference(), (String)"Source must be item reference.");
        IItemReference itemReference = (IItemReference)sourceReference;
        IItemHandle customAttributeHandle = itemReference.getReferencedItem();
        Assert.isLegal((boolean)(customAttributeHandle instanceof ICustomAttributeHandle), (String)"Source must be a CustomAttribute.");
        CustomAttribute customAttribute = itemFetcher.fetchCompleteItem(CustomAttribute.class, customAttributeHandle);
        IVersionableHandle versionableHandle = SCMItemUtil.createVersionableHandle(customAttribute);
        return versionableHandle;
    }

    public static boolean containsLink(ExternalLinks links, LinkTypeIdentifier linkType, URI uri) {
        if (links == null) {
            return false;
        }
        ExternalLink targetLink = ExternalLink.create(linkType, uri);
        for (ExternalLink l : links.getAllExternalLinks()) {
            if (!LinkUtils.equivalentLinks(l, targetLink)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIdenticalLink(ExternalLinks links, LinkTypeIdentifier linkType, URI uri) {
        if (links == null) {
            return false;
        }
        for (ExternalLink l : links.getAllExternalLinks()) {
            if (!l.getLinkTypeId().sameLinkTypeAndInstanceAs(linkType) || !l.getUri().equals(uri)) continue;
            return true;
        }
        return false;
    }

    public static boolean equivalentLinks(ExternalLink link1, ExternalLink link2) {
        if (link1 == null) {
            return link2 == null;
        }
        if (link2 == null) {
            return false;
        }
        return link1.getUri().equals(link2.getUri()) && Objects.equals(link1.getLinkTypeId().toLinkServiceId(), link2.getLinkTypeId().toLinkServiceId());
    }

    public static boolean identicalLinks(ExternalLink link1, ExternalLink link2) {
        if (link1 == null) {
            return link2 == null;
        }
        if (link2 == null) {
            return false;
        }
        return link1.getUri().equals(link2.getUri()) && Objects.equals(link1.getLinkTypeId().toLinkServiceId(), link2.getLinkTypeId().toLinkServiceId()) && Objects.equals(link1.getLinkTypeId().getInstanceId(), link2.getLinkTypeId().getInstanceId());
    }

    public static boolean addLinkIfNotPresent(Collection<ExternalLink> links, ExternalLink linkToAdd) {
        for (ExternalLink current : links) {
            if (!LinkUtils.identicalLinks(current, linkToAdd)) continue;
            return false;
        }
        links.add(linkToAdd);
        return true;
    }

    public static boolean removeIdenticalLink(Collection<ExternalLink> links, ExternalLink linkToRemove) {
        boolean anyRemoved = false;
        Iterator<ExternalLink> i = links.iterator();
        while (i.hasNext()) {
            ExternalLink current = i.next();
            if (!LinkUtils.identicalLinks(current, linkToRemove)) continue;
            i.remove();
            anyRemoved = true;
        }
        return anyRemoved;
    }

    public static ExternalLinks addLink(ExternalLinks original, LinkTypeIdentifier linkType, URI uri) {
        List<ExternalLink> updatedLinks = NewCollection.arrayList(original.getAllExternalLinks());
        updatedLinks.add(ExternalLink.create(linkType, uri));
        return ExternalLinks.createFromExternalLinkCollection(updatedLinks);
    }

    public static ExternalLinks removeLink(ExternalLinks original, LinkTypeIdentifier linkType, URI uri) {
        List<ExternalLink> updatedLinks = NewCollection.arrayList(original.getAllExternalLinks());
        LinkUtils.removeIdenticalLink(updatedLinks, ExternalLink.create(linkType, uri));
        return ExternalLinks.createFromExternalLinkCollection(updatedLinks);
    }

    public static ExternalLinks union(ExternalLinks original, ExternalLinks linksToAdd) {
        final List<ExternalLink> allLinks = NewCollection.arrayList(original.getAllExternalLinks());
        try {
            linksToAdd.visitAllExternalLinks(new ExternalLinksVisitor(){

                @Override
                public void visitLink(ExternalLink link) {
                    LinkUtils.addLinkIfNotPresent(allLinks, link);
                }
            });
        }
        catch (TeamRepositoryException e) {
            throw new AssertionError((Object)"Visitor does not throw exception");
        }
        return ExternalLinks.createFromExternalLinkCollection(allLinks);
    }

    public static ExternalLinks difference(ExternalLinks original, ExternalLinks linksToRemove) {
        final List<ExternalLink> result = NewCollection.arrayList(original.getAllExternalLinks());
        try {
            linksToRemove.visitAllExternalLinks(new ExternalLinksVisitor(){

                @Override
                public void visitLink(ExternalLink link) {
                    LinkUtils.removeIdenticalLink(result, link);
                }
            });
        }
        catch (TeamRepositoryException e) {
            throw new AssertionError((Object)"Visitor does not throw exception");
        }
        return ExternalLinks.createFromExternalLinkCollection(result);
    }

    public static LinkDiffReport makeDifferenceReport(ExternalLinks original, ExternalLinks linksToCompareWith) {
        List<ExternalLink> additions = NewCollection.arrayList(linksToCompareWith.getAllExternalLinks());
        ArrayList<ExternalLink> deletions = NewCollection.arrayList();
        for (ExternalLink l : original.getAllExternalLinks()) {
            if (LinkUtils.removeIdenticalLink(additions, l)) continue;
            deletions.add(l);
        }
        return new LinkDiffReport(ExternalLinks.createFromExternalLinkCollection(additions), ExternalLinks.createFromExternalLinkCollection(deletions));
    }

    public static void writeToStream(ExternalLinks links, DataOutputStream out) throws IOException {
        out.writeInt(links.getAllExternalLinks().size());
        for (ExternalLink l : links.getAllExternalLinks()) {
            l.getLinkTypeId().writeToStream(out);
            out.writeInt(1);
            out.writeUTF(l.getUri().toString());
        }
    }

    public static interface ItemFetcher {
        public <T> T fetchCompleteItem(Class<T> var1, IItemHandle var2) throws TeamRepositoryException;
    }

    public static interface UriResolver {
        public String resolveUri(IItemHandle var1);
    }
}

