/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.gc;

import com.ibm.team.repository.common.transport.UriUtil;
import com.ibm.team.scm.common.internal.gc.OslcFileLink;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;

public final class GCUriUtils {
    private static final String CONFIGURATION_CONTEXT_QUERY_NAME = "oslc_config.context";

    private GCUriUtils() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    private static String getGCParameterName() {
        return CONFIGURATION_CONTEXT_QUERY_NAME;
    }

    public static URI removeGCContextFromUri(URI resourceUri) {
        Assert.isNotNull((Object)resourceUri);
        Map queryParameters = UriUtil.parseQueryParameters((String)resourceUri.getQuery());
        queryParameters.remove(GCUriUtils.getGCParameterName());
        try {
            return UriUtil.fromComponents((String)resourceUri.getScheme(), (String)resourceUri.getHost(), (int)resourceUri.getPort(), (String)resourceUri.getRawPath(), (String)UriUtil.queryString((Map)queryParameters), (String)resourceUri.getRawFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URI getGCUri(URI resourceUri) {
        Map queryParameters = UriUtil.parseQueryParameters((String)resourceUri.getQuery());
        String[] values = (String[])queryParameters.get(GCUriUtils.getGCParameterName());
        if (values == null || values.length == 0) {
            return null;
        }
        return URI.create(values[0]);
    }

    public static URI makeGCQualifiedUri(URI resourceUri, URI gcUri) {
        Assert.isNotNull((Object)resourceUri);
        if (gcUri == null) {
            return resourceUri;
        }
        Map queryParameters = UriUtil.parseQueryParameters((String)resourceUri.getQuery());
        String encodedGc = UriUtil.encode((String)gcUri.toString());
        queryParameters.put(GCUriUtils.getGCParameterName(), new String[]{encodedGc});
        try {
            return UriUtil.fromComponents((String)resourceUri.getScheme(), (String)resourceUri.getHost(), (int)resourceUri.getPort(), (String)resourceUri.getRawPath(), (String)UriUtil.queryString((Map)queryParameters), (String)resourceUri.getRawFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URI optionalUri(String gcUriStr) {
        if (gcUriStr == null || gcUriStr.isEmpty()) {
            return null;
        }
        return URI.create(gcUriStr);
    }

    public static boolean isSameLink(OslcFileLink link1, OslcFileLink link2) {
        URI link1TargetUri = link1.getRelatedArtifactUrl();
        URI link2TargetUri = link2.getRelatedArtifactUrl();
        if (link1TargetUri != null ? link2TargetUri == null || !GCUriUtils.removeGCContextFromUri(link1TargetUri).equals(GCUriUtils.removeGCContextFromUri(link2TargetUri)) : link2TargetUri != null) {
            return false;
        }
        return Objects.equals(link1.getOslcRelationshipUri(), link2.getOslcRelationshipUri());
    }
}

