/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.gc;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.internal.dto.ExternalLinkEntries;
import com.ibm.team.scm.common.internal.dto.ExternalLinkEntry;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.gc.ExternalLink;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.gc.ExternalLinksVisitor;
import com.ibm.team.scm.common.internal.gc.LinkUtils;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.links.LinkTypeIdentifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class ExternalLinksDTOUtils {
    private ExternalLinksDTOUtils() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    public static ExternalLinks create(ExternalLinkEntry[] linkEntries) {
        if (linkEntries == null) {
            return ExternalLinks.create();
        }
        return ExternalLinksDTOUtils.createFromExternalLinkEntries(Arrays.asList(linkEntries));
    }

    public static ExternalLinks create(ExternalLinkEntries linkEntries) {
        List links = linkEntries.getLinks();
        return ExternalLinksDTOUtils.createFromExternalLinkEntries(links);
    }

    public static ExternalLinks createFromExternalLinkEntries(Collection<ExternalLinkEntry> linkEntries) {
        ExternalLinks result = ExternalLinks.create();
        if (linkEntries != null) {
            for (ExternalLinkEntry l : linkEntries) {
                LinkTypeIdentifier linkType = LinkTypeIdentifier.createFromDTO(l);
                URI uri = URI.create(l.getToLink());
                result = LinkUtils.addLink(result, linkType, uri);
            }
        }
        return result;
    }

    public static Collection<ExternalLinkEntry> asLinkEntries(ExternalLinks links) {
        try {
            final ArrayList<ExternalLinkEntry> result = NewCollection.arrayList();
            links.visitAllExternalLinks(new ExternalLinksVisitor(){

                @Override
                public void visitLink(ExternalLink link) {
                    result.add(ExternalLinksDTOUtils.asExternalLinkEntry(link));
                }
            });
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public static ExternalLinkEntry asExternalLinkEntry(ExternalLink link) {
        ExternalLinkEntry result = ScmDtoFactory.eINSTANCE.createExternalLinkEntry();
        result.setToLink(link.getUri().toString());
        result.setType(link.getLinkTypeId().toLinkServiceId());
        result.setTypeInstanceId(link.getLinkTypeId().getInstanceId());
        return result;
    }
}

