/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.gc;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.internal.gc.ExternalLink;
import com.ibm.team.scm.common.internal.gc.ExternalLinksVisitor;
import com.ibm.team.scm.common.internal.gc.ILinkTypeLookUpHandler;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.links.LinkTypeIdentifier;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public final class ExternalLinks {
    private final Collection<ExternalLink> links;

    public static ExternalLinks createFromILinkCollection(ILinkTypeLookUpHandler linkTypeLookUpHandler, Collection<? extends ILink> links) throws TeamRepositoryException {
        ArrayList<ExternalLink> result = NewCollection.arrayList();
        for (ILink iLink : links) {
            if (iLink.getTargetRef().isURIReference()) {
                ILinkType linktype = linkTypeLookUpHandler.getLinkType(iLink);
                LinkTypeIdentifier linkType = LinkTypeIdentifier.create(linktype);
                URI uri = ((IURIReference)iLink.getTargetRef()).getURI();
                result.add(ExternalLink.create(linkType, uri));
                continue;
            }
            throw new IllegalStateException("Link target is not a URI");
        }
        return ExternalLinks.createFromExternalLinkCollection(result);
    }

    public static ExternalLinks createFromStream(DataInputStream in) throws IOException {
        ArrayList<ExternalLink> result = NewCollection.arrayList();
        try {
            int numberOfLinkTypes = in.readInt();
            int i = 0;
            while (i < numberOfLinkTypes) {
                LinkTypeIdentifier linkType = LinkTypeIdentifier.create(in);
                int numberOfURIs = in.readInt();
                int j = 0;
                while (j < numberOfURIs) {
                    result.add(ExternalLink.create(linkType, new URI(in.readUTF())));
                    ++j;
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return ExternalLinks.createFromExternalLinkCollection(result);
    }

    public static ExternalLinks create(ExternalLink ... links) {
        return ExternalLinks.createFromExternalLinkCollection(Arrays.asList(links));
    }

    public static ExternalLinks createFromExternalLinkCollection(Collection<ExternalLink> links) {
        return new ExternalLinks(links);
    }

    public static ExternalLinks create(ExternalLinks source) {
        if (source == null) {
            return ExternalLinks.create();
        }
        return new ExternalLinks(source.links);
    }

    public static ExternalLinks create() {
        return new ExternalLinks();
    }

    private ExternalLinks() {
        this.links = Collections.emptySet();
    }

    private ExternalLinks(Collection<ExternalLink> links) {
        this.links = Collections.unmodifiableCollection(NewCollection.arrayList(links));
    }

    public String toString() {
        StringBuilder result = new StringBuilder("ExternalLinks [");
        String keyDelimiter = "";
        for (ExternalLink l : this.links) {
            result.append(keyDelimiter);
            result.append(l.getLinkTypeId());
            result.append('=');
            result.append(l.getUri());
            keyDelimiter = ";";
        }
        result.append("]");
        return result.toString();
    }

    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    public void visitAllExternalLinks(ExternalLinksVisitor visitor) throws TeamRepositoryException {
        for (ExternalLink link : this.links) {
            visitor.visitLink(link);
        }
    }

    public Collection<ExternalLink> getAllExternalLinks() {
        return this.links;
    }
}

