/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.gc;

import com.ibm.team.scm.common.links.LinkTypeIdentifier;
import java.net.URI;

public final class ExternalLink {
    private final LinkTypeIdentifier linkType;
    private final URI uri;

    public static ExternalLink create(LinkTypeIdentifier linkType, URI uri) {
        return new ExternalLink(linkType, uri);
    }

    private ExternalLink(LinkTypeIdentifier linkType, URI uri) {
        if (linkType == null) {
            throw new IllegalArgumentException("linkType is required");
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri is required");
        }
        this.linkType = linkType;
        this.uri = uri;
    }

    public LinkTypeIdentifier getLinkTypeId() {
        return this.linkType;
    }

    public URI getUri() {
        return this.uri;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.linkType == null ? 0 : this.linkType.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalLink other = (ExternalLink)obj;
        if (this.linkType == null ? other.linkType != null : !this.linkType.equals(other.linkType)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return "ExternalLink [linkType=" + this.linkType + ", uri=" + this.uri + "]";
    }
}

