/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.gc;

import java.util.Collection;
import java.util.EnumSet;

public final class EnumOptionsUtils {
    private EnumOptionsUtils() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    public static <E extends Enum<E>> String[] toOptionsArray(Collection<E> options) {
        if (options == null) {
            return new String[0];
        }
        String[] result = new String[options.size()];
        int i = 0;
        for (Enum option : options) {
            result[i++] = option.toString();
        }
        return result;
    }

    public static <E extends Enum<E>> Collection<E> getOptions(Class<E> enumClass, String[] optionsArray) {
        EnumSet<E> result = EnumSet.noneOf(enumClass);
        if (optionsArray != null) {
            String[] stringArray = optionsArray;
            int n = optionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String optionStr = stringArray[n2];
                E value = Enum.valueOf(enumClass, optionStr);
                result.add(value);
                ++n2;
            }
        }
        return result;
    }
}

