/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.gc;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class CommonContextUtilities {
    private CommonContextUtilities() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    public static IProjectAreaHandle getProjectArea(IWorkspaceHandle handle, IItemFetcher itemFetcher, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handle instanceof IWorkspace) {
            return CommonContextUtilities.getProjectArea((IWorkspace)handle, itemFetcher, monitor);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IWorkspace workspace = itemFetcher.fetchCompleteItem((IItemHandle)handle, IWorkspace.class, (IProgressMonitor)progress.newChild(1));
        return CommonContextUtilities.getProjectArea(workspace, itemFetcher, (IProgressMonitor)progress.newChild(1));
    }

    public static IProjectAreaHandle getProjectArea(IWorkspace workspace, IItemFetcher itemFetcher, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle result = workspace.isStream() ? CommonContextUtilities.getProjectAreaOfStream(workspace, itemFetcher, monitor) : CommonContextUtilities.getProjectAreaOfWorkspace(workspace, itemFetcher, monitor);
        return result;
    }

    public static IProjectAreaHandle getProjectArea(IBaselineSetHandle handle, IItemFetcher itemFetcher, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IBaselineSet snapshot = itemFetcher.fetchCompleteItem((IItemHandle)handle, IBaselineSet.class, (IProgressMonitor)progress.newChild(1));
        return CommonContextUtilities.getProjectArea(snapshot, itemFetcher, (IProgressMonitor)progress.newChild(1));
    }

    public static IProjectAreaHandle getProjectArea(IBaselineSet snapshot, IItemFetcher itemFetcher, IProgressMonitor monitor) throws TeamRepositoryException {
        return CommonContextUtilities.getProjectArea(snapshot.getOwner(), itemFetcher, monitor);
    }

    private static IProjectAreaHandle getProjectAreaOfStream(IWorkspace stream, IItemFetcher itemFetcher, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle result;
        assert (stream.isStream());
        IAuditableHandle owner = stream.getOwner();
        if (owner instanceof IProjectAreaHandle) {
            result = (IProjectAreaHandle)owner;
        } else if (owner instanceof ITeamAreaHandle) {
            result = CommonContextUtilities.getProjectAreaOfTeamArea((ITeamAreaHandle)owner, itemFetcher, monitor);
        } else {
            throw new IllegalStateException("Owner is neither a project area nor a team area (" + owner.getClass().getName() + ")");
        }
        return result;
    }

    private static IProjectAreaHandle getProjectAreaOfTeamArea(ITeamAreaHandle teamAreaHandle, IItemFetcher itemFetcher, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamArea teamArea = itemFetcher.fetchCompleteItem((IItemHandle)teamAreaHandle, ITeamArea.class, monitor);
        return teamArea.getProjectArea();
    }

    private static IProjectAreaHandle getProjectAreaOfWorkspace(IWorkspace workspace, IItemFetcher itemFetcher, IProgressMonitor monitor) throws TeamRepositoryException {
        assert (!workspace.isStream());
        assert (workspace instanceof Workspace);
        Workspace w = (Workspace)workspace;
        CurrentFlows current = w.getCurrentFlows();
        UUID deliverId = current.getCurrentDeliverFlow();
        UUID acceptId = current.getCurrentAcceptFlow();
        ArrayList<IItemHandle> handles = NewCollection.arrayList();
        if (deliverId != null) {
            handles.add(IWorkspace.ITEM_TYPE.createItemHandle(deliverId, null));
        }
        if (acceptId != null) {
            handles.add(IWorkspace.ITEM_TYPE.createItemHandle(acceptId, null));
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(handles.size() + 1));
        Map<UUID, IWorkspace> streamItems = itemFetcher.fetchCompleteItems(handles, IWorkspace.class, (IProgressMonitor)progress.newChild(1));
        for (IItemHandle h : handles) {
            IProjectAreaHandle projectArea;
            SubMonitor iterationProgress = progress.newChild(1);
            IWorkspace stream = streamItems.get(h.getItemId());
            if (stream == null || !stream.isStream() || (projectArea = CommonContextUtilities.getProjectAreaOfStream(stream, itemFetcher, (IProgressMonitor)iterationProgress)) == null) continue;
            return projectArea;
        }
        return null;
    }

    public static interface IItemFetcher {
        public <T extends IItem> Map<UUID, T> fetchCompleteItems(Collection<? extends IItemHandle> var1, Class<T> var2, IProgressMonitor var3) throws TeamRepositoryException;

        public <T extends IItem> T fetchCompleteItem(IItemHandle var1, Class<T> var2, IProgressMonitor var3) throws TeamRepositoryException, ItemNotFoundException;
    }
}

