/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.flow;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.flow.FlowTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FlowTableUtil {
    public static void addAcceptFlow(IFlowTable flowTable, IWorkspaceHandle source, List<IComponentHandle> sourceComponents, IWorkspaceHandle target, List<IComponentHandle> targetComponents, UUID targetRepoId, String targetRepoUri) throws TeamRepositoryException {
        List acceptSources;
        if (target == null) {
            return;
        }
        List<IComponentHandle> components = FlowTableUtil.getCommonComponents(sourceComponents, targetComponents);
        IFlowEntry acceptFlow = ((FlowTable)flowTable).getAcceptFlow((IFlowNodeHandle)target, true);
        List componentHandles = Collections.EMPTY_LIST;
        if (acceptFlow != null) {
            componentHandles = acceptFlow.getComponentScopes();
        }
        flowTable.addAcceptFlow(target, targetRepoId, targetRepoUri, componentHandles, null);
        IFlowEntry deliverFlow = ((FlowTable)flowTable).getDeliverFlow((IFlowNodeHandle)target, true);
        if (deliverFlow == null) {
            flowTable.addDeliverFlow(target, targetRepoId, targetRepoUri, components, "PlaceHolder");
        }
        if ((acceptSources = ((FlowTable)flowTable).acceptSources(true)).size() == 1) {
            FlowTableUtil.setDefaultAcceptFlow(flowTable, target);
            FlowTableUtil.setCurrentAcceptFlow(flowTable, target);
        }
    }

    public static void addDeliverFlow(IFlowTable flowTable, IWorkspaceHandle source, List<IComponentHandle> sourceComponents, IWorkspaceHandle target, List<IComponentHandle> targetComponents, UUID targetRepoId, String targetRepoUri) throws TeamRepositoryException {
        List deliverTargets;
        if (target == null) {
            return;
        }
        List<IComponentHandle> components = FlowTableUtil.getCommonComponents(sourceComponents, targetComponents);
        IFlowEntry deliverFlow = ((FlowTable)flowTable).getDeliverFlow((IFlowNodeHandle)target, true);
        String description = null;
        if (deliverFlow != null && "Scoped".equals(deliverFlow.getDescription())) {
            description = deliverFlow.getDescription();
        }
        flowTable.addDeliverFlow(target, targetRepoId, targetRepoUri, components, description);
        IFlowEntry acceptFlow = ((FlowTable)flowTable).getAcceptFlow((IFlowNodeHandle)target, true);
        if (acceptFlow == null) {
            flowTable.addAcceptFlow(target, targetRepoId, targetRepoUri, Collections.EMPTY_LIST, "PlaceHolder");
        }
        if ((deliverTargets = ((FlowTable)flowTable).deliverTargets(true)).size() == 1) {
            FlowTableUtil.setDefaultDeliverFlow(flowTable, target);
            FlowTableUtil.setCurrentDeliverFlow(flowTable, target);
        }
    }

    private static List<IComponentHandle> getCommonComponents(List<IComponentHandle> components1, List<IComponentHandle> components2) throws TeamRepositoryException {
        ArrayList<IComponentHandle> result = new ArrayList<IComponentHandle>();
        block0: for (IComponentHandle componentHandle1 : components1) {
            for (IComponentHandle componentHandle2 : components2) {
                if (!componentHandle1.sameItemId((IItemHandle)componentHandle2)) continue;
                result.add(componentHandle1);
                continue block0;
            }
        }
        return result;
    }

    public static boolean setAcceptFlow(IFlowTable flowTable, IWorkspaceHandle source, List<IComponentHandle> sourceComponents, IWorkspaceHandle target, List<IComponentHandle> targetComponents, UUID targetRepoId, String targetRepoUri) throws TeamRepositoryException {
        return FlowTableUtil.setFlow(flowTable, source, sourceComponents, target, targetComponents, targetRepoId, targetRepoUri, 1);
    }

    public static boolean setDeliverFlow(IFlowTable flowTable, IWorkspaceHandle source, List<IComponentHandle> sourceComponents, IWorkspaceHandle target, List<IComponentHandle> targetComponents, UUID targetRepoId, String targetRepoUri) throws TeamRepositoryException {
        return FlowTableUtil.setFlow(flowTable, source, sourceComponents, target, targetComponents, targetRepoId, targetRepoUri, 2);
    }

    private static boolean setFlow(IFlowTable flowTable, IWorkspaceHandle source, List<IComponentHandle> sourceComponents, IWorkspaceHandle target, List<IComponentHandle> targetComponents, UUID targetRepoId, String targetRepoUri, int flowType) throws TeamRepositoryException {
        boolean changed = false;
        List flowEntries = null;
        flowEntries = (flowType & 1) != 0 ? flowTable.acceptSources() : flowTable.deliverTargets();
        boolean found = false;
        for (IFlowEntry flowEntry : flowEntries) {
            if (!target.getItemId().equals((Object)flowEntry.getFlowNode().getItemId())) continue;
            found = true;
        }
        if (!found) {
            if ((flowType & 1) != 0) {
                FlowTableUtil.addAcceptFlow(flowTable, source, sourceComponents, target, targetComponents, targetRepoId, targetRepoUri);
            } else {
                FlowTableUtil.addDeliverFlow(flowTable, source, sourceComponents, target, targetComponents, targetRepoId, targetRepoUri);
            }
            changed = true;
        }
        return changed;
    }

    public static boolean setCurrentAcceptFlow(IFlowTable flowTable, IWorkspaceHandle source, IWorkspaceHandle target) {
        return FlowTableUtil.setCurrentFlow(flowTable, source, target, 1);
    }

    public static boolean setCurrentDeliverFlow(IFlowTable flowTable, IWorkspaceHandle source, IWorkspaceHandle target) {
        return FlowTableUtil.setCurrentFlow(flowTable, source, target, 2);
    }

    private static boolean setCurrentFlow(IFlowTable flowTable, IWorkspaceHandle source, IWorkspaceHandle target, int flowType) {
        boolean changed = false;
        IFlowEntry oldCurrentFlowTargetEntry = null;
        oldCurrentFlowTargetEntry = (flowType & 1) != 0 ? flowTable.getCurrentAcceptFlow() : flowTable.getCurrentDeliverFlow();
        if (target == null) {
            if (oldCurrentFlowTargetEntry != null) {
                if ((flowType & 1) != 0) {
                    FlowTableUtil.setCurrentAcceptFlow(flowTable, null);
                } else {
                    FlowTableUtil.setCurrentDeliverFlow(flowTable, null);
                }
                changed = true;
            }
        } else if (!target.getItemId().equals(oldCurrentFlowTargetEntry != null ? oldCurrentFlowTargetEntry.getFlowNode().getItemId() : null)) {
            IFlowEntry flowEntry;
            IWorkspaceHandle currentFlowTarget = target;
            IFlowEntry iFlowEntry = flowEntry = (flowType & 1) != 0 ? flowTable.getAcceptFlow(target) : flowTable.getDeliverFlow(target);
            if (flowEntry == null && source.sameItemId((IItemHandle)target)) {
                currentFlowTarget = null;
            }
            if ((flowType & 1) != 0) {
                FlowTableUtil.setCurrentAcceptFlow(flowTable, currentFlowTarget);
            } else {
                FlowTableUtil.setCurrentDeliverFlow(flowTable, currentFlowTarget);
            }
            changed = true;
        }
        return changed;
    }

    private static void setCurrentAcceptFlow(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentAcceptFlow();
        } else {
            IFlowEntry acceptEntry = flowTable.getAcceptFlow(target);
            if (acceptEntry != null) {
                flowTable.setCurrent(acceptEntry);
            }
        }
    }

    private static void setCurrentDeliverFlow(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentDeliverFlow();
        } else {
            IFlowEntry deliverEntry = flowTable.getDeliverFlow(target);
            if (deliverEntry != null) {
                flowTable.setCurrent(deliverEntry);
            }
        }
    }

    public static boolean setDefaultAcceptFlow(IFlowTable flowTable, IWorkspaceHandle source, IWorkspaceHandle target) {
        return FlowTableUtil.setDefaultFlow(flowTable, source, target, 1);
    }

    public static boolean setDefaultDeliverFlow(IFlowTable flowTable, IWorkspaceHandle source, IWorkspaceHandle target) {
        return FlowTableUtil.setDefaultFlow(flowTable, source, target, 2);
    }

    private static boolean setDefaultFlow(IFlowTable flowTable, IWorkspaceHandle source, IWorkspaceHandle target, int flowType) {
        boolean changed = false;
        IFlowEntry oldDefaultFlowTargetEntry = null;
        oldDefaultFlowTargetEntry = (flowType & 1) != 0 ? flowTable.getDefaultAcceptFlow() : flowTable.getDefaultDeliverFlow();
        if (target == null) {
            if (oldDefaultFlowTargetEntry != null) {
                if ((flowType & 1) != 0) {
                    FlowTableUtil.setDefaultAcceptFlow(flowTable, null);
                } else {
                    FlowTableUtil.setDefaultDeliverFlow(flowTable, null);
                }
                changed = true;
            }
        } else if (!target.getItemId().equals(oldDefaultFlowTargetEntry != null ? oldDefaultFlowTargetEntry.getFlowNode().getItemId() : null)) {
            IFlowEntry flowEntry;
            IWorkspaceHandle defaultFlowTarget = target;
            IFlowEntry iFlowEntry = flowEntry = (flowType & 1) != 0 ? flowTable.getAcceptFlow(target) : flowTable.getDeliverFlow(target);
            if (flowEntry == null && source.sameItemId((IItemHandle)target)) {
                defaultFlowTarget = null;
            }
            if ((flowType & 1) != 0) {
                FlowTableUtil.setDefaultAcceptFlow(flowTable, defaultFlowTarget);
            } else {
                FlowTableUtil.setDefaultDeliverFlow(flowTable, defaultFlowTarget);
            }
            changed = true;
        }
        return changed;
    }

    private static void setDefaultAcceptFlow(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetDefaultAcceptFlow();
        } else {
            IFlowEntry acceptEntry = flowTable.getAcceptFlow(target);
            if (acceptEntry != null) {
                flowTable.setDefault(acceptEntry);
            }
        }
    }

    private static void setDefaultDeliverFlow(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetDefaultDeliverFlow();
        } else {
            IFlowEntry deliverEntry = flowTable.getDeliverFlow(target);
            if (deliverEntry != null) {
                flowTable.setDefault(deliverEntry);
            }
        }
    }

    public static boolean removeAcceptFlow(IFlowTable flowTable, IFlowNodeHandle target) throws TeamRepositoryException {
        boolean changed = false;
        IFlowEntry acceptEntry = flowTable.getAcceptFlow(target);
        if (acceptEntry != null) {
            if (flowTable.getCurrentAcceptFlow() != null && flowTable.getCurrentAcceptFlow().getFlowNode().sameItemId((IItemHandle)acceptEntry.getFlowNode())) {
                flowTable.unsetCurrentAcceptFlow();
            }
            if (flowTable.getDefaultAcceptFlow() != null && flowTable.getDefaultAcceptFlow().getFlowNode().sameItemId((IItemHandle)acceptEntry.getFlowNode())) {
                flowTable.unsetDefaultAcceptFlow();
            }
            flowTable.setFlowEntryDescription(acceptEntry, "PlaceHolder");
            changed = true;
        }
        return changed;
    }

    public static boolean removeDeliverFlow(IFlowTable flowTable, IFlowNodeHandle target) throws TeamRepositoryException {
        boolean changed = false;
        IFlowEntry deliverEntry = flowTable.getDeliverFlow(target);
        if (deliverEntry != null) {
            if (flowTable.getCurrentDeliverFlow() != null && flowTable.getCurrentDeliverFlow().getFlowNode().sameItemId((IItemHandle)deliverEntry.getFlowNode())) {
                flowTable.unsetCurrentDeliverFlow();
            }
            if (flowTable.getDefaultDeliverFlow() != null && flowTable.getDefaultDeliverFlow().getFlowNode().sameItemId((IItemHandle)deliverEntry.getFlowNode())) {
                flowTable.unsetDefaultDeliverFlow();
            }
            flowTable.setFlowEntryDescription(deliverEntry, "PlaceHolder");
            changed = true;
        }
        return changed;
    }
}

