/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.dto.impl;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import com.ibm.team.scm.common.internal.dto.ComponentLocks;
import com.ibm.team.scm.common.internal.dto.ContributorLocks;
import com.ibm.team.scm.common.internal.dto.impl.VersionableReport;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ComponentReport
implements IComponentLockReport {
    private final IComponentHandle component;
    private final Map<UUID, IVersionableLock> versionableLocks;

    public ComponentReport(ComponentLocks l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.component = l.getComponent();
        this.versionableLocks = new LinkedHashMap<UUID, IVersionableLock>();
        for (ContributorLocks lock : l.getContributorLocks()) {
            IContributorHandle contrib = lock.getContributor();
            for (IVersionableHandle vh : lock.getVersionables()) {
                this.versionableLocks.put(vh.getItemId(), new VersionableReport(contrib, vh));
            }
        }
    }

    public ComponentReport(IComponentHandle componentHandle, Collection<IVersionableLock> locks) {
        this.component = componentHandle;
        this.versionableLocks = new LinkedHashMap<UUID, IVersionableLock>();
        for (IVersionableLock vl : locks) {
            this.versionableLocks.put(vl.getVersionable().getItemId(), vl);
        }
    }

    @Override
    public IComponentHandle getComponent() {
        return this.component;
    }

    @Override
    public Collection<IVersionableLock> getLocks() {
        return Collections.unmodifiableCollection(this.versionableLocks.values());
    }

    @Override
    public IVersionableLock getLockReport(IVersionableHandle versionable) {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        return this.versionableLocks.get(versionable.getItemId());
    }

    @Override
    public IVersionableLock getLockReport(UUID versionableItemId) {
        if (versionableItemId == null) {
            throw new IllegalArgumentException();
        }
        return this.versionableLocks.get(versionableItemId);
    }

    public void addVersionableLock(IVersionableLock versionableReport) {
        UUID versionable = versionableReport.getVersionable().getItemId();
        if (this.versionableLocks.containsKey(versionable)) {
            throw new IllegalStateException();
        }
        this.versionableLocks.put(versionable, versionableReport);
    }
}

