/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.dto;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ConfigurationHandle;
import com.ibm.team.scm.common.internal.ScmPackage;
import com.ibm.team.scm.common.internal.dto.ConfigurationProvider;
import com.ibm.team.scm.common.internal.dto.HistoryProvider;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.ServiceHistoryProvider;

public interface ServiceConfigurationProvider {
    public static final IConfigurationProviderFactory FACTORY = new IConfigurationProviderFactory(){

        @Override
        public ServiceConfigurationProvider create(IWorkspaceHandle ws, IComponentHandle c) {
            if (ws == null || c == null) {
                throw new IllegalArgumentException();
            }
            ConfigurationProvider p = ScmDtoFactory.eINSTANCE.createConfigurationProvider();
            p.setWorkspaceComponentPair(ScmDtoFactory.eINSTANCE.createWorkspaceComponentPair());
            p.getWorkspaceComponentPair().setWorkspace(ws);
            p.getWorkspaceComponentPair().setComponent(c);
            return p;
        }

        @Override
        public ServiceConfigurationProvider create(IBaselineHandle bh) {
            if (bh == null) {
                throw new IllegalArgumentException();
            }
            ConfigurationProvider p = ScmDtoFactory.eINSTANCE.createConfigurationProvider();
            p.setBaseline(bh);
            return p;
        }

        @Override
        public ServiceConfigurationProvider create(ChangeHistoryHandle chh) {
            if (chh == null) {
                throw new IllegalArgumentException();
            }
            ConfigurationProvider p = ScmDtoFactory.eINSTANCE.createConfigurationProvider();
            p.setChangeHistory(chh);
            return p;
        }

        @Override
        public ServiceConfigurationProvider create(ConfigurationHandle ch) {
            if (ch == null) {
                throw new IllegalArgumentException();
            }
            ConfigurationProvider p = ScmDtoFactory.eINSTANCE.createConfigurationProvider();
            p.setConfiguration(ch);
            return p;
        }

        @Override
        public ServiceConfigurationProvider create(IContextHandle context, IComponentHandle component) {
            if (context instanceof IWorkspaceHandle) {
                return FACTORY.create((IWorkspaceHandle)context, component);
            }
            return FACTORY.create((IBaselineHandle)context);
        }

        @Override
        public ServiceConfigurationProvider create(ServiceHistoryProvider historyProvider) {
            HistoryProvider provider = (HistoryProvider)historyProvider;
            if (provider.getBaseline() != null) {
                return this.create(provider.getBaseline());
            }
            if (provider.getWorkspaceComponentPair() != null) {
                return this.create(provider.getWorkspaceComponentPair().getWorkspace(), provider.getWorkspaceComponentPair().getComponent());
            }
            if (provider.getChangeHistory() != null) {
                return this.create(provider.getChangeHistory());
            }
            throw new IllegalArgumentException("Unsupported history provider for folder history");
        }

        @Override
        public ServiceConfigurationProvider createForChangeHistoryId(UUID changeHistoryId) {
            IItemType itemType = IItemType.IRegistry.INSTANCE.getItemType(ScmPackage.eINSTANCE.getChangeHistory().getName(), "com.ibm.team.scm");
            ChangeHistoryHandle handle = (ChangeHistoryHandle)itemType.createItemHandle(changeHistoryId, null);
            return this.create(handle);
        }
    };

    public static interface IConfigurationProviderFactory {
        public ServiceConfigurationProvider create(IContextHandle var1, IComponentHandle var2);

        public ServiceConfigurationProvider create(IWorkspaceHandle var1, IComponentHandle var2);

        public ServiceConfigurationProvider create(IBaselineHandle var1);

        public ServiceConfigurationProvider create(ChangeHistoryHandle var1);

        public ServiceConfigurationProvider create(ConfigurationHandle var1);

        public ServiceConfigurationProvider create(ServiceHistoryProvider var1);

        public ServiceConfigurationProvider createForChangeHistoryId(UUID var1);
    }
}

