/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.dto;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.internal.dto.ComponentLocks;
import com.ibm.team.scm.common.internal.dto.WorkspaceLocks;
import com.ibm.team.scm.common.internal.dto.impl.ComponentReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LockReport
implements IStreamLockReport {
    private final IWorkspaceHandle workspace;
    private final Map<UUID, IComponentLockReport> reports;

    public LockReport(WorkspaceLocks dto) {
        this(dto.getWorkspace(), LockReport.getComponentLocks(dto));
    }

    private static List<IComponentLockReport> getComponentLocks(WorkspaceLocks dto) {
        ArrayList<IComponentLockReport> componentLocks = new ArrayList<IComponentLockReport>();
        for (ComponentLocks l : dto.getComponentLocks()) {
            ComponentReport report = new ComponentReport(l);
            componentLocks.add(report);
        }
        return componentLocks;
    }

    public LockReport(IWorkspaceHandle workspaceHandle, Collection<IComponentLockReport> componentLocks) {
        this.workspace = workspaceHandle;
        this.reports = new LinkedHashMap<UUID, IComponentLockReport>();
        for (IComponentLockReport report : componentLocks) {
            this.reports.put(report.getComponent().getItemId(), report);
        }
    }

    @Override
    public Collection<IComponentLockReport> getComponentLocks() {
        return Collections.unmodifiableCollection(this.reports.values());
    }

    @Override
    public IWorkspaceHandle getStream() {
        return this.workspace;
    }

    @Override
    public IComponentLockReport getComponentLockReport(IComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        return this.reports.get(component.getItemId());
    }

    public void addComponentReport(IComponentLockReport componentReport) {
        if (this.reports.containsKey(componentReport.getComponent().getItemId())) {
            throw new IllegalArgumentException();
        }
        this.reports.put(componentReport.getComponent().getItemId(), componentReport);
    }
}

