/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.customattributes;

public interface ICustomAttributeNamespaceProvider {
    public static ICustomAttributeNamespaceProvider getDefaultNamespaceProvider() {
        return new ICustomAttributeNamespaceProvider(){

            @Override
            public String getQualifiedAttributeName(String attrName) {
                return attrName;
            }

            @Override
            public String filterNamespaceFromCustomAttribute(String key) {
                return key;
            }
        };
    }

    public static ICustomAttributeNamespaceProvider getChangeSetNamespaceProvider() {
        final String namespace = "cs_custom_attr_namespace:";
        return new ICustomAttributeNamespaceProvider(){

            @Override
            public String getQualifiedAttributeName(String attrName) {
                if (attrName.startsWith(namespace)) {
                    return attrName;
                }
                return namespace + attrName;
            }

            @Override
            public String filterNamespaceFromCustomAttribute(String key) {
                int index = key.indexOf(key);
                if (index > 0) {
                    throw new IllegalArgumentException("Invalid custom attribute name.");
                }
                if (index < 0) {
                    return key;
                }
                return key.substring(namespace.length());
            }
        };
    }

    public String getQualifiedAttributeName(String var1) throws IllegalArgumentException;

    public String filterNamespaceFromCustomAttribute(String var1) throws IllegalArgumentException;
}

